/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import io.undertow.websockets.jsr.handshake.WebSocketHttpExchange;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletWebSocketHttpExchange
implements WebSocketHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpServerExchange exchange;

    public ServletWebSocketHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.exchange = ServletRequestContext.requireCurrent().getOriginalRequest().getExchange();
    }

    @Override
    public <T> void putAttachment(AttachmentKey<T> key, T value) {
        this.exchange.putAttachment(key, value);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)this.exchange.getAttachment(key);
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            Enumeration theHeaders = this.request.getHeaders(header);
            ArrayList vals = new ArrayList();
            headers.put(header, vals);
            while (theHeaders.hasMoreElements()) {
                vals.add(theHeaders.nextElement());
            }
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.response.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap headers = new HashMap();
        Collection headerNames = this.response.getHeaderNames();
        for (String header : headerNames) {
            headers.put(header, new ArrayList(this.response.getHeaders(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        for (String string : this.response.getHeaderNames()) {
            this.response.setHeader(string, null);
        }
        for (Map.Entry entry : headers.entrySet()) {
            for (String val : (List)entry.getValue()) {
                this.response.addHeader((String)entry.getKey(), val);
            }
        }
    }

    @Override
    public void setResponseHeader(String headerName, String headerValue) {
        this.response.setHeader(headerName, headerValue);
    }

    @Override
    public void upgradeChannel(Consumer<Object> listener) {
        this.exchange.upgradeChannel(listener);
    }

    @Override
    public void endExchange() {
    }

    @Override
    public void close() {
        this.exchange.endExchange();
    }

    @Override
    public String getRequestScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI() + (this.request.getQueryString() == null ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public Object getSession() {
        return this.request.getSession(false);
    }

    @Override
    public Map<String, List<String>> getRequestParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Map.Entry param : this.request.getParameterMap().entrySet()) {
            params.put((String)param.getKey(), (List<String>)new ArrayList<Object>(Arrays.asList((Object[])param.getValue())));
        }
        return params;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public Executor getExecutor() {
        return this.exchange.getWorker();
    }
}

