/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.UndertowLogger;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.PathTemplateMatcher;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.ServletWebSocketHttpExchange;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import io.undertow.websockets.jsr.handshake.Handshake;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.websocket.CloseReason;
import javax.websocket.server.ServerContainer;

public class JsrWebSocketFilter
implements Filter {
    private EndpointSessionHandler callback;
    private PathTemplateMatcher<ServerWebSocketContainer.WebSocketHandshakeHolder> pathTemplateMatcher;
    private ServerWebSocketContainer container;
    private static final String SESSION_ATTRIBUTE = "io.undertow.websocket.current-connections";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        this.container.deploymentComplete();
        this.pathTemplateMatcher = new PathTemplateMatcher();
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)filterConfig.getServletContext().getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        for (ConfiguredServerEndpoint endpoint : this.container.getConfiguredServerEndpoints()) {
            if (info == null || info.getServerExtensions().isEmpty()) {
                this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)ServerWebSocketContainer.handshakes(endpoint));
                continue;
            }
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)ServerWebSocketContainer.handshakes(endpoint, info.getServerExtensions()));
        }
        this.callback = new EndpointSessionHandler(this.container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            PathTemplateMatcher.PathMatchResult matchResult;
            final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : ((ServerWebSocketContainer.WebSocketHandshakeHolder)matchResult.getValue()).handshakes) {
                    if (!method.matches(facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker != null) {
                    if (this.container.isClosed()) {
                        resp.sendError(503);
                        return;
                    }
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, matchResult.getParameters());
                    facade.putAttachment(HandshakeUtil.PRINCIPAL, req.getUserPrincipal());
                    final Handshake selected = handshaker;
                    final ServletRequestContext src = ServletRequestContext.requireCurrent();
                    final HttpSessionImpl session = src.getCurrentServletContext().getSession(src.getExchange(), false);
                    handshaker.handshake(facade, new Consumer<ChannelHandlerContext>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(ChannelHandlerContext context) {
                            final UndertowSession channel = JsrWebSocketFilter.this.callback.connected(context, selected.getConfig(), facade, src.getOriginalResponse().getHeader(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL.toString()));
                            if (session != null && channel != null) {
                                ArrayList<UndertowSession> connections;
                                final Session underlying = System.getSecurityManager() == null ? session.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)session));
                                Session session2 = underlying;
                                synchronized (session2) {
                                    connections = (ArrayList<UndertowSession>)underlying.getAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE);
                                    if (connections == null) {
                                        connections = new ArrayList<UndertowSession>();
                                        underlying.setAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE, connections);
                                    }
                                    connections.add(channel);
                                }
                                final ArrayList<UndertowSession> finalConnections = connections;
                                context.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void operationComplete(Future<? super Void> future) throws Exception {
                                        Session session = underlying;
                                        synchronized (session) {
                                            finalConnections.remove(channel);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static class LogoutListener
    implements HttpSessionListener {
        public void sessionCreated(HttpSessionEvent se) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDestroyed(HttpSessionEvent se) {
            HttpSessionImpl session = (HttpSessionImpl)se.getSession();
            Session underlying = System.getSecurityManager() == null ? session.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)session));
            List connections = (List)underlying.getAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE);
            if (connections != null) {
                Session session2 = underlying;
                synchronized (session2) {
                    for (UndertowSession c : connections) {
                        try {
                            c.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, ""));
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException((Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

