/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.jsr.JsrWebSocketLogger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.websocket.server.PathParam;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class JsrWebSocketLogger_$logger
extends DelegatingBasicLogger
implements JsrWebSocketLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JsrWebSocketLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public JsrWebSocketLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void endpointCreationFailed(Exception cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.endpointCreationFailed$str(), new Object[0]);
    }

    protected String endpointCreationFailed$str() {
        return "UT026001: Unable to instantiate endpoint";
    }

    @Override
    public final void couldNotInitializeConfiguration(Class<?> clazz, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.couldNotInitializeConfiguration$str(), clazz);
    }

    protected String couldNotInitializeConfiguration$str() {
        return "UT026002: Unable to instantiate server configuration %s";
    }

    @Override
    public final void addingAnnotatedServerEndpoint(Class<?> endpoint, String value) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addingAnnotatedServerEndpoint$str(), endpoint, (Object)value);
    }

    protected String addingAnnotatedServerEndpoint$str() {
        return "UT026003: Adding annotated server endpoint %s for path %s";
    }

    @Override
    public final void addingAnnotatedClientEndpoint(Class<?> endpoint) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addingAnnotatedClientEndpoint$str(), endpoint);
    }

    protected String addingAnnotatedClientEndpoint$str() {
        return "UT026004: Adding annotated client endpoint %s";
    }

    @Override
    public final void addingProgramaticEndpoint(Class<?> endpointClass, String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addingProgramaticEndpoint$str(), endpointClass, (Object)path);
    }

    protected String addingProgramaticEndpoint$str() {
        return "UT026005: Adding programmatic server endpoint %s for path %s";
    }

    @Override
    public final void exceptionInWebSocketMethod(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.exceptionInWebSocketMethod$str(), new Object[0]);
    }

    protected String exceptionInWebSocketMethod$str() {
        return "UT026006: Exception running web socket method";
    }

    @Override
    public final void pathTemplateNotFound(Class<?> endpointClass, PathParam param, Method method, Set<String> paths) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.pathTemplateNotFound$str(), new Object[]{endpointClass, param, method, paths});
    }

    protected String pathTemplateNotFound$str() {
        return "UT026007: On Endpoint class %s path param %s on method %s does not reference a valid parameter, valid parameters are %s.";
    }

    @Override
    public final void couldNotCloseOnUndeploy(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotCloseOnUndeploy$str(), new Object[0]);
    }

    protected String couldNotCloseOnUndeploy$str() {
        return "UT026008: Could not close endpoint on undeploy.";
    }

    @Override
    public final void xnioWorkerWasNull() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.xnioWorkerWasNull$str(), new Object[0]);
    }

    protected String xnioWorkerWasNull$str() {
        return "UT026009: XNIO worker was not set on WebSocketDeploymentInfo, the default worker will be used";
    }

    @Override
    public final void bufferPoolWasNull() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.bufferPoolWasNull$str(), new Object[0]);
    }

    protected String bufferPoolWasNull$str() {
        return "UT026010: Buffer pool was not set on WebSocketDeploymentInfo, the default pool will be used";
    }

    protected String xnioWorkerWasNullAndNoDefault$str() {
        return "UT026011: XNIO worker was not set on WebSocketDeploymentInfo, and there is no default to use";
    }

    @Override
    public final IllegalArgumentException xnioWorkerWasNullAndNoDefault() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.xnioWorkerWasNullAndNoDefault$str(), new Object[0]));
        JsrWebSocketLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String bufferPoolWasNullAndNoDefault$str() {
        return "UT026012: Buffer pool was not set on WebSocketDeploymentInfo, and there is no default to use";
    }

    @Override
    public final IllegalArgumentException bufferPoolWasNullAndNoDefault() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.bufferPoolWasNullAndNoDefault$str(), new Object[0]));
        JsrWebSocketLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unhandledErrorInAnnotatedEndpoint(Object instance, Throwable thr) {
        this.log.logf(FQCN, Logger.Level.ERROR, thr, this.unhandledErrorInAnnotatedEndpoint$str(), instance);
    }

    protected String unhandledErrorInAnnotatedEndpoint$str() {
        return "UT026013: Unhandled error in annotated endpoint %s";
    }
}

