/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.attribute.StackMapFrameInfo;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class StackMapBuilder {
    private final ArrayList<StackMapFrameInfo.VerificationTypeInfo> stack = new ArrayList();
    private final ArrayList<StackMapFrameInfo.VerificationTypeInfo> locals = new ArrayList();
    private final ArrayList<StackMapFrameInfo> frameInfos = new ArrayList();
    private boolean wroteCode;
    private final HashMap<List<StackMapFrameInfo.VerificationTypeInfo>, List<StackMapFrameInfo.VerificationTypeInfo>> lists = new HashMap();
    private final HashMap<String, StackMapFrameInfo.ObjectVerificationTypeInfo> vtiCache = new HashMap();

    public Saved save() {
        return new Saved((StackMapFrameInfo.VerificationTypeInfo[])this.stack.toArray(StackMapFrameInfo.VerificationTypeInfo[]::new), (StackMapFrameInfo.VerificationTypeInfo[])this.locals.toArray(StackMapFrameInfo.VerificationTypeInfo[]::new));
    }

    public void restore(Saved state) {
        this.stack.clear();
        Collections.addAll(this.stack, state.stack);
        this.locals.clear();
        Collections.addAll(this.locals, state.locals);
    }

    public void push(StackMapFrameInfo.VerificationTypeInfo vti) {
        if (StackMapBuilder.isClass2(vti)) {
            this.stack.add((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.TOP);
        }
        this.stack.add(vti);
    }

    public void push(ClassDesc type) {
        this.push(this.verificationTypeOf(type));
    }

    public void clearStack() {
        this.stack.clear();
    }

    public StackMapFrameInfo.VerificationTypeInfo pop() {
        try {
            StackMapFrameInfo.VerificationTypeInfo result = this.stack.remove(this.stack.size() - 1);
            if (StackMapBuilder.isClass2(result)) {
                StackMapFrameInfo.VerificationTypeInfo top = this.stack.remove(this.stack.size() - 1);
                assert (top == StackMapFrameInfo.SimpleVerificationTypeInfo.TOP);
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("Stack underflow");
        }
    }

    public StackMapFrameInfo.VerificationTypeInfo load(int localIdx) {
        return this.locals.get(localIdx);
    }

    public void store(int localIdx, StackMapFrameInfo.VerificationTypeInfo vti) {
        if (StackMapBuilder.isClass2(vti)) {
            this.growLocals(localIdx + 1);
            this.locals.set(localIdx, vti);
            this.locals.set(localIdx + 1, (StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.TOP);
        } else {
            this.growLocals(localIdx);
            this.locals.set(localIdx, vti);
        }
    }

    public void store(int localIdx, ClassDesc type) {
        this.store(localIdx, this.verificationTypeOf(type));
    }

    public void addFrameInfo(CodeBuilder cb) {
        if (this.wroteCode) {
            this.wroteCode = false;
            this.frameInfos.add(StackMapFrameInfo.of((Label)cb.newBoundLabel(), this.snapshotLocals(), this.snapshotStack()));
        } else if (!this.frameInfos.isEmpty()) {
            this.frameInfos.set(this.frameInfos.size() - 1, StackMapFrameInfo.of((Label)cb.newBoundLabel(), this.snapshotLocals(), this.snapshotStack()));
        }
    }

    public void wroteCode() {
        this.wroteCode = true;
    }

    private static boolean isClass2(StackMapFrameInfo.VerificationTypeInfo vti) {
        return vti == StackMapFrameInfo.SimpleVerificationTypeInfo.LONG || vti == StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
    }

    private void growLocals(int idx) {
        this.locals.ensureCapacity(idx + 1);
        while (this.locals.size() <= idx) {
            this.locals.add((StackMapFrameInfo.VerificationTypeInfo)StackMapFrameInfo.SimpleVerificationTypeInfo.TOP);
        }
    }

    private List<StackMapFrameInfo.VerificationTypeInfo> snapshotLocals() {
        int end;
        for (end = this.locals.size(); end > 0 && this.locals.get(end - 1) == StackMapFrameInfo.SimpleVerificationTypeInfo.TOP; --end) {
        }
        if (end == 0) {
            return List.of();
        }
        if (end == 1) {
            return this.cachedList(List.of(this.locals.get(0)));
        }
        ArrayList<StackMapFrameInfo.VerificationTypeInfo> result = new ArrayList<StackMapFrameInfo.VerificationTypeInfo>(end);
        for (int i = 0; i < end; ++i) {
            StackMapFrameInfo.VerificationTypeInfo vti = this.locals.get(i);
            result.add(vti);
            if (!StackMapBuilder.isClass2(vti)) continue;
            ++i;
        }
        return this.cachedList(result);
    }

    private List<StackMapFrameInfo.VerificationTypeInfo> snapshotStack() {
        int sz = this.stack.size();
        if (sz == 0) {
            return List.of();
        }
        ArrayList<StackMapFrameInfo.VerificationTypeInfo> result = new ArrayList<StackMapFrameInfo.VerificationTypeInfo>(sz);
        for (int i = sz - 1; i >= 0; --i) {
            StackMapFrameInfo.VerificationTypeInfo vti = this.stack.get(i);
            result.add(vti);
            if (!StackMapBuilder.isClass2(vti)) continue;
            --i;
        }
        Collections.reverse(result);
        return this.cachedList(result);
    }

    private List<StackMapFrameInfo.VerificationTypeInfo> cachedList(List<StackMapFrameInfo.VerificationTypeInfo> result) {
        List<StackMapFrameInfo.VerificationTypeInfo> list = this.lists.get(result);
        if (list == null) {
            list = List.copyOf(result);
            this.lists.put(list, list);
        }
        return list;
    }

    List<StackMapFrameInfo> frameInfos() {
        return this.frameInfos;
    }

    private StackMapFrameInfo.VerificationTypeInfo verificationTypeOf(ClassDesc type) {
        String ds = type.descriptorString();
        return switch (ds.charAt(0)) {
            case 'B', 'C', 'I', 'S', 'Z' -> StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER;
            case 'J' -> StackMapFrameInfo.SimpleVerificationTypeInfo.LONG;
            case 'F' -> StackMapFrameInfo.SimpleVerificationTypeInfo.FLOAT;
            case 'D' -> StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
            case 'L', '[' -> {
                StackMapFrameInfo.ObjectVerificationTypeInfo vti = this.vtiCache.get(ds);
                if (vti == null) {
                    vti = StackMapFrameInfo.ObjectVerificationTypeInfo.of((ClassDesc)type);
                    this.vtiCache.put(ds, vti);
                }
                yield vti;
            }
            default -> throw Assert.impossibleSwitchCase((Object)ds);
        };
    }

    public static final class Saved {
        private final StackMapFrameInfo.VerificationTypeInfo[] stack;
        private final StackMapFrameInfo.VerificationTypeInfo[] locals;

        Saved(StackMapFrameInfo.VerificationTypeInfo[] stack, StackMapFrameInfo.VerificationTypeInfo[] locals) {
            this.stack = stack;
            this.locals = locals;
        }
    }
}

