/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Grouping;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.Reproducibility;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.annotation.SuppressForbidden;
import java.lang.constant.ClassDesc;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

@SuppressForbidden(reason="Using Type.toString() to build an informative message")
public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    static final String ADD_OBSERVERS = "addObservers";
    static final String ADD_REMOVED_BEANS = "addRemovedBeans";
    static final String ADD_BEANS = "addBeans";
    private static final int BEAN_GROUP_SIZE = 30;
    private static final int OBSERVER_GROUP_SIZE = 30;
    private static final int REMOVED_BEAN_GROUP_SIZE = 5;
    private static final int CONTAINER_SIZE = 10;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final boolean detectUnusedFalsePositives;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals, boolean generateSources, boolean detectUnusedFalsePositives) {
        super(generateSources);
        this.annotationLiterals = annotationLiterals;
        this.detectUnusedFalsePositives = detectUnusedFalsePositives;
    }

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName, Map<DotName, String> scopeToContextInstances) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        Gizmo gizmo = ComponentsProviderGenerator.gizmo(classOutput);
        this.createComponentsProvider(gizmo, name, beanDeployment, beanToGeneratedName, observerToGeneratedName, scopeToContextInstances);
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            resources.add(resource);
            if (!resource.getName().endsWith(COMPONENTS_PROVIDER_SUFFIX)) continue;
            resources.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(StandardCharsets.UTF_8), null));
        }
        return resources;
    }

    private void createComponentsProvider(Gizmo gizmo, String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName, Map<DotName, String> scopeToContextInstances) {
        CodeGenInfo info = this.preprocess(beanDeployment);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        gizmo.class_(generatedName, cc -> {
            cc.implements_(ComponentsProvider.class);
            cc.defaultConstructor();
            cc.method("getComponents", mc -> {
                mc.returning(Components.class);
                ParamVar currentContextFactory = mc.parameter("currentContextFactory", CurrentContextFactory.class);
                mc.body(bc -> {
                    LocalVar contextInstances;
                    LocalVar removedBeansSupplier;
                    LocalVar beanIdToBean = bc.localVar("beanIdToBean", bc.new_(HashMap.class));
                    for (Container<BeanGroup> container : info.beans()) {
                        for (BeanGroup beanGroup : container) {
                            ClassMethodDesc desc2 = ClassMethodDesc.of((ClassDesc)ClassDesc.of(container.className(generatedName, ADD_BEANS)), (String)(ADD_BEANS + beanGroup.id()), Void.TYPE, (Class[])new Class[]{Map.class});
                            bc.invokeStatic((MethodDesc)desc2, (Expr)beanIdToBean);
                        }
                    }
                    LocalVar beans = bc.localVar("beans", bc.withMap((Expr)beanIdToBean).values());
                    this.generateAddBeans(generatedName, gizmo, info, beanToGeneratedName);
                    LocalVar observers = bc.localVar("observers", bc.new_(ArrayList.class));
                    for (Container container : info.observers()) {
                        for (ObserverGroup observerGroup : container) {
                            ClassMethodDesc desc = ClassMethodDesc.of((ClassDesc)ClassDesc.of(container.className(generatedName, ADD_OBSERVERS)), (String)(ADD_OBSERVERS + observerGroup.id()), Void.TYPE, (Class[])new Class[]{Map.class, List.class});
                            bc.invokeStatic((MethodDesc)desc, (Expr)beanIdToBean, (Expr)observers);
                        }
                    }
                    this.generateAddObservers(generatedName, gizmo, info, observerToGeneratedName);
                    ContextConfigurator.CreateGeneration createGeneration = new ContextConfigurator.CreateGeneration(){
                        final /* synthetic */ BlockCreator val$bc;
                        final /* synthetic */ ParamVar val$currentContextFactory;
                        {
                            this.val$bc = blockCreator;
                            this.val$currentContextFactory = paramVar;
                        }

                        @Override
                        public BlockCreator method() {
                            return this.val$bc;
                        }

                        @Override
                        public Var currentContextFactory() {
                            return this.val$currentContextFactory;
                        }
                    };
                    LocalVar localVar = bc.localVar("contexts", bc.new_(ArrayList.class));
                    for (List list : beanDeployment.getCustomContexts().values()) {
                        for (Function creator : list) {
                            bc.withList((Expr)localVar).add((Expr)creator.apply(createGeneration));
                        }
                    }
                    LocalVar interceptorBindings = bc.localVar("interceptorBindings", bc.new_(HashSet.class));
                    for (ClassInfo binding2 : beanDeployment.getInterceptorBindings()) {
                        bc.withSet((Expr)interceptorBindings).add((Expr)Const.of((String)binding2.name().toString()));
                    }
                    LocalVar localVar2 = bc.localVar("transitiveBindings", bc.new_(HashMap.class));
                    beanDeployment.getTransitiveInterceptorBindings().forEach((binding, transitives) -> {
                        LocalVar transitivesSet = bc.localVar("transitives", bc.new_(HashSet.class));
                        for (AnnotationInstance transitive : transitives) {
                            ClassInfo transitiveClass = beanDeployment.getInterceptorBinding(transitive.name());
                            bc.withSet((Expr)transitivesSet).add(this.annotationLiterals.create((BlockCreator)bc, transitiveClass, transitive));
                        }
                        bc.withMap((Expr)transitiveBindings).put((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)binding)), (Expr)transitivesSet);
                    });
                    if (this.detectUnusedFalsePositives) {
                        removedBeansSupplier = bc.localVar("removedBeansSupplier", bc.lambda(Supplier.class, lc -> lc.body(lbc -> {
                            LocalVar removedBeans = lbc.localVar("removedBeans", lbc.new_(ArrayList.class));
                            LocalVar typeCache = lbc.localVar("typeCache", lbc.new_(HashMap.class));
                            for (Container<RemovedBeanGroup> container : info.removedBeans()) {
                                for (RemovedBeanGroup group : container) {
                                    ClassMethodDesc desc = ClassMethodDesc.of((ClassDesc)ClassDesc.of(container.className(generatedName, ADD_REMOVED_BEANS)), (String)(ADD_REMOVED_BEANS + group.id()), Void.TYPE, (Class[])new Class[]{List.class, Map.class});
                                    lbc.invokeStatic((MethodDesc)desc, (Expr)removedBeans, (Expr)typeCache);
                                }
                            }
                            lbc.return_((Expr)removedBeans);
                        })));
                        this.generateAddRemovedBeans(generatedName, gizmo, info);
                    } else {
                        removedBeansSupplier = bc.localVar("removedBeansSupplier", bc.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, bc.setOf(new Expr[0])));
                    }
                    LocalVar qualifiers = bc.localVar("qualifiers", bc.new_(HashSet.class));
                    for (ClassInfo qualifier2 : beanDeployment.getQualifiers()) {
                        bc.withSet((Expr)qualifiers).add((Expr)Const.of((String)qualifier2.name().toString()));
                    }
                    LocalVar qualifiersNonbindingMembers = bc.localVar("qualifiersNonbindingMembers", bc.new_(HashMap.class));
                    beanDeployment.getQualifierNonbindingMembers().forEach((qualifier, nonbindingMembers) -> {
                        LocalVar nonbindingMembersSet = bc.localVar("nonbindingMembers", bc.new_(HashSet.class));
                        for (String nonbindingMember : nonbindingMembers) {
                            bc.withSet((Expr)nonbindingMembersSet).add((Expr)Const.of((String)nonbindingMember));
                        }
                        bc.withMap((Expr)qualifiersNonbindingMembers).put((Expr)Const.of((String)qualifier.toString()), (Expr)nonbindingMembersSet);
                    });
                    if (scopeToContextInstances.isEmpty()) {
                        contextInstances = bc.localVar("contextInstances", bc.mapOf(new Expr[0]));
                    } else {
                        LocalVar contextInstancesFinal = bc.localVar("contextInstances", bc.new_(HashMap.class));
                        scopeToContextInstances.forEach((scopeClass, contextClass) -> {
                            Expr contextSupplier = bc.lambda(Supplier.class, lc -> lc.body(lbc -> lbc.return_(lbc.new_(ConstructorDesc.of((ClassDesc)ClassDesc.of(contextClass))))));
                            bc.withMap((Expr)contextInstancesFinal).put((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)scopeClass)), contextSupplier);
                        });
                        contextInstances = contextInstancesFinal;
                    }
                    bc.return_(bc.new_(ConstructorDesc.of(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Set.class, Map.class, Supplier.class, Map.class, Set.class, Map.class}), new Expr[]{beans, observers, localVar, interceptorBindings, localVar2, removedBeansSupplier, qualifiersNonbindingMembers, qualifiers, contextInstances}));
                });
            });
        });
    }

    private void generateAddBeans(String generatedName, Gizmo gizmo, CodeGenInfo info, Map<BeanInfo, String> beanToGeneratedName) {
        HashSet processed = new HashSet();
        for (Container<BeanGroup> container : info.beans()) {
            gizmo.class_(container.className(generatedName, ADD_BEANS), cc -> {
                cc.final_();
                for (BeanGroup group : container) {
                    cc.staticMethod(ADD_BEANS + group.id(), mc -> {
                        mc.packagePrivate();
                        mc.returning(Void.TYPE);
                        ParamVar beanIdToBean = mc.parameter("beanIdToBean", Map.class);
                        mc.body(bc -> {
                            for (BeanInfo bean : group.beans()) {
                                ClassDesc beanType;
                                ClassDesc classDesc = beanType = beanToGeneratedName.containsKey(bean) ? ClassDesc.of((String)beanToGeneratedName.get(bean)) : null;
                                if (beanType == null) {
                                    throw new IllegalStateException("No bean type found for: " + String.valueOf(bean));
                                }
                                List<InjectionPointInfo> injectionPoints = bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !ip.isDelegate() && !BuiltinBean.resolvesTo(ip)).toList();
                                ArrayList<ClassDesc> params = new ArrayList<ClassDesc>();
                                ArrayList<Expr> args = new ArrayList<Expr>();
                                if (bean.isProducer()) {
                                    params.add(ClassDesc.of(Supplier.class.getName()));
                                    if (processed.contains(bean.getDeclaringBean())) {
                                        args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)bean.getDeclaringBean().getIdentifier())));
                                    } else {
                                        args.add(bc.new_(MethodDescs.MAP_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)beanIdToBean, (Expr)Const.of((String)bean.getDeclaringBean().getIdentifier())));
                                    }
                                }
                                for (InjectionPointInfo injectionPoint : injectionPoints) {
                                    params.add(ClassDesc.of(Supplier.class.getName()));
                                    if (processed.contains(injectionPoint.getResolvedBean())) {
                                        args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)injectionPoint.getResolvedBean().getIdentifier())));
                                        continue;
                                    }
                                    args.add(bc.new_(MethodDescs.MAP_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)beanIdToBean, (Expr)Const.of((String)injectionPoint.getResolvedBean().getIdentifier())));
                                }
                                if (bean.getDisposer() != null) {
                                    for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                                        if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                                        params.add(ClassDesc.of(Supplier.class.getName()));
                                        args.add(bc.new_(MethodDescs.MAP_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)beanIdToBean, (Expr)Const.of((String)injectionPoint.getResolvedBean().getIdentifier())));
                                    }
                                }
                                for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                                    params.add(ClassDesc.of(Supplier.class.getName()));
                                    if (processed.contains(interceptor)) {
                                        args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)interceptor.getIdentifier())));
                                        continue;
                                    }
                                    args.add(bc.new_(MethodDescs.MAP_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)beanIdToBean, (Expr)Const.of((String)interceptor.getIdentifier())));
                                }
                                for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                                    params.add(ClassDesc.of(Supplier.class.getName()));
                                    if (processed.contains(decorator)) {
                                        args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)decorator.getIdentifier())));
                                        continue;
                                    }
                                    args.add(bc.new_(MethodDescs.MAP_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)beanIdToBean, (Expr)Const.of((String)decorator.getIdentifier())));
                                }
                                Expr beanInstance = bc.new_(ConstructorDesc.of((ClassDesc)beanType, params), args);
                                bc.withMap((Expr)beanIdToBean).put((Expr)Const.of((String)bean.getIdentifier()), beanInstance);
                                processed.add(bean);
                            }
                            bc.return_();
                        });
                    });
                }
            });
        }
    }

    private void generateAddObservers(String generatedName, Gizmo gizmo, CodeGenInfo info, Map<ObserverInfo, String> observerToGeneratedName) {
        for (Container<ObserverGroup> container : info.observers()) {
            gizmo.class_(container.className(generatedName, ADD_OBSERVERS), cc -> {
                cc.final_();
                for (ObserverGroup group : container) {
                    cc.staticMethod(ADD_OBSERVERS + group.id(), mc -> {
                        mc.packagePrivate();
                        mc.returning(Void.TYPE);
                        ParamVar beanIdToBean = mc.parameter("beanIdToBean", Map.class);
                        ParamVar observers = mc.parameter("observers", List.class);
                        mc.body(bc -> {
                            for (ObserverInfo observer : group.observers()) {
                                ClassDesc observerType;
                                ClassDesc classDesc = observerType = observerToGeneratedName.containsKey(observer) ? ClassDesc.of((String)observerToGeneratedName.get(observer)) : null;
                                if (observerType == null) {
                                    throw new IllegalStateException("No observer type found for: " + String.valueOf(observerType));
                                }
                                ArrayList<ClassDesc> params = new ArrayList<ClassDesc>();
                                ArrayList<Expr> args = new ArrayList<Expr>();
                                if (!observer.isSynthetic()) {
                                    List<InjectionPointInfo> injectionPoints = observer.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).toList();
                                    params.add(ClassDesc.of(Supplier.class.getName()));
                                    args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)observer.getDeclaringBean().getIdentifier())));
                                    for (InjectionPointInfo injectionPoint : injectionPoints) {
                                        params.add(ClassDesc.of(Supplier.class.getName()));
                                        args.add(bc.withMap((Expr)beanIdToBean).get((Expr)Const.of((String)injectionPoint.getResolvedBean().getIdentifier())));
                                    }
                                }
                                Expr observerInstance = bc.new_(ConstructorDesc.of((ClassDesc)observerType, params), args);
                                bc.withList((Expr)observers).add(observerInstance);
                            }
                            bc.return_();
                        });
                    });
                }
            });
        }
    }

    private void generateAddRemovedBeans(String generatedName, Gizmo gizmo, CodeGenInfo info) {
        for (Container<RemovedBeanGroup> container : info.removedBeans()) {
            gizmo.class_(container.className(generatedName, ADD_REMOVED_BEANS), cc -> {
                cc.final_();
                for (RemovedBeanGroup group : container) {
                    cc.staticMethod(ADD_REMOVED_BEANS + group.id(), mc -> {
                        mc.public_();
                        mc.returning(Void.TYPE);
                        ParamVar rtRemovedBeans = mc.parameter("removedBeans", List.class);
                        ParamVar typeCacheMap = mc.parameter("typeCache", Map.class);
                        mc.body(b0 -> {
                            LocalVar tccl = b0.localVar("tccl", b0.invokeVirtual(MethodDescs.THREAD_GET_TCCL, b0.currentThread()));
                            HashMap<AnnotationInstanceEquivalenceProxy, LocalVar> sharedQualifers = new HashMap<AnnotationInstanceEquivalenceProxy, LocalVar>();
                            for (BeanInfo btRemovedBean : group.removedBeans()) {
                                void var11_11;
                                LocalVar rtQualifiers;
                                LocalVar rtTypes = b0.localVar("types", b0.new_(HashSet.class));
                                for (Type type : btRemovedBean.getTypes()) {
                                    if (DotNames.OBJECT.equals((Object)type.name())) continue;
                                    b0.try_(tc -> {
                                        tc.body(b1 -> {
                                            try {
                                                LocalVar rtType = RuntimeTypeCreator.of(b1).withCache((Var)typeCacheMap).withTCCL((Var)tccl).create(type);
                                                b1.withSet((Expr)rtTypes).add((Expr)rtType);
                                            }
                                            catch (IllegalArgumentException e) {
                                                throw new IllegalStateException("Unable to construct type for " + String.valueOf(btRemovedBean) + ": " + e.getMessage());
                                            }
                                        });
                                        tc.catch_(Throwable.class, "e", (b1, e) -> b1.invokeStatic(MethodDescs.COMPONENTS_PROVIDER_UNABLE_TO_LOAD_REMOVED_BEAN_TYPE, (Expr)Const.of((String)type.toString()), (Expr)e));
                                    });
                                }
                                if (btRemovedBean.hasDefaultQualifiers() || btRemovedBean.getQualifiers().isEmpty()) {
                                    rtQualifiers = b0.localVar("qualifiers", (Expr)Const.ofNull(Set.class));
                                } else {
                                    rtQualifiers = b0.localVar("qualifiers", b0.new_(HashSet.class));
                                    for (AnnotationInstance btQualifier : btRemovedBean.getQualifiers()) {
                                        if (DotNames.ANY.equals((Object)btQualifier.name())) continue;
                                        BuiltinQualifier btBuiltinQualifier = BuiltinQualifier.of(btQualifier);
                                        if (btBuiltinQualifier != null) {
                                            b0.withSet((Expr)rtQualifiers).add((Expr)btBuiltinQualifier.getLiteralInstance());
                                            continue;
                                        }
                                        LocalVar rtSharedQualifier = (LocalVar)sharedQualifers.get(btQualifier.createEquivalenceProxy());
                                        if (rtSharedQualifier == null) {
                                            ClassInfo btQualifierClass = btRemovedBean.getDeployment().getQualifier(btQualifier.name());
                                            LocalVar rtQualifier = b0.localVar("qualifier", this.annotationLiterals.create((BlockCreator)b0, btQualifierClass, btQualifier));
                                            b0.withSet((Expr)rtQualifiers).add((Expr)rtQualifier);
                                            sharedQualifers.put(btQualifier.createEquivalenceProxy(), rtQualifier);
                                            continue;
                                        }
                                        b0.withSet((Expr)rtQualifiers).add((Expr)rtSharedQualifier);
                                    }
                                }
                                String description = null;
                                if (btRemovedBean.isClassBean()) {
                                    Object var11_16 = null;
                                } else if (btRemovedBean.isProducerField()) {
                                    InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_FIELD;
                                    description = String.valueOf(btRemovedBean.getTarget().get().asField().declaringClass().name()) + "#" + btRemovedBean.getTarget().get().asField().name();
                                } else if (btRemovedBean.isProducerMethod()) {
                                    InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_METHOD;
                                    description = String.valueOf(btRemovedBean.getTarget().get().asMethod().declaringClass().name()) + "#" + btRemovedBean.getTarget().get().asMethod().name() + "()";
                                } else {
                                    InjectableBean.Kind kind = InjectableBean.Kind.SYNTHETIC;
                                }
                                Const rtKind = var11_11 != null ? Expr.staticField((FieldDesc)FieldDesc.of(InjectableBean.Kind.class, (String)var11_11.name())) : Const.ofNull(InjectableBean.Kind.class);
                                Expr rtRemovedBean = b0.new_(MethodDescs.REMOVED_BEAN_IMPL, new Expr[]{rtKind, description != null ? Const.of((String)description) : Const.ofNull(String.class), rtTypes, rtQualifiers});
                                b0.withList((Expr)rtRemovedBeans).add(rtRemovedBean);
                            }
                            b0.return_();
                        });
                    });
                }
            });
        }
    }

    private CodeGenInfo preprocess(BeanDeployment deployment) {
        List<BeanInfo> beans = this.preprocessBeans(deployment);
        List<BeanGroup> beanGroups = Grouping.of(beans, 30, BeanGroup::new);
        List<Container<BeanGroup>> beanContainers = Grouping.of(beanGroups, 10, Container::new);
        List<ObserverInfo> observers = Reproducibility.orderedObservers(deployment.getObservers());
        List<ObserverGroup> observerGroups = Grouping.of(observers, 30, ObserverGroup::new);
        List<Container<ObserverGroup>> observerContainers = Grouping.of(observerGroups, 10, Container::new);
        List<BeanInfo> removedBeans = Reproducibility.orderedBeans(deployment.getRemovedBeans());
        List<RemovedBeanGroup> removedBeanGroups = Grouping.of(removedBeans, 5, RemovedBeanGroup::new);
        List<Container<RemovedBeanGroup>> removedBeanContainers = Grouping.of(removedBeanGroups, 10, Container::new);
        return new CodeGenInfo(beanContainers, observerContainers, removedBeanContainers);
    }

    private List<BeanInfo> preprocessBeans(BeanDeployment deployment) {
        final Map<BeanInfo, List<BeanInfo>> dependencyMap = this.initBeanDependencyMap(deployment);
        Predicate<BeanInfo> isNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                return !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        Predicate<BeanInfo> isNormalScopedOrNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                return b.getScope().isNormal() || !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        Predicate<BeanInfo> isNotProducerOrNormalScopedOrNotDependencyPredicate = new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo b) {
                if (b.isProducer()) {
                    return false;
                }
                return b.getScope().isNormal() || !ComponentsProviderGenerator.this.isDependency(b, dependencyMap);
            }
        };
        ArrayList<BeanInfo> result = new ArrayList<BeanInfo>();
        HashSet<BeanInfo> processed = new HashSet<BeanInfo>();
        boolean stuck = false;
        while (!dependencyMap.isEmpty()) {
            if (stuck) {
                throw this.circularDependenciesNotSupportedException(dependencyMap);
            }
            stuck = true;
            stuck = this.addBeans(result, dependencyMap, processed, isNotDependencyPredicate);
            if (!stuck || !(stuck = this.addBeans(result, dependencyMap, processed, isNotProducerOrNormalScopedOrNotDependencyPredicate))) continue;
            stuck = this.addBeans(result, dependencyMap, processed, isNormalScopedOrNotDependencyPredicate);
        }
        for (BeanInfo beanInfo : Reproducibility.orderedBeans(deployment.getBeans())) {
            if (processed.contains(beanInfo)) continue;
            result.add(beanInfo);
        }
        for (BeanInfo beanInfo : Reproducibility.orderedInterceptors(deployment.getInterceptors())) {
            if (processed.contains(beanInfo)) continue;
            result.add(beanInfo);
        }
        for (BeanInfo beanInfo : Reproducibility.orderedDecorators(deployment.getDecorators())) {
            if (processed.contains(beanInfo)) continue;
            result.add(beanInfo);
        }
        return result;
    }

    private Map<BeanInfo, List<BeanInfo>> initBeanDependencyMap(BeanDeployment beanDeployment) {
        Function<BeanInfo, List> newArrayList = ignored -> new ArrayList();
        TreeMap<BeanInfo, List<BeanInfo>> beanToInjections = new TreeMap<BeanInfo, List<BeanInfo>>(Reproducibility.BEAN_COMPARATOR);
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducer() && !bean.isStaticProducer()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), newArrayList).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(bean);
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptor, newArrayList).add(bean);
            }
            for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                beanToInjections.computeIfAbsent(decorator, newArrayList).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(interceptor);
                }
            }
        }
        for (DecoratorInfo decorator : beanDeployment.getDecorators()) {
            for (Injection injection : decorator.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (injectionPoint.isDelegate() || BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), newArrayList).add(decorator);
                }
            }
        }
        return beanToInjections;
    }

    private IllegalStateException circularDependenciesNotSupportedException(Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        StringBuilder msg = new StringBuilder("Circular dependencies not supported: \n");
        for (Map.Entry<BeanInfo, List<BeanInfo>> e : beanToInjections.entrySet()) {
            msg.append("\t ");
            msg.append(e.getKey());
            msg.append(" injected into: ");
            msg.append(e.getValue().stream().map(BeanInfo::getBeanClass).map(Object::toString).collect(Collectors.joining(", ")));
            msg.append("\n");
        }
        return new IllegalStateException(msg.toString());
    }

    private boolean addBeans(List<BeanInfo> list, Map<BeanInfo, List<BeanInfo>> dependencyMap, Set<BeanInfo> processed, Predicate<BeanInfo> filter) {
        boolean stuck = true;
        Iterator<BeanInfo> iterator = dependencyMap.keySet().iterator();
        while (iterator.hasNext()) {
            BeanInfo bean = iterator.next();
            if (!filter.test(bean)) continue;
            iterator.remove();
            list.add(bean);
            processed.add(bean);
            stuck = false;
        }
        return stuck;
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> dependencyMap) {
        for (List<BeanInfo> dependants : dependencyMap.values()) {
            if (!dependants.contains(bean)) continue;
            return true;
        }
        return false;
    }

    record CodeGenInfo(List<Container<BeanGroup>> beans, List<Container<ObserverGroup>> observers, List<Container<RemovedBeanGroup>> removedBeans) {
    }

    record Container<GROUP>(int id, List<GROUP> groups) implements Iterable<GROUP>
    {
        String className(String generatedName, String prefix) {
            return generatedName + "_" + prefix + this.id();
        }

        @Override
        public Iterator<GROUP> iterator() {
            return this.groups().iterator();
        }
    }

    record RemovedBeanGroup(int id, List<BeanInfo> removedBeans) {
    }

    record ObserverGroup(int id, List<ObserverInfo> observers) {
    }

    record BeanGroup(int id, List<BeanInfo> beans) {
    }
}

