/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.deployment;

import io.agroal.api.AgroalDataSource;
import io.quarkiverse.jooq.deployment.JooqInitializedBuildItem;
import io.quarkiverse.jooq.runtime.AbstractDslContextProducer;
import io.quarkiverse.jooq.runtime.JooqConfig;
import io.quarkiverse.jooq.runtime.JooqCustomContext;
import io.quarkiverse.jooq.runtime.JooqItemConfig;
import io.quarkiverse.jooq.runtime.JooqRecorder;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jooq.DSLContext;
import org.jooq.tools.LoggerListener;

public class JooqProcessor {
    private static final String FEATURE = "jooq";
    private static final Logger log = Logger.getLogger(JooqProcessor.class);
    private static final DotName DSL_CONTEXT_QUALIFIER = DotName.createSimple((String)AbstractDslContextProducer.DslContextQualifier.class.getName());
    private final String dslContextProducerClassName = AbstractDslContextProducer.class.getPackage().getName() + ".DslContextProducer";

    @Record(value=ExecutionTime.STATIC_INIT)
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeBuild.class, RegisterClassesForReflectionEnabled.class})
    public void registerReflections(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, JooqConfig jooqConfig) {
        Pattern jooqDBReflectClasses = Pattern.compile(jooqConfig.generatedClassesPattern());
        indexBuildItem.getIndex().getKnownClasses().stream().filter(o -> jooqDBReflectClasses.matcher(o.name().toString()).matches()).forEach(clazz -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{clazz.name().toString()})));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    protected void build(RecorderContext recorder, JooqRecorder template, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, JooqConfig jooqConfig, BuildProducer<GeneratedBeanBuildItem> generatedBean, DataSourcesBuildTimeConfig dataSourceConfig, List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem) {
        if (this.isUnconfigured(jooqConfig)) {
            return;
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{AbstractDslContextProducer.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new Class[]{LoggerListener.class}));
        if (!this.isPresentDialect(jooqConfig.defaultConfig())) {
            log.warn((Object)"No default sql-dialect been defined");
        }
        this.createDslContextProducerBean(generatedBean, unremovableBeans, jooqConfig, dataSourceConfig, jdbcDataSourcesBuildItem, AbstractDslContextProducer.class);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureDataSource(JooqRecorder template, BuildProducer<JooqInitializedBuildItem> jooqInitialized, JooqConfig jooqConfig) {
        if (this.isUnconfigured(jooqConfig)) {
            return;
        }
        jooqInitialized.produce((BuildItem)new JooqInitializedBuildItem());
    }

    protected boolean isUnconfigured(JooqConfig jooqConfig) {
        if (!this.isPresentDialect(jooqConfig.defaultConfig()) && jooqConfig.namedConfig().isEmpty()) {
            log.debug((Object)"No jOOQ has been configured");
            return true;
        }
        return false;
    }

    protected void createDslContextProducerBean(BuildProducer<GeneratedBeanBuildItem> generatedBean, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, JooqConfig jooqConfig, DataSourcesBuildTimeConfig dataSourceConfig, List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, Class<?> producerClass) {
        ClassOutput classOutput = (name, data) -> generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(this.dslContextProducerClassName)));
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(this.dslContextProducerClassName).superClass(producerClass).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        JooqItemConfig defaultConfig = jooqConfig.defaultConfig();
        if (this.isPresentDialect(defaultConfig)) {
            Optional<JdbcDataSourceBuildItem> defaultJdbcDataSourceBuildItem = jdbcDataSourcesBuildItem.stream().filter(JdbcDataSourceBuildItem::isDefault).findFirst();
            if (!defaultJdbcDataSourceBuildItem.isPresent()) {
                log.warn((Object)"Default dataSource not found");
                System.err.println(">>> Default dataSource not found");
            }
            if (defaultConfig.datasource().isPresent() && !"<default>".equals(defaultConfig.datasource().get())) {
                log.warn((Object)("Skip default dataSource name: " + (String)defaultConfig.datasource().get()));
            }
            String dsVarName = "defaultDataSource";
            FieldCreator defaultDataSourceCreator = (FieldCreator)classCreator.getFieldCreator(dsVarName, AgroalDataSource.class).setModifiers(32768);
            defaultDataSourceCreator.addAnnotation(Default.class);
            defaultDataSourceCreator.addAnnotation(Inject.class);
            String dialect = defaultConfig.dialect();
            MethodCreator defaultDslContextMethodCreator = classCreator.getMethodCreator("createDefaultDslContext", DSLContext.class, new Class[0]);
            defaultDslContextMethodCreator.addAnnotation(Singleton.class);
            defaultDslContextMethodCreator.addAnnotation(Produces.class);
            defaultDslContextMethodCreator.addAnnotation(Default.class);
            ResultHandle dialectRH = defaultDslContextMethodCreator.load(dialect);
            ResultHandle dataSourceRH = defaultDslContextMethodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)dsVarName, (String)AgroalDataSource.class.getName()), defaultDslContextMethodCreator.getThis());
            if (defaultConfig.configurationInject().isPresent()) {
                String configurationInjectName = (String)defaultConfig.configurationInject().get();
                String injectVarName = "configuration_" + HashUtil.sha1((String)configurationInjectName);
                FieldCreator configurationCreator = (FieldCreator)classCreator.getFieldCreator(injectVarName, JooqCustomContext.class).setModifiers(32768);
                configurationCreator.addAnnotation(Inject.class);
                configurationCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)configurationInjectName)}));
                ResultHandle configurationRH = defaultDslContextMethodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)injectVarName, (String)JooqCustomContext.class.getName()), defaultDslContextMethodCreator.getThis());
                defaultDslContextMethodCreator.returnValue(defaultDslContextMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(producerClass, (String)"createDslContext", DSLContext.class, (Class[])new Class[]{String.class, AgroalDataSource.class, JooqCustomContext.class}), defaultDslContextMethodCreator.getThis(), new ResultHandle[]{dialectRH, dataSourceRH, configurationRH}));
            } else {
                ResultHandle configurationRH = defaultConfig.configuration().isPresent() ? defaultDslContextMethodCreator.load((String)defaultConfig.configuration().get()) : defaultDslContextMethodCreator.loadNull();
                defaultConfig.configuration().ifPresent(s -> unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(s))));
                defaultDslContextMethodCreator.returnValue(defaultDslContextMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(producerClass, (String)"createDslContext", DSLContext.class, (Class[])new Class[]{String.class, AgroalDataSource.class, String.class}), defaultDslContextMethodCreator.getThis(), new ResultHandle[]{dialectRH, dataSourceRH, configurationRH}));
            }
        }
        for (Map.Entry configEntry : jooqConfig.namedConfig().entrySet()) {
            String named = (String)configEntry.getKey();
            JooqItemConfig namedConfig = (JooqItemConfig)configEntry.getValue();
            if (!this.isPresentDialect(namedConfig)) {
                log.warnv("!isPresentDialect(namedConfig), named: {0}, namedConfig: {1}", (Object)named, (Object)namedConfig);
                continue;
            }
            if (!namedConfig.datasource().isPresent()) {
                log.warnv("(!config.datasource.isPresent()), named: {0}, namedConfig: {1}", (Object)named, (Object)namedConfig);
                continue;
            }
            String dataSourceName = (String)namedConfig.datasource().get();
            Optional<JdbcDataSourceBuildItem> namedJdbcDataSourceBuildItem = jdbcDataSourcesBuildItem.stream().filter(j -> j.getName().equals(dataSourceName)).findFirst();
            if (!namedJdbcDataSourceBuildItem.isPresent()) {
                log.warnv("Named: '{0}' dataSource not found", (Object)dataSourceName);
                System.err.println(">>> Named: '" + dataSourceName + "' dataSource not found");
            }
            String suffix = HashUtil.sha1((String)named);
            String dsVarName = "dataSource_" + suffix;
            FieldCreator dataSourceCreator = (FieldCreator)classCreator.getFieldCreator(dsVarName, AgroalDataSource.class).setModifiers(32768);
            dataSourceCreator.addAnnotation(Inject.class);
            dataSourceCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)dataSourceName)}));
            MethodCreator namedDslContextMethodCreator = classCreator.getMethodCreator("createNamedDslContext_" + suffix, DSLContext.class.getName(), new String[0]);
            namedDslContextMethodCreator.addAnnotation(ApplicationScoped.class);
            namedDslContextMethodCreator.addAnnotation(Produces.class);
            namedDslContextMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)named)}));
            namedDslContextMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DSL_CONTEXT_QUALIFIER, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)named)}));
            ResultHandle dialectRH = namedDslContextMethodCreator.load(namedConfig.dialect());
            ResultHandle dataSourceRH = namedDslContextMethodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)dsVarName, (String)AgroalDataSource.class.getName()), namedDslContextMethodCreator.getThis());
            if (namedConfig.configurationInject().isPresent()) {
                String configurationInjectName = (String)namedConfig.configurationInject().get();
                String injectVarName = "configurationInjectName" + HashUtil.sha1((String)configurationInjectName);
                FieldCreator configurationCreator = (FieldCreator)classCreator.getFieldCreator(injectVarName, JooqCustomContext.class).setModifiers(32768);
                configurationCreator.addAnnotation(Inject.class);
                configurationCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)configurationInjectName)}));
                ResultHandle configurationRH = namedDslContextMethodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)injectVarName, (String)JooqCustomContext.class.getName()), namedDslContextMethodCreator.getThis());
                namedDslContextMethodCreator.returnValue(namedDslContextMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(producerClass, (String)"createDslContext", DSLContext.class, (Class[])new Class[]{String.class, AgroalDataSource.class, JooqCustomContext.class}), namedDslContextMethodCreator.getThis(), new ResultHandle[]{dialectRH, dataSourceRH, configurationRH}));
                continue;
            }
            ResultHandle configurationRH = namedConfig.configuration().isPresent() ? namedDslContextMethodCreator.load((String)namedConfig.configuration().get()) : namedDslContextMethodCreator.loadNull();
            namedConfig.configuration().ifPresent(s -> unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(s))));
            namedDslContextMethodCreator.returnValue(namedDslContextMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(producerClass, (String)"createDslContext", DSLContext.class, (Class[])new Class[]{String.class, AgroalDataSource.class, String.class}), namedDslContextMethodCreator.getThis(), new ResultHandle[]{dialectRH, dataSourceRH, configurationRH}));
        }
        classCreator.close();
    }

    protected boolean isPresentDialect(JooqItemConfig itemConfig) {
        return itemConfig.dialect() != null && !itemConfig.dialect().isEmpty();
    }

    static class RegisterClassesForReflectionEnabled
    implements BooleanSupplier {
        JooqConfig jooqConfig;

        RegisterClassesForReflectionEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.jooqConfig.registerGeneratedClassesForReflection();
        }
    }
}

