/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.hypersistence.utils.hibernate.type.util.JsonSerializer;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.SerializationException;

public class ObjectMapperJsonSerializer
implements JsonSerializer {
    private final ObjectMapperWrapper objectMapperWrapper;

    public ObjectMapperJsonSerializer(ObjectMapperWrapper objectMapperWrapper) {
        this.objectMapperWrapper = objectMapperWrapper;
    }

    @Override
    public <T> T clone(T object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Collection) {
            Class commonElementType = this.findCommonElementType((Collection)object);
            if (commonElementType != null && !Serializable.class.isAssignableFrom(commonElementType)) {
                JavaType type = TypeFactory.defaultInstance().constructParametricType(object.getClass(), new Class[]{commonElementType});
                return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), (Type)type);
            }
        } else if (object instanceof Map) {
            Map.Entry<Class, Class> commonElementType = this.findCommonElementType((Map)object);
            if (commonElementType != null) {
                Class commonKeyClass = commonElementType.getKey();
                Class commonValueClass = commonElementType.getValue();
                if (commonKeyClass.getPackage().getName().startsWith("java") || !Serializable.class.isAssignableFrom(commonKeyClass) || commonValueClass.getPackage().getName().startsWith("java") || !Serializable.class.isAssignableFrom(commonValueClass)) {
                    JavaType type = TypeFactory.defaultInstance().constructParametricType(object.getClass(), new Class[]{commonKeyClass, commonValueClass});
                    return this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), (Type)type);
                }
            }
        } else if (object instanceof JsonNode) {
            return (T)((JsonNode)object).deepCopy();
        }
        if (object instanceof Serializable) {
            try {
                return (T)SerializationHelper.clone((Serializable)((Serializable)object));
            }
            catch (SerializationException serializationException) {
                // empty catch block
            }
        }
        return this.jsonClone(object);
    }

    private Class findCommonElementType(Collection collection) {
        Class commonElementType = null;
        for (Object element : collection) {
            if (element == null) continue;
            if (commonElementType == null) {
                commonElementType = element.getClass();
                continue;
            }
            if ((commonElementType = this.resolveCommonElementType(commonElementType, element.getClass())) != null) continue;
            return null;
        }
        return commonElementType;
    }

    private Class resolveCommonElementType(Class commonElementType, Class elementClass) {
        if (commonElementType.isAssignableFrom(elementClass) && !Modifier.isAbstract(commonElementType.getModifiers())) {
            return commonElementType;
        }
        Class superclass = commonElementType.getSuperclass();
        if (!superclass.equals(Object.class)) {
            return this.resolveCommonElementType(superclass, elementClass);
        }
        return null;
    }

    private Map.Entry<Class, Class> findCommonElementType(Map<?, ?> map) {
        Map.Entry<Class, Class> commonElementType = null;
        for (Map.Entry<?, ?> elementEntry : map.entrySet()) {
            if (elementEntry.getKey() == null || elementEntry.getValue() == null) continue;
            AbstractMap.SimpleEntry<Class, Class> elementClass = new AbstractMap.SimpleEntry<Class, Class>(elementEntry.getKey().getClass(), elementEntry.getValue().getClass());
            if (commonElementType == null) {
                commonElementType = elementClass;
                continue;
            }
            if ((commonElementType = this.resolveCommonElementType(commonElementType, elementClass)) != null) continue;
            return null;
        }
        return commonElementType;
    }

    private Map.Entry<Class, Class> resolveCommonElementType(Map.Entry<Class, Class> commonElementType, Map.Entry<Class, Class> elementClass) {
        Class valueSuperclass;
        Class commonKeyClass = commonElementType.getKey();
        Class commonValueClass = commonElementType.getValue();
        if (commonKeyClass.isAssignableFrom(elementClass.getKey()) && !this.isAbstractType(commonKeyClass) && commonValueClass.isAssignableFrom(elementClass.getValue()) && !this.isAbstractType(commonValueClass)) {
            return commonElementType;
        }
        Class keySuperclass = commonKeyClass.equals(elementClass.getKey()) ? commonKeyClass : commonKeyClass.getSuperclass();
        Class clazz = valueSuperclass = commonValueClass.equals(elementClass.getValue()) ? commonValueClass : commonValueClass.getSuperclass();
        if (!(keySuperclass.equals(Object.class) || keySuperclass.equals(commonKeyClass) || valueSuperclass.equals(Object.class) || valueSuperclass.equals(commonValueClass))) {
            return this.resolveCommonElementType(new AbstractMap.SimpleEntry<Class, Class>(keySuperclass, valueSuperclass), elementClass);
        }
        return null;
    }

    private boolean isAbstractType(Class type) {
        return Modifier.isAbstract(type.getModifiers()) && !type.isArray();
    }

    private <T> T jsonClone(T object) {
        return (T)this.objectMapperWrapper.fromBytes(this.objectMapperWrapper.toBytes(object), object.getClass());
    }
}

