/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util.tolerances;

import com.google.common.collect.Range;
import io.github.msdk.util.tolerances.MzTolerance;
import javax.annotation.Nonnull;

public class ConstantPpmTolerance
implements MzTolerance {
    private static final Double MILLION = 1000000.0;
    @Nonnull
    private final Double ppmTolerance;

    public ConstantPpmTolerance(@Nonnull Double tolerancePPM) {
        this.ppmTolerance = tolerancePPM;
    }

    @Nonnull
    public Double getPpmTolerance() {
        return this.ppmTolerance;
    }

    @Override
    @Nonnull
    public Range<Double> getToleranceRange(@Nonnull Double mzValue) {
        Double absoluteTolerance = mzValue / MILLION * this.ppmTolerance;
        return Range.closed((Comparable)Double.valueOf(mzValue - absoluteTolerance), (Comparable)Double.valueOf(mzValue + absoluteTolerance));
    }

    public String toString() {
        return this.ppmTolerance + " ppm";
    }
}

