/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.util.MathUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChromatogramUtil {
    @Nullable
    public static Double getMedianMz(@Nonnull double[] mzValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        if (size == 0) {
            return null;
        }
        Double mz = MathUtils.calcQuantile(mzValues, size, 0.5);
        return mz;
    }

    @Nullable
    public static Range<Float> getRtRange(@Nonnull float[] rtValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        if (size == 0) {
            return null;
        }
        float min = rtValues[0];
        float max = rtValues[size - 1];
        return Range.closed((Comparable)Float.valueOf(min), (Comparable)Float.valueOf(max));
    }

    @Nonnull
    public static Range<Float> getDataPointsChromatographyRange(@Nonnull float[] rtValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Range chromatographyRange = Range.closed((Comparable)Float.valueOf(rtValues[0]), (Comparable)Float.valueOf(rtValues[size - 1]));
        return chromatographyRange;
    }

    @Nullable
    public static Range<Float> getDataPointsIntensityRange(@Nonnull Float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        float lower = intensityValues[0].floatValue();
        float upper = intensityValues[0].floatValue();
        for (int i = 0; i < size; ++i) {
            if (intensityValues[i].floatValue() < lower) {
                lower = intensityValues[i].floatValue();
            }
            if (!(intensityValues[i].floatValue() > upper)) continue;
            upper = intensityValues[i].floatValue();
        }
        Range intensityRange = Range.closed((Comparable)Float.valueOf(lower), (Comparable)Float.valueOf(upper));
        return intensityRange;
    }

    @Nullable
    public static Double calculateMz(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size, @Nonnull CalculationMethod method) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        double newMz = 0.0;
        double sum = 0.0;
        int values = 0;
        switch (method) {
            case allAverage: {
                for (int i = 0; i < size; ++i) {
                    if (!(mzValues[i] > 0.0)) continue;
                    ++values;
                    sum += mzValues[i];
                }
                newMz = sum / (double)values;
                break;
            }
            case allMedian: {
                double index = Math.floor(size / 2);
                if (mzValues.length % 2 == 0) {
                    sum = mzValues[(int)index] + mzValues[(int)index + 1];
                    newMz = sum / 2.0;
                    break;
                }
                newMz = mzValues[(int)index];
                break;
            }
            case fwhmAverage: {
                int i;
                float max = intensityValues[0];
                for (i = 1; i < size; ++i) {
                    if (!(intensityValues[i] > max)) continue;
                    max = intensityValues[i];
                }
                for (i = 0; i < intensityValues.length; ++i) {
                    if (!(intensityValues[i] > max / 2.0f)) continue;
                    ++values;
                    sum += mzValues[i];
                }
                newMz = sum / (double)values;
                break;
            }
        }
        return newMz;
    }

    @Nullable
    public static Float getRt(@Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        int max = 0;
        for (int i = 1; i < size; ++i) {
            if (!(intensityValues[i] > intensityValues[max])) continue;
            max = i;
        }
        return Float.valueOf(rtValues[max]);
    }

    @Nullable
    public static Float getRtStart(@Nonnull float[] rtValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        if (size == 0) {
            return null;
        }
        return Float.valueOf(rtValues[0]);
    }

    public static Float getRtEnd(@Nonnull float[] rtValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        if (size == 0) {
            return null;
        }
        return Float.valueOf(rtValues[size - 1]);
    }

    @Nullable
    public static Float getDuration(@Nonnull float[] rtValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        if (size == 0) {
            return null;
        }
        Float start = ChromatogramUtil.getRtStart(rtValues, size);
        Float end = ChromatogramUtil.getRtEnd(rtValues, size);
        if (start == null || end == null) {
            return null;
        }
        return Float.valueOf(end.floatValue() - start.floatValue());
    }

    @Nullable
    public static Float getMaxHeight(@Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        int max = 0;
        for (int i = 1; i < size; ++i) {
            if (!(intensityValues[i] > intensityValues[max])) continue;
            max = i;
        }
        return Float.valueOf(intensityValues[max]);
    }

    @Nullable
    public static Float getArea(@Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        float area = 0.0f;
        float rtDifference = 0.0f;
        float intensityStart = 0.0f;
        float intensityEnd = 0.0f;
        for (int i = 0; i < size - 1; ++i) {
            rtDifference = rtValues[i + 1] - rtValues[i];
            intensityStart = intensityValues[i];
            intensityEnd = intensityValues[i + 1];
            area += rtDifference * (intensityStart + intensityEnd) / 2.0f;
        }
        return Float.valueOf(area);
    }

    @Nullable
    public static Double getFwhm(@Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        Float height = ChromatogramUtil.getMaxHeight(intensityValues, size);
        Float rt = ChromatogramUtil.getRt(rtValues, intensityValues, size);
        if (height == null || rt == null) {
            return null;
        }
        double[] rtVals = ChromatogramUtil.findRTs(height.floatValue() / 2.0f, rt.floatValue(), rtValues, intensityValues, size);
        Double fwhm = rtVals[1] - rtVals[0];
        if (fwhm < 0.0) {
            fwhm = null;
        }
        return fwhm;
    }

    @Nullable
    public static Double getTailingFactor(@Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Double tf;
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        Float height = ChromatogramUtil.getMaxHeight(intensityValues, size);
        Float rt = ChromatogramUtil.getRt(rtValues, intensityValues, size);
        if (height == null || rt == null) {
            return null;
        }
        double[] rtVals = ChromatogramUtil.findRTs((double)height.floatValue() * 0.05, rt.floatValue(), rtValues, intensityValues, size);
        if (rtVals[1] == 0.0) {
            rtVals[1] = ChromatogramUtil.getRtEnd(rtValues, size).floatValue();
        }
        if ((tf = Double.valueOf((rtVals[1] - rtVals[0]) / (2.0 * ((double)rt.floatValue() - rtVals[0])))) < 0.0) {
            tf = null;
        }
        return tf;
    }

    @Nullable
    public static Double getAsymmetryFactor(@Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        if (size == 0) {
            return null;
        }
        Float height = ChromatogramUtil.getMaxHeight(intensityValues, size);
        Float rt = ChromatogramUtil.getRt(rtValues, intensityValues, size);
        if (height == null || rt == null) {
            return null;
        }
        double[] rtValues3 = ChromatogramUtil.findRTs((double)height.floatValue() * 0.1, rt.floatValue(), rtValues, intensityValues, size);
        Double af = (rtValues3[1] - (double)rt.floatValue()) / ((double)rt.floatValue() - rtValues3[0]);
        if (af < 0.0) {
            af = null;
        }
        return af;
    }

    private static double[] findRTs(double intensity, float rt, @Nonnull float[] rtValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        double rt2;
        double rt1;
        double intercept;
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)rtValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        double lastDiff1 = intensity;
        double lastDiff2 = intensity;
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double y3 = 0.0;
        double y4 = 0.0;
        for (int i = 1; i < size - 1; ++i) {
            double currentRT;
            double currentDiff = Math.abs(intensity - (double)intensityValues[i]);
            if (currentDiff < lastDiff1 & currentDiff > 0.0 & (currentRT = (double)rtValues[i]) <= (double)rt) {
                x1 = rtValues[i];
                y1 = intensityValues[i];
                x2 = rtValues[i + 1];
                y2 = intensityValues[i + 1];
                lastDiff1 = currentDiff;
                continue;
            }
            if (!(currentDiff < lastDiff2 & currentDiff > 0.0 & currentRT >= (double)rt)) continue;
            x3 = rtValues[i - 1];
            y3 = intensityValues[i - 1];
            x4 = rtValues[i];
            y4 = intensityValues[i];
            lastDiff2 = currentDiff;
        }
        if (y1 > 0.0) {
            double slope = (y2 - y1) / (x2 - x1);
            intercept = y1 - slope * x1;
            rt1 = (intensity - intercept) / slope;
        } else {
            rt1 = x2 > 0.0 ? x2 : (double)rtValues[0];
        }
        if (y4 > 0.0) {
            double slope = (y4 - y3) / (x4 - x3);
            intercept = y3 - slope * x3;
            rt2 = (intensity - intercept) / slope;
        } else {
            rt2 = x3 > 0.0 ? x3 : (double)rtValues[size - 1];
        }
        return new double[]{rt1, rt2};
    }

    public static enum CalculationMethod {
        allAverage,
        allMedian,
        fwhmAverage,
        fwhmMedian;

    }
}

