/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.datamodel.ActivationInfo;
import io.github.msdk.datamodel.IsolationInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleIsolationInfo
implements IsolationInfo {
    @Nonnull
    private Range<Double> isolationMzRange;
    @Nullable
    private Float ionInjectTime;
    @Nullable
    private Double precursorMz;
    @Nullable
    private Integer precursorCharge;
    @Nullable
    private ActivationInfo activationInfo;

    public SimpleIsolationInfo(@Nonnull Range<Double> isolationMzRange) {
        Preconditions.checkNotNull(isolationMzRange);
        this.isolationMzRange = isolationMzRange;
        this.ionInjectTime = null;
        this.precursorMz = null;
        this.precursorCharge = null;
        this.activationInfo = null;
    }

    public SimpleIsolationInfo(@Nonnull Range<Double> isolationMzRange, @Nullable Float ionInjectTime, @Nullable Double precursorMz, @Nullable Integer precursorCharge, @Nullable ActivationInfo activationInfo) {
        Preconditions.checkNotNull(isolationMzRange);
        this.isolationMzRange = isolationMzRange;
        this.ionInjectTime = ionInjectTime;
        this.precursorMz = precursorMz;
        this.precursorCharge = precursorCharge;
        this.activationInfo = activationInfo;
    }

    @Override
    @Nonnull
    public Range<Double> getIsolationMzRange() {
        return this.isolationMzRange;
    }

    @Override
    @Nullable
    public Float getIonInjectTime() {
        return this.ionInjectTime;
    }

    @Override
    @Nullable
    public Double getPrecursorMz() {
        return this.precursorMz;
    }

    @Override
    @Nullable
    public Integer getPrecursorCharge() {
        return this.precursorCharge;
    }

    @Override
    @Nullable
    public ActivationInfo getActivationInfo() {
        return this.activationInfo;
    }
}

