/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.crypto.generators;

import io.gatling.recorder.internal.bouncycastle.crypto.CipherParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.Digest;
import io.gatling.recorder.internal.bouncycastle.crypto.PBEParametersGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.params.KeyParameter;
import io.gatling.recorder.internal.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS5S1ParametersGenerator
extends PBEParametersGenerator {
    private Digest digest;

    public PKCS5S1ParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    private byte[] generateDerivedKey() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.update(this.password, 0, this.password.length);
        this.digest.update(this.salt, 0, this.salt.length);
        this.digest.doFinal(byArray, 0);
        for (int i = 1; i < this.iterationCount; ++i) {
            this.digest.update(byArray, 0, byArray.length);
            this.digest.doFinal(byArray, 0);
        }
        return byArray;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n) {
        if ((n /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + n + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new KeyParameter(byArray, 0, n);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n, int n2) {
        if ((n /= 8) + (n2 /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + (n + n2) + " bytes long.");
        }
        byte[] byArray = this.generateDerivedKey();
        return new ParametersWithIV(new KeyParameter(byArray, 0, n), byArray, n, n2);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }
}

