/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.asn1.cms;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Choice;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Encodable;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Integer;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Object;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Primitive;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Sequence;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1TaggedObject;
import io.gatling.recorder.internal.bouncycastle.asn1.DERTaggedObject;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.KEKRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.OtherRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Object
implements ASN1Choice {
    ASN1Encodable info;

    public RecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.info = keyTransRecipientInfo;
    }

    public RecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.info = new DERTaggedObject(false, 1, (ASN1Encodable)keyAgreeRecipientInfo);
    }

    public RecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.info = new DERTaggedObject(false, 2, (ASN1Encodable)kEKRecipientInfo);
    }

    public RecipientInfo(PasswordRecipientInfo passwordRecipientInfo) {
        this.info = new DERTaggedObject(false, 3, (ASN1Encodable)passwordRecipientInfo);
    }

    public RecipientInfo(OtherRecipientInfo otherRecipientInfo) {
        this.info = new DERTaggedObject(false, 4, (ASN1Encodable)otherRecipientInfo);
    }

    public RecipientInfo(ASN1Primitive aSN1Primitive) {
        this.info = aSN1Primitive;
    }

    public static RecipientInfo getInstance(Object object) {
        if (object == null || object instanceof RecipientInfo) {
            return (RecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public ASN1Integer getVersion() {
        if (!(this.info instanceof ASN1TaggedObject)) {
            return KeyTransRecipientInfo.getInstance(this.info).getVersion();
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
        if (aSN1TaggedObject.hasContextTag()) {
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 2: {
                    return this.getKEKInfo(aSN1TaggedObject).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 4: {
                    return new ASN1Integer(0L);
                }
            }
        }
        throw new IllegalStateException("unknown tag");
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getInfo() {
        if (!(this.info instanceof ASN1TaggedObject)) {
            return KeyTransRecipientInfo.getInstance(this.info);
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
        if (aSN1TaggedObject.hasContextTag()) {
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 2: {
                    return this.getKEKInfo(aSN1TaggedObject);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
            }
        }
        throw new IllegalStateException("unknown tag");
    }

    private KEKRecipientInfo getKEKInfo(ASN1TaggedObject aSN1TaggedObject) {
        boolean bl = aSN1TaggedObject.isExplicit();
        return KEKRecipientInfo.getInstance(aSN1TaggedObject, bl);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.info.toASN1Primitive();
    }

    boolean isKeyTransV0() {
        if (this.info instanceof ASN1TaggedObject) {
            return false;
        }
        KeyTransRecipientInfo keyTransRecipientInfo = KeyTransRecipientInfo.getInstance(this.info);
        return keyTransRecipientInfo.getVersion().hasValue(0);
    }

    boolean isPasswordOrOther() {
        ASN1TaggedObject aSN1TaggedObject;
        if (this.info instanceof ASN1TaggedObject && (aSN1TaggedObject = (ASN1TaggedObject)this.info).hasContextTag()) {
            switch (aSN1TaggedObject.getTagNo()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }
}

