/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectInventory;
import io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnet;
import io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnetBuilder;
import io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GCPPrivateServiceConnectInventoryFluent<A extends GCPPrivateServiceConnectInventoryFluent<A>>
extends BaseFluent<A> {
    private String network;
    private ArrayList<GCPPrivateServiceConnectSubnetBuilder> subnets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GCPPrivateServiceConnectInventoryFluent() {
    }

    public GCPPrivateServiceConnectInventoryFluent(GCPPrivateServiceConnectInventory instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPPrivateServiceConnectInventory instance) {
        GCPPrivateServiceConnectInventory gCPPrivateServiceConnectInventory = instance = instance != null ? instance : new GCPPrivateServiceConnectInventory();
        if (instance != null) {
            this.withNetwork(instance.getNetwork());
            this.withSubnets(instance.getSubnets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public A addToSubnets(int index, GCPPrivateServiceConnectSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubnets(int index, GCPPrivateServiceConnectSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubnets(GCPPrivateServiceConnectSubnet ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (GCPPrivateServiceConnectSubnet item : items) {
            GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubnets(Collection<GCPPrivateServiceConnectSubnet> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (GCPPrivateServiceConnectSubnet item : items) {
            GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
            this._visitables.get((Object)"subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubnets(GCPPrivateServiceConnectSubnet ... items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (GCPPrivateServiceConnectSubnet item : items) {
            GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
            this._visitables.get((Object)"subnets").remove((Object)builder);
            this.subnets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubnets(Collection<GCPPrivateServiceConnectSubnet> items) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        for (GCPPrivateServiceConnectSubnet item : items) {
            GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
            this._visitables.get((Object)"subnets").remove((Object)builder);
            this.subnets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubnets(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
        if (this.subnets == null) {
            return (A)((Object)this);
        }
        Iterator<GCPPrivateServiceConnectSubnetBuilder> each = this.subnets.iterator();
        List visitables = this._visitables.get((Object)"subnets");
        while (each.hasNext()) {
            GCPPrivateServiceConnectSubnetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GCPPrivateServiceConnectSubnet> buildSubnets() {
        return this.subnets != null ? GCPPrivateServiceConnectInventoryFluent.build(this.subnets) : null;
    }

    public GCPPrivateServiceConnectSubnet buildSubnet(int index) {
        return this.subnets.get(index).build();
    }

    public GCPPrivateServiceConnectSubnet buildFirstSubnet() {
        return this.subnets.get(0).build();
    }

    public GCPPrivateServiceConnectSubnet buildLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1).build();
    }

    public GCPPrivateServiceConnectSubnet buildMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
        for (GCPPrivateServiceConnectSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
        for (GCPPrivateServiceConnectSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<GCPPrivateServiceConnectSubnet> subnets) {
        if (this.subnets != null) {
            this._visitables.get((Object)"subnets").clear();
        }
        if (subnets != null) {
            this.subnets = new ArrayList();
            for (GCPPrivateServiceConnectSubnet item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)((Object)this);
    }

    public A withSubnets(GCPPrivateServiceConnectSubnet ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove((Object)"subnets");
        }
        if (subnets != null) {
            for (GCPPrivateServiceConnectSubnet item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public A addNewSubnet(String region, String subnet) {
        return this.addToSubnets(new GCPPrivateServiceConnectSubnet(region, subnet));
    }

    public SubnetsNested<A> addNewSubnet() {
        return new SubnetsNested(-1, null);
    }

    public SubnetsNested<A> addNewSubnetLike(GCPPrivateServiceConnectSubnet item) {
        return new SubnetsNested(-1, item);
    }

    public SubnetsNested<A> setNewSubnetLike(int index, GCPPrivateServiceConnectSubnet item) {
        return new SubnetsNested(index, item);
    }

    public SubnetsNested<A> editSubnet(int index) {
        if (this.subnets.size() <= index) {
            throw new RuntimeException("Can't edit subnets. Index exceeds size.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editFirstSubnet() {
        if (this.subnets.size() == 0) {
            throw new RuntimeException("Can't edit first subnets. The list is empty.");
        }
        return this.setNewSubnetLike(0, this.buildSubnet(0));
    }

    public SubnetsNested<A> editLastSubnet() {
        int index = this.subnets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subnets. The list is empty.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subnets.size(); ++i) {
            if (!predicate.test(this.subnets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subnets. No match found.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPPrivateServiceConnectInventoryFluent that = (GCPPrivateServiceConnectInventoryFluent)((Object)o);
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.network, this.subnets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(String.valueOf(this.subnets) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubnetsNested<N>
    extends GCPPrivateServiceConnectSubnetFluent<SubnetsNested<N>>
    implements Nested<N> {
        GCPPrivateServiceConnectSubnetBuilder builder;
        int index;

        SubnetsNested(int index, GCPPrivateServiceConnectSubnet item) {
            this.index = index;
            this.builder = new GCPPrivateServiceConnectSubnetBuilder(this, item);
        }

        public N and() {
            return (N)GCPPrivateServiceConnectInventoryFluent.this.setToSubnets(this.index, this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }
}

