/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields.internalhtmltable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.vaadin.firitin.fields.internalhtmltable.ElementHelper;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;

public interface TableRowContainer
extends HasElement {
    default public TableRow addRow() {
        TableRow row = new TableRow();
        this.addRows(row);
        return row;
    }

    default public void addRows(TableRow ... rows) {
        this.getElement().appendChild(ElementHelper.asElements((Component[])rows));
    }

    default public TableRow[] addRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException("Rows must be greater than 0");
        }
        TableRow[] rowObjects = (TableRow[])IntStream.range(0, rows).mapToObj(i -> new TableRow()).toArray(TableRow[]::new);
        this.addRows(rowObjects);
        return rowObjects;
    }

    default public TableRow insertRow(int index) {
        TableRow tableRow = new TableRow();
        this.insertRows(index, tableRow);
        return tableRow;
    }

    default public void insertRows(int index, TableRow ... rows) {
        this.getElement().insertChild(index, ElementHelper.asElements((Component[])rows));
    }

    default public void setRow(int index, TableRow row) {
        this.replaceRow(index, row);
    }

    default public void replaceRow(int index, TableRow row) {
        this.getElement().setChild(index, row.getElement());
    }

    default public void removeRow(int index) {
        TableRowContainer tableRowContainer = this;
        this.getRow(index).ifPresent(xva$0 -> tableRowContainer.removeRows((TableRow)((Object)xva$0)));
    }

    default public void removeRows(TableRow ... rows) {
        this.getElement().removeChild(ElementHelper.asElements((Component[])rows));
    }

    default public void removeAllRows() {
        this.removeRows((TableRow[])this.streamRows().toArray(TableRow[]::new));
    }

    default public List<TableRow> getRows() {
        return this.streamRows().collect(Collectors.toList());
    }

    default public Optional<TableRow> getRow(int index) {
        return this.streamRows().skip(index).findFirst();
    }

    default public Stream<TableRow> streamRows() {
        return this.getChildren().filter(c -> c instanceof TableRow).map(c -> (TableRow)((Object)c));
    }

    public Stream<Component> getChildren();
}

