/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.devicemotion;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.vaadin.firitin.devicemotion.ScreenOrientationInfo;

public class ScreenOrientation {
    private DomListenerRegistration orientationListener;
    private UI ui;

    public static CompletableFuture<ScreenOrientationInfo> getCurrentOrientation() {
        return ScreenOrientation.getCurrentOrientation(UI.getCurrent());
    }

    public static CompletableFuture<ScreenOrientationInfo> getCurrentOrientation(UI ui) {
        return ui.getPage().executeJs("if (screen.orientation) {\n    return {\n        type: screen.orientation.type,\n        angle: screen.orientation.angle\n    };\n} else {\n    // Fallback for browsers without screen.orientation\n    const angle = window.orientation || 0;\n    let type = 'portrait-primary';\n    if (angle === 90 || angle === -90) {\n        type = angle === 90 ? 'landscape-primary' : 'landscape-secondary';\n    }\n    return { type: type, angle: Math.abs(angle) };\n}\n", new Object[0]).toCompletableFuture(ScreenOrientationInfo.class);
    }

    public static ScreenOrientation listen(OrientationChangeListener listener) {
        return ScreenOrientation.listen(UI.getCurrent(), listener);
    }

    public static ScreenOrientation listen(UI ui, OrientationChangeListener listener) {
        ScreenOrientation screenOrientation = new ScreenOrientation();
        screenOrientation.ui = ui;
        screenOrientation.orientationListener = ui.getElement().addEventListener("screen-orientation-change", (DomEventListener & Serializable)e -> {
            try {
                ScreenOrientationInfo info = (ScreenOrientationInfo)e.getEventDetail(ScreenOrientationInfo.class);
                listener.onOrientationChanged(info);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to parse orientation event", ex);
            }
        }).addEventDetail().debounce(100);
        screenOrientation.orientationListener.addEventData("event.detail");
        ui.getElement().executeJs("const element = this;\n\nfunction notifyOrientationChange() {\n    let type, angle;\n    if (screen.orientation) {\n        type = screen.orientation.type;\n        angle = screen.orientation.angle;\n    } else {\n        window.alert(\"No screen.orientation support\");\n        // Fallback\n        angle = Math.abs(window.orientation || 0);\n        type = (angle === 90 || angle === 270) ? 'landscape-primary' : 'portrait-primary';\n    }\n\n    const event = new CustomEvent('screen-orientation-change', {\n        detail: JSON.stringify({ type: type, angle: angle })\n    });\n    element.dispatchEvent(event);\n}\n\n// Listen to orientation changes\nif (screen.orientation) {\n    screen.orientation.addEventListener('change', notifyOrientationChange);\n} else if (window.orientation !== undefined) {\n    window.addEventListener('orientationchange', notifyOrientationChange);\n}\n\n// Notify current orientation immediately\nnotifyOrientationChange();\n", new Object[0]);
        return screenOrientation;
    }

    public void cancel() {
        if (this.orientationListener != null) {
            this.orientationListener.remove();
            this.orientationListener = null;
        }
    }

    public static interface OrientationChangeListener {
        public void onOrientationChanged(ScreenOrientationInfo var1);
    }
}

