/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.shared.util.SharedUtil;
import java.lang.annotation.Annotation;
import org.vaadin.firitin.appframework.MenuItem;

public interface NavigationItem
extends HasStyle {
    public static String getMenuTextFromClass(Class<?> navigationTarget) {
        String text;
        MenuItem me = NavigationItem.getAnnotationFromType(navigationTarget, MenuItem.class);
        if (me != null && !me.title().isEmpty()) {
            text = me.title();
        } else {
            Menu menu = NavigationItem.getAnnotationFromType(navigationTarget, Menu.class);
            if (menu != null && !menu.title().isEmpty()) {
                text = menu.title();
            } else {
                PageTitle title = NavigationItem.getAnnotationFromType(navigationTarget, PageTitle.class);
                if (title == null) {
                    String simpleName = navigationTarget.getSimpleName();
                    if (simpleName.endsWith("_Subclass")) {
                        simpleName = simpleName.substring(0, simpleName.length() - "_Subclass".length());
                    }
                    if (simpleName.endsWith("View")) {
                        simpleName = simpleName.substring(0, simpleName.length() - 4);
                    }
                    text = SharedUtil.camelCaseToHumanFriendly((String)simpleName);
                } else {
                    text = title.value();
                }
            }
        }
        return text;
    }

    public static <A extends Annotation> A getAnnotationFromType(Class<?> classType, Class<A> annotationClass) {
        while (!classType.getName().equals(Object.class.getName())) {
            if (classType.isAnnotationPresent(annotationClass)) {
                return classType.getAnnotation(annotationClass);
            }
            classType = classType.getSuperclass();
        }
        return null;
    }

    public String getText();

    public Class<?> getNavigationTarget();

    public boolean isEnabled();

    public void setActive(boolean var1);

    public void addSubItem(NavigationItem var1);

    public void setParentItem(NavigationItem var1);

    public NavigationItem getParentItem();
}

