/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.xhtml.extension;

import fr.opensagres.xdocreport.xhtml.extension.AbstractContentBuffer;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public abstract class XHTMLPageContentBuffer
extends AbstractContentBuffer
implements XHTMLConstants {
    protected StringBuilder currentBuffer = new StringBuilder();
    protected int currentElementIndex;

    public XHTMLPageContentBuffer(int indent) {
        super(indent);
    }

    public void startEndElement(String elementName) {
        this.startElementNotEnclosed(elementName);
        this.currentBuffer.append('/');
        this.currentBuffer.append('>');
    }

    public void startElement(String elementName) {
        this.startElement(elementName, true, this.getCurrentBuffer(), this.currentElementIndex);
        ++this.currentElementIndex;
    }

    public void startElementNotEnclosed(String elementName) {
        this.startElement(elementName, false, this.getCurrentBuffer(), this.currentElementIndex);
        ++this.currentElementIndex;
    }

    public void endElementNotEnclosed() {
        this.getCurrentBuffer().append('>');
    }

    public XHTMLPageContentBuffer setAttribute(String name, String value) {
        this.startAttribute(name).addAttributeValue(value, true).endAttribute();
        return this;
    }

    public XHTMLPageContentBuffer setAttribute(String name, Integer value) {
        this.setAttribute(name, String.valueOf(value));
        return this;
    }

    public XHTMLPageContentBuffer addAttributeValue(String value, boolean firstValue) {
        if (!firstValue) {
            this.getCurrentBuffer().append(' ');
        }
        this.getCurrentBuffer().append(value);
        return this;
    }

    public XHTMLPageContentBuffer startAttribute(String name) {
        this.getCurrentBuffer().append(' ').append(name).append("=\"");
        return this;
    }

    public XHTMLPageContentBuffer endAttribute() {
        this.getCurrentBuffer().append("\"");
        return this;
    }

    protected StringBuilder startElement(String elementName, boolean endsElement, StringBuilder buffer, int index) {
        this.doIndentIfNeeded(buffer, index);
        buffer.append('<');
        buffer.append(elementName);
        if (endsElement) {
            buffer.append('>');
        }
        return buffer;
    }

    protected void startElement(String elementName, boolean endsElement, Writer writer, int index) throws IOException {
        this.doIndentIfNeeded(writer, index);
        writer.write(60);
        writer.write(elementName);
        if (endsElement) {
            writer.write(62);
        }
    }

    protected void startElement(String elementName, boolean endsElement, OutputStream out, int index) throws IOException {
        this.doIndentIfNeeded(out, index);
        out.write(60);
        out.write(elementName.getBytes());
        if (endsElement) {
            out.write(62);
        }
    }

    public void endElement(String elementName) {
        --this.currentElementIndex;
        this.endElement(elementName, this.getCurrentBuffer(), this.currentElementIndex);
    }

    protected StringBuilder endElement(String elementName, StringBuilder buffer, int index) {
        this.doIndentIfNeeded(buffer, index);
        buffer.append('<');
        buffer.append('/');
        buffer.append(elementName);
        buffer.append('>');
        return buffer;
    }

    protected void endElement(String elementName, Writer writer, int index) throws IOException {
        this.doIndentIfNeeded(writer, index);
        writer.write(60);
        writer.write(47);
        writer.write(elementName);
        writer.write(62);
    }

    protected void endElement(String elementName, OutputStream out, int index) throws IOException {
        this.doIndentIfNeeded(out, index);
        out.write(60);
        out.write(47);
        out.write(elementName.getBytes());
        out.write(62);
    }

    protected StringBuilder getCurrentBuffer() {
        return this.currentBuffer;
    }

    public void save(Writer writer) throws IOException {
        writer.write(this.getCurrentBuffer().toString());
    }

    public void save(OutputStream out) throws IOException {
        out.write(this.getCurrentBuffer().toString().getBytes());
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }
}

