/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import fr.ird.observe.maven.plugins.toolbox.MismatchMethodParameterNameException;
import fr.ird.observe.maven.plugins.toolbox.MissingClassException;
import fr.ird.observe.maven.plugins.toolbox.MissingMethodException;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="merge-i18n-bundle", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class MergeI18nBundleMojo
extends AbstractPlugin {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="merge.bundle", required=true)
    protected File bundle;
    @Parameter(property="merge.locale", required=true)
    protected String locale;
    @Parameter(property="merge.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="merge.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="merge.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    private Path i18nFile;
    private int methodCount;

    protected void init() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        if (!this.bundle.exists()) {
            throw new MojoExecutionException("Can't find bundle at " + this.bundle);
        }
        this.i18nFile = this.project.getBasedir().toPath().resolve("src").resolve("main").resolve("resources").resolve("i18n").resolve(String.format("%s_%s.properties", this.project.getArtifactId(), this.locale));
        if (!Files.exists(this.i18nFile, new LinkOption[0])) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("No i18n file found at " + this.i18nFile));
            }
            this.i18nFile = null;
        }
    }

    protected boolean checkSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping goal (skip flag is on).");
            return false;
        }
        if (this.i18nFile == null) {
            this.getLog().warn((CharSequence)"Skipping goal (No matching i18n file found).");
            return false;
        }
        return super.checkSkip();
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.project));
        }
        Charset charset = Charset.forName(this.encoding);
        Properties source = new Properties();
        source.load(Files.newBufferedReader(this.bundle.toPath(), charset));
        Properties target = new Properties();
        target.load(Files.newBufferedReader(this.i18nFile, charset));
        int modified = 0;
        for (Object sourceKey : source.keySet()) {
            if (!target.containsKey(sourceKey)) continue;
            target.put(sourceKey, source.get(sourceKey));
            ++modified;
        }
        if (modified > 0) {
            this.getLog().info((CharSequence)(modified + "key(s) modified, save the file."));
            target.store(Files.newBufferedWriter(this.i18nFile, charset, new OpenOption[0]), "Modified by " + ((Object)((Object)this)).getClass().getName());
        } else {
            this.getLog().info((CharSequence)"File is up-to-date.");
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void checkClass(Class<?> sourceClass, Class<?> targetClass) throws MissingMethodException, MismatchMethodParameterNameException, MissingClassException {
        Method[] sourceDeclaredMethods = sourceClass.getDeclaredMethods();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Check " + sourceClass.getName()));
        }
        if (targetClass == null) {
            throw new MissingClassException(sourceClass.getName());
        }
        for (Method sourceMethod : sourceDeclaredMethods) {
            Method targetMethod;
            ++this.methodCount;
            try {
                targetMethod = targetClass.getDeclaredMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new MissingMethodException("Could not find method " + sourceMethod.getName() + " on target class: " + targetClass);
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Check " + sourceClass.getName() + "#" + sourceMethod.getName()));
            }
            java.lang.reflect.Parameter[] sourceParameters = sourceMethod.getParameters();
            java.lang.reflect.Parameter[] targetParameters = targetMethod.getParameters();
            int max = sourceParameters.length;
            for (int i = 0; i < max; ++i) {
                java.lang.reflect.Parameter sourceParameter = sourceParameters[i];
                java.lang.reflect.Parameter targetParameter = targetParameters[i];
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Check " + sourceClass.getName() + "#" + sourceMethod.getName() + "\u2192" + sourceParameter.getName() + " vs " + targetParameter.getName()));
                }
                if (sourceParameter.getName().equals(targetParameter.getName())) continue;
                throw new MismatchMethodParameterNameException(sourceClass.getName(), sourceMethod.getName(), sourceParameter.getName(), i, targetClass.getName(), targetMethod.getName(), targetParameter.getName());
            }
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)(targetClass.getName() + " is conform to #" + sourceClass.getName()));
        }
    }
}

