/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.AbstractObserveAction;
import fr.ird.observe.ui.storage.StorageBackupUILauncher;
import java.awt.event.ActionEvent;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class SaveStorageToFileAction
extends AbstractObserveAction {
    private static final long serialVersionUID = 1L;
    private final ObserveMainUI ui;

    public SaveStorageToFileAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.save.to.file", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"local-export"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.save.to.file.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 76);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        if (canContinue) {
            DataSource service = ObserveMainUIHandler.getStorage();
            boolean local = service.getConfig() instanceof H2DataSourceConfig;
            if (!(local || service.canReadData() && service.canWriteData())) {
                UIHelper.askUser(null, I18n.t((String)"observe.title.can.not.export.obstuna", (Object[])new Object[0]), I18n.t((String)"observe.storage.required.rw.on.data", (Object[])new Object[]{service}), 0, new Object[]{I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
                return;
            }
            String title = local ? I18n.t((String)"observe.title.save.localDB", (Object[])new Object[0]) : I18n.t((String)"observe.title.save.remoteDB", (Object[])new Object[0]);
            StorageBackupUILauncher launcher = new StorageBackupUILauncher((JAXXContext)this.ui, this.ui, title);
            launcher.start();
        }
    }
}

