/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.entities.longline.SectionTemplate;
import fr.ird.observe.ui.util.table.EditableTableModelSupport;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionTemplatesTableModel
extends EditableTableModelSupport<SectionTemplate> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SectionTemplatesTableModel.class);

    public SectionTemplatesTableModel() {
        super(true);
    }

    @Override
    public boolean isRowNotEmpty(SectionTemplate row) {
        return !StringUtils.isBlank((CharSequence)row.getId()) || !StringUtils.isBlank((CharSequence)row.getFloatlineLengths());
    }

    @Override
    public boolean isRowValid(SectionTemplate row) {
        return StringUtils.isNotBlank((CharSequence)row.getId()) && StringUtils.isNotBlank((CharSequence)row.getFloatlineLengths()) && row.isFloatlineLengthsValid();
    }

    @Override
    protected SectionTemplate createNewRow() {
        return new SectionTemplate();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result;
        SectionTemplate measure = (SectionTemplate)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = measure.getId();
                break;
            }
            case 1: {
                result = measure.getFloatlineLengths();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SectionTemplate measure = (SectionTemplate)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                measure.setId((String)aValue);
                break;
            }
            case 1: {
                measure.setFloatlineLengths((String)aValue);
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        this.setModified(true);
    }

    @Override
    protected boolean computeValidState() {
        boolean newValidState = super.computeValidState();
        if (newValidState) {
            HashSet<String> ids = new HashSet<String>();
            for (SectionTemplate sectionTemplate : this.data) {
                boolean add = ids.add(sectionTemplate.getId());
                if (add) continue;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Template identifiants (" + sectionTemplate.getId() + ") are not unique."));
                }
                newValidState = false;
                break;
            }
        }
        return newValidState;
    }

    @Override
    protected boolean isCanCreateNewRow(int rowIndex) {
        boolean canCreateNewRow = super.isCanCreateNewRow(rowIndex);
        if (canCreateNewRow) {
            canCreateNewRow = this.computeValidState();
        }
        return canCreateNewRow;
    }
}

