/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.nuiton.i18n.I18n;

public class StartServerModeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StartServerModeAction.class);
    private final ObserveMainUI ui;

    public StartServerModeAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.start.server.mode", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-start-server"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.start.server.mode.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will start server mode...");
        }
        ObserveConfig config = this.ui.getConfig();
        File dbDirectory = new File(config.getLocalDBDirectory(), "obstuna");
        String h2Login = config.getH2Login();
        String h2Password = new String(config.getH2Password());
        Integer port = config.getH2ServerPort();
        this.ui.setMode(ObserveUIMode.SERVER);
        try {
            Server server = Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers", "-ifExists", "-baseDir", dbDirectory.getAbsolutePath(), "-tcpDaemon", "-tcpPort", String.valueOf(port)});
            String url = String.format("jdbc:h2:%s/%s/obstuna", server.getURL(), dbDirectory.getAbsolutePath());
            server.start();
            if (log.isInfoEnabled()) {
                log.info((Object)("server starts at " + url));
            }
            String text = I18n.t((String)"observe.message.server.info", (Object[])new Object[]{dbDirectory});
            this.ui.getServerModeInfo().setText(text);
            this.ui.getServerModeURL().setText(url);
            this.ui.getServerModeLogin().setText(h2Login);
            this.ui.getServerModePassword().setText(h2Password);
            this.ui.setContextValue(server, "server");
        }
        catch (SQLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not start h2 server ", (Throwable)e);
            }
            ErrorDialogUI.showError((Exception)e);
        }
    }
}

