/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GotoSiteAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GotoSiteAction.class);
    private final ObserveMainUI ui;

    public GotoSiteAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.site", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"site"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.site.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 115);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ObserveConfig config = this.ui.getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(I18n.t((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        if (log.isInfoEnabled()) {
            log.info((Object)("goto " + siteURL));
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }
}

