/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.tripMap;

import com.google.common.collect.Lists;
import fr.ird.observe.ui.util.tripMap.ObserveMapPaneLegendItem;
import fr.ird.observe.ui.util.tripMap.ObserverMapPanLegendDrawer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.event.MapPaneListener;
import org.nuiton.i18n.I18n;

public class ObserveMapPane
extends JMapPane {
    private static final Log log = LogFactory.getLog(ObserveMapPane.class);
    protected static final int MARGIN = 10;
    protected static final int SCALE_HEIGHT = 15;
    protected static final int SCALE_WIDTH_MAX = 200;
    protected static final int METERS_BY_MILES = 1852;
    protected int scaleWidth = 100;
    protected String labelScaleUp = "0 m";
    protected double rotation = 0.0;
    protected static int AXIS_LENGHT = 30;
    protected static int CIRCLE_RADIUS = 20;
    protected static int CENTER_MARGIN = 60;
    protected static int INTER_AXIS_TEXT = 3;
    protected static int LEGEND_MARGIN = 3;
    protected List<ObserveMapPaneLegendItem> legendItems;

    public ObserveMapPane() {
        this.addMapPaneListener((MapPaneListener)new MapPaneAdapter(){

            public void onDisplayAreaChanged(MapPaneEvent ev) {
                ObserveMapPane.this.updateScale();
            }
        });
        this.legendItems = Lists.newArrayList();
    }

    protected void updateScale() {
        block2: {
            ReferencedEnvelope displayArea = this.getDisplayArea();
            double dpi = 0.0254;
            try {
                double meterPerPixel = RendererUtilities.calculateScale((ReferencedEnvelope)displayArea, (int)this.getWidth(), (int)this.getHeight(), (double)dpi);
                double maxWidthMeter = 200.0 * meterPerPixel;
                double maxWidthMiles = maxWidthMeter / 1852.0;
                int nbDigit = (int)Math.floor(Math.log10(maxWidthMiles));
                int firstDigit = (int)Math.floor(maxWidthMiles / Math.pow(10.0, nbDigit));
                int useFirstDigit = firstDigit >= 5 ? 5 : (firstDigit >= 2 ? 2 : 1);
                long scaleInMiles = (long)useFirstDigit * (long)Math.pow(10.0, nbDigit);
                this.scaleWidth = (int)Math.round((double)(scaleInMiles * 1852L) / meterPerPixel);
                this.labelScaleUp = String.format("%,d " + I18n.t((String)"observe.map.miles", (Object[])new Object[0]), scaleInMiles);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"error", (Throwable)e);
            }
        }
    }

    protected void paintScale(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D textArea = fm.getStringBounds(this.labelScaleUp, graphics);
        int labelLeft = this.getWidth() - 20 - this.scaleWidth - (int)textArea.getWidth();
        graphics.drawString(this.labelScaleUp, labelLeft, this.getHeight() - 10);
        int scalesEndX = this.getWidth() - 10;
        int scaleStartX = scalesEndX - this.scaleWidth;
        int scalesEndY = this.getHeight() - 10;
        int scaleStartY = scalesEndY - 15;
        graphics.drawLine(scaleStartX, scaleStartY, scaleStartX, scalesEndY);
        graphics.drawLine(scaleStartX, scalesEndY, scalesEndX, scalesEndY);
        graphics.drawLine(scalesEndX, scalesEndY, scalesEndX, scaleStartY);
    }

    protected void paintCompass(Graphics graphics) {
        Point center = new Point(this.getWidth() - CENTER_MARGIN, CENTER_MARGIN);
        graphics.drawOval(center.x - CIRCLE_RADIUS, center.y - CIRCLE_RADIUS, CIRCLE_RADIUS * 2, CIRCLE_RADIUS * 2);
        FontMetrics fm = graphics.getFontMetrics();
        for (CardinalPoint cardinalPoint : CardinalPoint.values()) {
            Point2D.Double direction = cardinalPoint.getDirection(this.rotation, AXIS_LENGHT, center);
            graphics.drawLine(center.x, center.y, (int)((Point2D)direction).getX(), (int)((Point2D)direction).getY());
            Rectangle2D textArea = fm.getStringBounds(cardinalPoint.getLabel(), graphics);
            double l = cardinalPoint.distanceCenterBorder(this.rotation, textArea);
            Point2D.Double textCenter = cardinalPoint.getDirection(this.rotation, (double)(AXIS_LENGHT + INTER_AXIS_TEXT) + l, center);
            graphics.drawString(cardinalPoint.getLabel(), (int)(((Point2D)textCenter).getX() - textArea.getWidth() / 2.0), (int)(((Point2D)textCenter).getY() + textArea.getHeight() / 2.0));
        }
    }

    public List<ObserveMapPaneLegendItem> getLegendItems() {
        return this.legendItems;
    }

    public void setLegendItems(List<ObserveMapPaneLegendItem> legendItems) {
        this.legendItems = legendItems;
    }

    protected void paintLegend(Graphics graphics) {
        if (this.legendItems != null) {
            int x = 0;
            int y = this.getHeight() - 20 * this.legendItems.size() - 2 * LEGEND_MARGIN;
            ObserverMapPanLegendDrawer drawer = new ObserverMapPanLegendDrawer();
            FontMetrics fm = graphics.getFontMetrics();
            int maxLabelWidth = 0;
            for (ObserveMapPaneLegendItem item : this.legendItems) {
                Rectangle2D labelArea = fm.getStringBounds(item.getLabel(), graphics);
                maxLabelWidth = Math.max((int)labelArea.getWidth(), maxLabelWidth);
            }
            int legendWidth = 50 + maxLabelWidth + 10;
            graphics.setColor(ObserveMapPaneLegendItem.LEGEND_BACKGROUND);
            graphics.fillRect(x, y, legendWidth, LEGEND_MARGIN);
            y += LEGEND_MARGIN;
            for (ObserveMapPaneLegendItem item : this.legendItems) {
                graphics.setColor(ObserveMapPaneLegendItem.LEGEND_BACKGROUND);
                graphics.fillRect(x, y, legendWidth, 20);
                BufferedImage symbole = new BufferedImage(50, 20, 2);
                Style style = item.getStyle();
                for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
                    for (Rule rule : featureTypeStyle.rules()) {
                        if (!rule.getFilter().evaluate((Object)item.getSimpleFeature())) continue;
                        drawer.drawDirect(symbole, item.getSimpleFeature(), rule);
                    }
                }
                graphics.drawImage(symbole, x + LEGEND_MARGIN, y, null);
                graphics.setColor(Color.BLACK);
                int labelMarginBottom = (20 - fm.getHeight()) / 2 + fm.getDescent();
                graphics.drawString(item.getLabel(), x + LEGEND_MARGIN + 50, y + 20 - labelMarginBottom);
                y += 20;
            }
            graphics.setColor(ObserveMapPaneLegendItem.LEGEND_BACKGROUND);
            graphics.fillRect(x, y, legendWidth, LEGEND_MARGIN);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintScale(graphics);
        this.paintCompass(graphics);
        this.paintLegend(graphics);
    }

    protected static enum CardinalPoint {
        NORTH(-1, 0, 0, -1, I18n.n((String)"observe.map.north", (Object[])new Object[0])),
        SOUTH(1, 0, 0, 1, I18n.n((String)"observe.map.south", (Object[])new Object[0])),
        WEST(0, -1, 1, 0, I18n.n((String)"observe.map.west", (Object[])new Object[0])),
        EST(0, 1, -1, 0, I18n.n((String)"observe.map.east", (Object[])new Object[0]));

        protected int matrix00;
        protected int matrix01;
        protected int matrix10;
        protected int matrix11;
        protected String label;

        private CardinalPoint(int matrix00, int matrix01, int matrix10, int matrix11, String label) {
            this.matrix00 = matrix00;
            this.matrix01 = matrix01;
            this.matrix10 = matrix10;
            this.matrix11 = matrix11;
            this.label = label;
        }

        public Point2D.Double getDirection(double angle, double length, Point center) {
            double x = Math.sin(angle) * length;
            double y = Math.cos(angle) * length;
            double deltaX = (double)this.matrix00 * x + (double)this.matrix01 * y;
            double deltaY = (double)this.matrix10 * x + (double)this.matrix11 * y;
            Point2D.Double result = new Point2D.Double(center.getX() + deltaX, center.getY() + deltaY);
            return result;
        }

        public double distanceCenterBorder(double angle, Rectangle2D textArea) {
            double x = Math.sin(angle);
            double y = Math.cos(angle);
            double deltaW = Math.abs(textArea.getWidth() / 2.0 / ((double)this.matrix00 * x + (double)this.matrix01 * y));
            double deltaH = Math.abs(textArea.getHeight() / 2.0 / ((double)this.matrix10 * x + (double)this.matrix11 * y));
            double delta = Math.min(deltaH, deltaW);
            return delta;
        }

        public String getLabel() {
            return I18n.t((String)this.label, (Object[])new Object[0]);
        }
    }
}

