/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.impl.PGDataSource;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.ui.storage.RemoteUILauncher;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.sql.SQLException;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public enum ObstunaAdminAction {
    CREATE(I18n.n((String)"observe.obstuna.action.create", (Object[])new Object[0]), I18n.n((String)"observe.obstuna.action.create.description", (Object[])new Object[0]), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n.t((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected void init(StorageUI ui) {
                    StorageUIModel model = ui.getModel();
                    model.getPgConfig().setCreationMode(CreationMode.IMPORT_REMOTE_STORAGE);
                    model.getPgConfig().setCanMigrate(true);
                    super.init(ui);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void checkImportDbVersion(StorageUIModel model, DataSourceConfig dataSourceConfig) throws DataSourceException {
                    DataSource importDatasource = DataSourceFactory.newService((DataSourceConfig)dataSourceConfig);
                    try {
                        importDatasource.doOpen();
                        model.checkImportDbVersion(importDatasource);
                    }
                    finally {
                        importDatasource.doClose(false);
                    }
                }

                @Override
                protected void initTask(StorageUIModel model, PGInstall task) throws Exception {
                    PGDataSourceConfig pgConfig = model.getPgConfig();
                    pgConfig.setCanMigrate(false);
                    pgConfig.setCreationMode(model.getReferentielImportMode());
                    DataSourceConfig importReferenceConfig = model.toImportReferentielSourceConfig();
                    pgConfig.setImportConfig(importReferenceConfig);
                    if (importReferenceConfig != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Use referentiel import data source " + importReferenceConfig.getLabel()));
                        }
                        this.checkImportDbVersion(model, importReferenceConfig);
                    }
                    DataSourceConfig importDataConfig = model.toImportDataSourceConfig();
                    pgConfig.setImportDataConfig(importDataConfig);
                    Set importDataIds = null;
                    if (importDataConfig != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Use data import data source " + importDataConfig.getLabel()));
                        }
                        this.checkImportDbVersion(model, importDataConfig);
                        DataSelectionModel dataModel = model.getSelectDataModel();
                        if (!dataModel.isDataFull()) {
                            importDataIds = dataModel.getSelectedData();
                        }
                        pgConfig.setImportDataIds(importDataIds);
                    }
                    pgConfig.setImportDataIds(importDataIds);
                    super.initTask(model, task);
                }

                @Override
                protected String getPgLabel() {
                    return I18n.t((String)"observe.storage.label.db.to.create", (Object[])new Object[0]);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(PGInstall task) throws Exception {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Create db...");
                    }
                    task.dropDb();
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Open [" + service.getLabel() + "] and create it."));
                    }
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    UPDATE(I18n.n((String)"observe.obstuna.action.update", (Object[])new Object[0]), I18n.n((String)"observe.obstuna.action.update.description", (Object[])new Object[0]), Versions.valueOf((String)"1.0")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n.t((String)this.getLabel(), (Object[])new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute(PGInstall task) throws Exception {
                    PGDataSourceConfig config = task.getDataSourceConfig();
                    PGDataSource service = DataSourceFactory.newService((PGDataSourceConfig)config);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Open [" + service.getLabel() + "] and update it."));
                    }
                    try {
                        service.doOpen();
                    }
                    finally {
                        service.doClose(false);
                    }
                }

                @Override
                protected String getPgLabel() {
                    return I18n.t((String)"observe.storage.label.db.to.update", (Object[])new Object[0]);
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    SECURITY(I18n.n((String)"observe.obstuna.action.security", (Object[])new Object[0]), I18n.n((String)"observe.obstuna.action.security.description", (Object[])new Object[0]), Versions.valueOf((String)"1.4")){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n.t((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected String getPgLabel() {
                    return I18n.t((String)"observe.storage.label.db.to.update.security", (Object[])new Object[0]);
                }

                @Override
                protected void applySecurity(PGInstall task) throws SQLException {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Apply security...");
                    }
                    task.applySecurity();
                }
            };
        }
    }
    ,
    DROP(I18n.n((String)"observe.obstuna.action.drop", (Object[])new Object[0]), I18n.n((String)"observe.obstuna.action.drop.description", (Object[])new Object[0]), null){

        @Override
        public RemoteUILauncher newLauncher(JAXXContext context, Window frame) {
            return new RemoteUILauncher(this, context, frame, I18n.t((String)this.getLabel(), (Object[])new Object[0])){

                @Override
                protected String getPgLabel() {
                    return I18n.t((String)"observe.storage.label.db.to.drop", (Object[])new Object[0]);
                }

                @Override
                protected void execute(PGInstall task) throws Exception {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Drop db...");
                    }
                    task.dropDb();
                }
            };
        }
    };

    private static Log log;
    private final String label;
    private final String description;
    private final Version requiredVersion;

    private ObstunaAdminAction(String label, String description, Version requiredVersion) {
        this.label = label;
        this.description = description;
        this.requiredVersion = requiredVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getRequiredVersion() {
        return this.requiredVersion;
    }

    public static ObstunaAdminAction valueOfIgnoreCase(String value) {
        for (ObstunaAdminAction step : ObstunaAdminAction.values()) {
            if (!step.name().equalsIgnoreCase(value)) continue;
            return step;
        }
        return null;
    }

    public abstract RemoteUILauncher newLauncher(JAXXContext var1, Window var2);

    static {
        log = LogFactory.getLog(ObstunaAdminAction.class);
    }
}

