/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.longline.ActivityLonglineUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Calendar;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class ActivityLonglineUIHandler
extends ContentOpenableUIHandler<ActivityLongline> {
    private static Log log = LogFactory.getLog(ActivityLonglineUIHandler.class);
    public static final String UPDATE_MAREE_NODE = "updateTripNode";

    public ActivityLonglineUIHandler(ActivityLonglineUI ui) {
        super(ui, DataContextType.TripLongline, DataContextType.ActivityLongline, I18n.n((String)"observe.activityLongline.message.not.open", (Object[])new Object[0]));
    }

    @Override
    public ActivityLonglineUI getUi() {
        return (ActivityLonglineUI)super.getUi();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activityId = this.getSelectedId();
        if (activityId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        ActivityLonglineUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(TripLongline.class)) {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(TripLongline.class), I18n.t((String)"observe.tripLongline.message.not.open", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        } else {
            this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        this.resetQuadrant(this.getUi().getCoordinatesEditor());
        String tripId = this.getSelectedParentId();
        String activityId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "tripId     = " + tripId));
            log.info((Object)(this.prefix + "activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode " + (Object)((Object)mode)));
        }
        ActivityLongline bean = (ActivityLongline)this.getBean();
        DataService dataService = this.getDataService();
        boolean create = activityId == null;
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreate(source, tripId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activityId, this.getLoadExecutor());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat  = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        this.finalizeOpenUI(mode, create);
        this.getUi().getCoordinatesEditor().setLatitudeAndLongitude(bean.getLatitude(), bean.getLongitude());
        if (create) {
            Integer quadrant = bean.getQuadrant();
            this.getUi().getCoordinatesEditor().setQuadrant(null);
            this.getUi().getCoordinatesEditor().setQuadrant(quadrant);
        }
        this.getModel().setModified(create);
    }

    @Override
    protected ActivityLongline onPreCreate(TopiaContext tx, Object parent, ActivityLongline bean) throws TopiaException {
        Date timestamp;
        TripLongline parentBean = (TripLongline)parent;
        bean.setOpen(true);
        bean.setLatitude(null);
        bean.setLongitude(null);
        ActivityLongline lastActivityLongline = parentBean.getLastActivity();
        if (lastActivityLongline == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parentBean.getStartDate());
            timestamp = calendar.getTime();
        } else {
            lastActivityLongline.initCoordinates();
            Integer quadrant = lastActivityLongline.getQuadrant();
            if (log.isDebugEnabled()) {
                log.debug((Object)("use quadrant of previous activity [" + quadrant + "]"));
            }
            bean.setQuadrant(quadrant);
            timestamp = lastActivityLongline.getTimeStamp();
        }
        bean.setTimeStamp(timestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ActivityLonglineUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContext(contextName);
        if (create) {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.creating", (Object[])new Object[0]));
        } else {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.updating", (Object[])new Object[0]));
        }
        super.startEditUI("timeStamp.date", "seaSurfaceTemperature.model", "comment2.text", "vesselActivityLongline.selectedItem", "fpaZone.selectedItem", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(ActivityLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ActivityLongline> binder) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        boolean create = bean.getTopiaId() == null;
        String tripId = this.getSelectedParentId();
        bean.setOpen(true);
        if (create) {
            bean = (ActivityLongline)dataService.create(dataSource, tripId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, tripId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.updateTripEndDate(tripId);
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected ActivityLongline onCreate(TopiaContext tx, Object parent, ActivityLongline editBean) throws TopiaException {
        TripLongline parentBean = (TripLongline)parent;
        ActivityLongline beanToSave = (ActivityLongline)ObserveDAOHelper.getActivityLonglineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivityLongline(beanToSave);
        return beanToSave;
    }

    @Override
    protected ActivityLongline onUpdate(TopiaContext tx, Object parentBean, ActivityLongline beanToSave) throws TopiaException {
        ActivityLongline editBean = (ActivityLongline)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Final time to use : " + editBean.getTimeStamp()));
        }
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"encounter", "sensorUsed"});
        if (log.isInfoEnabled()) {
            log.info((Object)("Is activity open ? : " + beanToSave.isOpen()));
        }
        return beanToSave;
    }

    @Override
    protected boolean doDelete(ActivityLongline bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, ActivityLongline> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete Activity " + bean.getTopiaId()));
        }
        String tripId = this.getSelectedParentId();
        dataService.delete(dataSource, tripId, (TopiaEntity)bean, deletor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete done for Activity " + bean.getTopiaId()));
        }
        this.updateTripEndDate(tripId);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, ActivityLongline beanToDelete) {
        TripLongline parentBean = (TripLongline)parent;
        parentBean.removeActivityLongline(beanToDelete);
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
        this.repaintTripNode();
    }

    @Override
    protected void afterDelete() {
        super.afterDelete();
        this.repaintTripNode();
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(TripLongline.class) && !dataContext.isOpenActivity();
        return canReopen;
    }

    protected void updateTripEndDate(String tripId) {
        boolean wasUpdated;
        try {
            wasUpdated = this.getDataService().updateEndDate(this.getDataSource(), tripId);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not update end date", (Throwable)e);
        }
        if (wasUpdated) {
            this.getUi().setContextValue(Boolean.TRUE, UPDATE_MAREE_NODE);
        } else {
            this.getUi().removeContextValue(Boolean.class, UPDATE_MAREE_NODE);
        }
    }

    protected void repaintTripNode() {
        Boolean updateTripNode = this.getUi().getContextValue(Boolean.class, UPDATE_MAREE_NODE);
        this.getUi().removeContextValue(Boolean.class, UPDATE_MAREE_NODE);
        if (updateTripNode == null || !updateTripNode.booleanValue()) {
            return;
        }
        ObserveTreeHelper treeHelper = ActivityLonglineUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode tripNode = (ObserveNode)((ObserveNode)((ObserveNode)treeHelper.getSelectedNode()).getParent()).getParent();
        if (log.isInfoEnabled()) {
            log.info((Object)("Refresh trip node : " + (Object)((Object)tripNode)));
        }
        treeHelper.reloadNode(tripNode, false);
    }

    static {
        I18n.n((String)"observe.common.latitude", (Object[])new Object[0]);
        I18n.n((String)"observe.common.longitude", (Object[])new Object[0]);
    }
}

