/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.ActivitySeinesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ActivitySeinesUIHandler
extends ContentListUIHandler<Route, ActivitySeine> {
    private static Log log = LogFactory.getLog(ActivitySeinesUIHandler.class);

    public ActivitySeinesUIHandler(ActivitySeinesUI ui) {
        super(ui, DataContextType.Route, DataContextType.ActivitySeine);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openRouteId = dataContext.getOpenRouteId();
        if (openRouteId == null) {
            this.addInfoMessage(I18n.n((String)"observe.route.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openActivity = dataContext.isOpenActivity();
        if (dataContext.isSelectedOpen(Route.class)) {
            if (openActivity) {
                this.addInfoMessage(I18n.n((String)"observe.activitySeine.message.active.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n((String)"observe.activitySeine.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openActivity) {
            this.addInfoMessage(I18n.n((String)"observe.activitySeine.message.active.found.for.other.route", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n((String)"observe.activitySeine.message.no.active.found.for.other.route", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<ActivitySeine> getChilds(Route bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List list = dataService.getActivitySeineStubByRoute(source, bean.getTopiaId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " activities."));
        }
        return list;
    }
}

