/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model;

import fr.ird.observe.ui.admin.report.model.DataMatrix;
import fr.ird.observe.ui.admin.report.model.Report;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public abstract class ReportOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReportOperation.class);

    public abstract String getOperationName();

    protected abstract Point computeLocation(Report var1, DataMatrix var2);

    protected abstract Dimension computeDimension(Report var1, DataMatrix var2);

    public abstract DataMatrix execute(TopiaContext var1, Report var2, DataMatrix var3) throws TopiaException;

    protected ReportOperation() {
    }

    protected DataMatrix createTmpMatrix(Report model, DataMatrix incoming) {
        DataMatrix result = new DataMatrix();
        Point location = this.computeLocation(model, incoming);
        result.setLocation(location);
        Dimension dim = this.computeDimension(model, incoming);
        result.setDimension(dim);
        result.createData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Operation [" + this.getOperationName() + "] tmp matrix : " + result));
        }
        return result;
    }
}

