/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.report;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.ui.report.Report;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public class ReportUIModel {
    public static final String SELECTED_MAREE_PROPERTY_NAME = "selectedMaree";
    public static final String SELECTED_REPORT_PROPERTY_NAME = "selectedReport";
    public static final String MAREES_PROPERTY_NAME = "marees";
    public static final String REPORTS_PROPERTY_NAME = "reports";
    protected StorageService<?> service;
    protected List<Maree> marees;
    protected List<Report> reports;
    protected Maree selectedMaree;
    protected Report selectedReport;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public StorageService<?> getService() {
        return this.service;
    }

    public Maree getSelectedMaree() {
        return this.selectedMaree;
    }

    public List<Report> getReports() {
        if (this.reports == null) {
            ArrayList<Report> reports = new ArrayList<Report>();
            this.setReports(reports);
        }
        return this.reports;
    }

    public List<Maree> getMarees() {
        if (this.marees == null) {
            if (this.service == null) {
                throw new IllegalStateException("no service registred");
            }
            try {
                List list = this.service.getList(Maree.class);
                this.setMarees(list);
            }
            catch (StorageServiceException e) {
                throw new IllegalStateException("could not retreave marees from " + this.service);
            }
        }
        return this.marees;
    }

    public void setSelectedReport(Report selectedReport) {
        Report oldValue = this.selectedReport;
        this.selectedReport = selectedReport;
        this.firePropertyChange(SELECTED_REPORT_PROPERTY_NAME, oldValue, selectedReport);
    }

    public void setSelectedMaree(Maree selectedMaree) {
        Maree oldValue = this.selectedMaree;
        this.selectedMaree = selectedMaree;
        this.firePropertyChange(SELECTED_MAREE_PROPERTY_NAME, oldValue, selectedMaree);
    }

    public void setMarees(List<Maree> marees) {
        this.marees = marees;
        this.firePropertyChange(MAREES_PROPERTY_NAME, null, marees);
    }

    public void setReports(List<Report> reports) {
        this.reports = reports;
        this.firePropertyChange(REPORTS_PROPERTY_NAME, null, reports);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void setService(StorageService<?> service) {
        this.service = service;
    }
}

