/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeDAO;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.impl.AbstractStorageService;
import fr.ird.observe.ui.admin.MareeToExportTableModel;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class ExportDataAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(ExportDataAction.class);
    protected boolean wasInit;
    protected boolean canTreate;
    protected MareeToExportTableModel.DataEntry[] data;
    protected Decorator<?> pDecorator;
    protected Decorator<?> mDecorator;

    public ExportDataAction() {
        super(SynchroStep.EXPORT_DATA);
    }

    @Override
    public void destroy() {
        this.data = null;
        this.pDecorator = null;
        this.mDecorator = null;
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (this.wasInit) {
            return;
        }
        DecoratorService decoratorProvider = this.getDecoratorService();
        this.pDecorator = decoratorProvider.getDecorator(Programme.class);
        this.mDecorator = decoratorProvider.getDecorator(Maree.class);
        StorageService<?> referentielService = model.getReferentielService();
        if (referentielService == null) {
            referentielService = this.createReferentielService(model.getReferentielServiceModel());
            model.setReferentielService(referentielService);
        }
        if (!referentielService.canWriteData()) {
            this.sendMessage(I18n._((String)"observe.message.can.not.write.data"));
            return;
        }
        this.openService(referentielService);
        this.openService(model.getSynchroService());
        this.canTreate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        int[] selectedIndex;
        log.debug((Object)this);
        if (!this.canTreate) {
            this.sendMessage(I18n._((String)"observe.message.exportData.not.possible"));
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.CANCELED;
        }
        if (!this.wasInit) {
            this.sendMessage(I18n._((String)"observe.message.exportData.prepare.data"));
            AbstractStorageService referentielService = (AbstractStorageService)model.getReferentielService();
            AbstractStorageService tmpService = (AbstractStorageService)model.getSynchroService();
            try {
                this.prepareData(referentielService);
            }
            finally {
                this.wasInit = true;
            }
            if (this.isCancelled()) {
                return this.onCancel(model, (Exception)null);
            }
            if (this.data == null) {
                this.sendMessage(I18n._((String)"observe.message.exportData.not.possible"));
                this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                return WizardOperationState.CANCELED;
            }
            this.sendMessage(I18n._((String)"observe.message.exportData.operation.needFix", (Object[])new Object[]{new Date()}));
            return WizardOperationState.NEED_FIX;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        AbstractStorageService referentielService = (AbstractStorageService)model.getReferentielService();
        StorageService<?> tmpService = model.getSynchroService();
        ArrayList<MareeToExportTableModel.DataEntry> entries = new ArrayList<MareeToExportTableModel.DataEntry>();
        for (int index : selectedIndex = model.getExportDataSelectedIndex()) {
            entries.add(this.data[index]);
        }
        this.deleteMarees(referentielService, entries);
        for (MareeToExportTableModel.DataEntry entry : entries) {
            Maree m = entry.getMaree();
            Programme p = m.getProgramme();
            this.sendMessage(I18n._((String)"observe.message.exportData.replicate.maree", (Object[])new Object[]{this.mDecorator.toString((Object)m), this.pDecorator.toString((Object)p)}));
            this.replicateData(tmpService, (StorageService<?>)referentielService, m.getTopiaId());
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardOperationState.SUCCESSED;
    }

    @Override
    public void copyTo(SynchroOperationAction newAction) {
        ExportDataAction n = (ExportDataAction)newAction;
        n.wasInit = this.wasInit;
        n.canTreate = this.canTreate;
        n.data = this.data;
        n.mDecorator = this.mDecorator;
        n.pDecorator = this.pDecorator;
    }

    public MareeToExportTableModel.DataEntry[] getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareData(AbstractStorageService<?> referentielService) throws Exception {
        List existingMarees;
        TopiaContext srcCtxt = referentielService.newCtxt();
        try {
            existingMarees = ObserveDAOHelper.getMareeDAO((TopiaContext)srcCtxt).findAllIds();
        }
        finally {
            srcCtxt.closeContext();
        }
        ArrayList<MareeToExportTableModel.DataEntry> entries = new ArrayList<MareeToExportTableModel.DataEntry>();
        SelectDataModel exportDataModel = this.getModel().getSelectExportDataModel();
        Map datas = exportDataModel.getSelectedDataByProgramme();
        for (Programme p : datas.keySet()) {
            List marees = (List)datas.get(p);
            if (marees == null || marees.isEmpty()) continue;
            for (Maree m : marees) {
                MareeToExportTableModel.DataEntry entry = new MareeToExportTableModel.DataEntry();
                entry.setProgramme(p);
                entry.setMaree(m);
                entry.setExist(existingMarees.contains(m.getTopiaId()));
                entries.add(entry);
            }
        }
        this.data = entries.toArray(new MareeToExportTableModel.DataEntry[entries.size()]);
    }

    protected void deleteMarees(AbstractStorageService<?> referentielService, List<MareeToExportTableModel.DataEntry> entries) throws Exception {
        TopiaContext refCtxt = referentielService.newCtxt();
        try {
            MareeDAO refMareeDAO = ObserveDAOHelper.getMareeDAO((TopiaContext)refCtxt);
            for (MareeToExportTableModel.DataEntry entry : entries) {
                Programme p = entry.getProgramme();
                Maree m = entry.getMaree();
                Boolean exists = entry.isExist();
                if (!exists.booleanValue()) continue;
                this.sendMessage(I18n._((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{this.mDecorator.toString((Object)m), this.pDecorator.toString((Object)p)}));
                Maree dMaree = (Maree)refMareeDAO.findByTopiaId(m.getTopiaId());
                refMareeDAO.delete(dMaree);
            }
            refCtxt.commitTransaction();
        }
        catch (Exception e) {
            refCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            refCtxt.closeContext();
        }
    }
}

