/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.services.gps.GPSImportModel;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.constants.CreationMode;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.services.storage.model.StorageSelectDataModel;
import fr.ird.observe.services.validation.ValidationModel;
import fr.ird.observe.services.validation.ValidationModelMode;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.ValidatorsMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SynchroUIModel
extends WizardOperationModel<SynchroStep> {
    private static final Log log = LogFactory.getLog(SynchroUIModel.class);
    public static final String BUSY_PROPERTY_NAME = "busy";
    public static final String SHOW_RESUME_PROPERTY_NAME = "showResume";
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String CAN_SAVE_LOCAL_PROPERTY_NAME = "canSaveLocal";
    public static final String LOCAL_SERVICE_NEED_SAVE_PROPERTY_NAME = "localServiceNeedSave";
    protected StorageService<?> previousService;
    protected StorageService<?> localService;
    protected StorageService<?> referentielService;
    protected StorageService<?> synchroService;
    protected File backupFile = new File("");
    protected boolean doBackup;
    protected boolean showResume;
    protected boolean localServiceNeedSave;
    protected boolean busy;
    protected StorageUIModel localServiceModel = new StorageUIModel(){

        @Override
        public String getLabel() {
            String txt = I18n.n_((String)"observe.storage.label.synchro.local");
            String params = this.dbMode == DbMode.CREATE_LOCAL ? this.h2Config.getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
            txt = I18n._((String)txt, (Object[])new Object[]{params});
            return txt;
        }

        public void validate() {
            super.validate();
            this.firePropertyChange("valid", null, this.isValid());
        }
    };
    protected StorageUIModel referentielServiceModel = new StorageUIModel(){

        @Override
        public String getLabel() {
            String txt = I18n.n_((String)"observe.storage.label.synchro.referentiel");
            String params = this.dbMode == DbMode.CREATE_LOCAL ? this.h2Config.getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
            txt = I18n._((String)txt, (Object[])new Object[]{params});
            return txt;
        }

        public void validate() {
            super.validate();
            boolean valid = this.isValid();
            this.firePropertyChange("valid", null, valid);
            if (valid) {
                // empty if block
            }
        }
    };
    protected int[] importGPSSelectedIndex;
    protected int[] exportDataSelectedIndex;
    protected ValidationModel validationModel = new ValidationModel();
    protected GPSImportModel gpsImportModel;
    protected SelectDataModel selectDataModel = new StorageSelectDataModel();
    protected SelectDataModel selectExportDataModel = new StorageSelectDataModel();

    public SynchroUIModel() {
        super(SynchroStep.class, (WizardOperationStep[])new SynchroStep[0]);
        this.gpsImportModel = new GPSImportModel();
    }

    public void start(JAXXContext context) {
        List steps;
        block10: {
            StorageService service;
            block9: {
                this.start();
                ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
                service = dataContext.getStorage();
                this.setPreviousService(service);
                steps = this.getSteps();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("enables steps = " + steps));
                    log.debug((Object)("enables operations = " + this.operations));
                }
                if (steps.contains((Object)SynchroStep.SELECT_EXPORT_DATA)) {
                    this.selectExportDataModel.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            SelectDataModel source = (SelectDataModel)evt.getSource();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("selection export data model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
                            }
                            SynchroUIModel.this.validate();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("nb selected export datas = " + source.getSelectedData().size() + ", nb selected referentiel = " + source.getSelectedReferentiel().size()));
                            }
                            SynchroUIModel.this.firePropertyChange("validStep", null, SynchroUIModel.this.validStep);
                        }
                    });
                    this.selectExportDataModel.setUseData(true);
                    this.selectExportDataModel.setUseOpenData(false);
                    this.selectExportDataModel.setUseReferentiel(false);
                    ((StorageSelectDataModel)this.selectExportDataModel).setService(service);
                    try {
                        this.selectExportDataModel.populate();
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block9;
                        log.error((Object)"could not populate selected model", (Throwable)e);
                    }
                }
            }
            if (steps.contains((Object)SynchroStep.SELECT)) {
                this.selectDataModel.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SelectDataModel source = (SelectDataModel)evt.getSource();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("selection model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
                        }
                        SynchroUIModel.this.validate();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("nb selected datas = " + source.getSelectedData().size() + ", nb selected referentiel = " + source.getSelectedReferentiel().size()));
                        }
                        SynchroUIModel.this.firePropertyChange("validStep", null, SynchroUIModel.this.validStep);
                    }
                });
                ((StorageSelectDataModel)this.selectDataModel).setService(service);
                this.selectDataModel.setUseOpenData(true);
                try {
                    this.selectDataModel.populate();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"could not populate selected model", (Throwable)e);
                }
            }
        }
        this.localServiceModel.init(context);
        this.localServiceModel.setDbMode(DbMode.CREATE_LOCAL);
        this.localServiceModel.setCreationMode(CreationMode.USE_LOCAL_STORAGE);
        this.localServiceModel.start();
        this.referentielServiceModel.init(context);
        this.referentielServiceModel.setDbMode(DbMode.USE_REMOTE);
        this.referentielServiceModel.start();
        StorageUIHandler storageUIHandler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class);
        storageUIHandler.testRemote(context, this.referentielServiceModel);
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        File backupfile = new File(config.getBackupDirectory(), storageUIHandler.getDefaultBackupFilename());
        this.setBackupFile(backupfile);
        this.setDoBackup(true);
        this.setShowResume(config.isDisplaySynchroResume());
        if (steps.contains((Object)SynchroStep.IMPORT_GPS)) {
            this.gpsImportModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("gps import model has changed [" + evt.getPropertyName() + "] = " + evt.getNewValue()));
                    }
                    SynchroUIModel.this.validate();
                }
            });
            this.gpsImportModel.setImportGPSMaxDelay(Integer.valueOf(config.getDefaultGpsMaxDelay()));
            this.gpsImportModel.setImportGPSMaxSpeed(Float.valueOf(config.getDefaultGpsMaxSpeed()));
        }
        if (steps.contains((Object)SynchroStep.VALIDATE)) {
            this.validationModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ValidationModel source = (ValidationModel)evt.getSource();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("validation model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
                    }
                    SynchroUIModel.this.validate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("nb validators = " + source.getValidators().size()));
                    }
                    SynchroUIModel.this.firePropertyChange("validStep", null, SynchroUIModel.this.validStep);
                }
            });
            this.validationModel.addScope(BeanValidatorScope.ERROR);
            this.validationModel.setModelMode(ValidationModelMode.DATA);
            this.validationModel.setAllContextNames(new String[]{"n1-update", "n1-create"});
            this.validationModel.setContextName("n1-update");
            File reportFile = new File(config.getReportDirectory(), this.getDefaultReportFilename());
            this.validationModel.setReportFile(reportFile);
        }
    }

    public void destroy() {
        this.validationModel.destroy();
        this.gpsImportModel.destroy();
        this.selectDataModel.destroy();
        this.selectExportDataModel.destroy();
        this.localServiceModel.destroy();
        this.referentielServiceModel.destroy();
        Set operations = this.getOperations();
        for (SynchroStep op : operations) {
            SynchroOperationAction action = this.getOperationAction(op);
            if (log.isDebugEnabled()) {
                log.debug((Object)("destroy action " + (Object)((Object)action)));
            }
            action.destroy();
        }
        super.destroy();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public String getDefaultReportFilename() {
        return String.format("report-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    public StorageService<?> getPreviousService() {
        return this.previousService;
    }

    public StorageService<?> getLocalService() {
        return this.localService;
    }

    public StorageService<?> getReferentielService() {
        return this.referentielService;
    }

    public StorageService<?> getSynchroService() {
        return this.synchroService;
    }

    public StorageUIModel getLocalServiceModel() {
        return this.localServiceModel;
    }

    public StorageUIModel getReferentielServiceModel() {
        return this.referentielServiceModel;
    }

    public ValidationModel getValidationModel() {
        return this.validationModel;
    }

    public SelectDataModel getSelectDataModel() {
        return this.selectDataModel;
    }

    public SelectDataModel getSelectExportDataModel() {
        return this.selectExportDataModel;
    }

    public GPSImportModel getGpsImportModel() {
        return this.gpsImportModel;
    }

    public boolean isShowResume() {
        return this.showResume;
    }

    public boolean isLocalServiceNeedSave() {
        return this.localServiceNeedSave;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public int[] getImportGPSSelectedIndex() {
        return this.importGPSSelectedIndex;
    }

    public int[] getExportDataSelectedIndex() {
        return this.exportDataSelectedIndex;
    }

    public SynchroOperationAction getOperationAction(SynchroStep operation) {
        return (SynchroOperationAction)super.getOperationAction((WizardOperationStep)operation);
    }

    public void cancel() {
        super.cancel();
        if (this.showResume) {
            this.gotoStep((WizardStep)this.getSteps().get(this.getSteps().size() - 1));
        }
    }

    public SynchroUIModel addOperation(SynchroStep operation) {
        if (operation == SynchroStep.EXPORT_DATA) {
            this.getOperations().add(SynchroStep.SYNCHRONIZE_REFERENTIEL);
        }
        return (SynchroUIModel)super.addOperation((WizardOperationStep)operation);
    }

    public void removeOperation(SynchroStep operation) {
        if (operation == SynchroStep.SYNCHRONIZE_REFERENTIEL || operation == SynchroStep.VALIDATE) {
            this.getOperations().remove((Object)SynchroStep.EXPORT_DATA);
        }
        super.removeOperation((WizardOperationStep)operation);
    }

    public void setShowResume(boolean showResume) {
        boolean oldValue = this.showResume;
        this.showResume = showResume;
        this.firePropertyChange(SHOW_RESUME_PROPERTY_NAME, oldValue, showResume);
        this.updateUniverse();
    }

    public void setDoBackup(boolean doBackup) {
        boolean canSave = this.isCanSaveLocal();
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
        this.firePropertyChange(CAN_SAVE_LOCAL_PROPERTY_NAME, canSave, this.isCanSaveLocal());
        this.validate();
    }

    public void setBusy(boolean busy) {
        boolean oldValue = this.busy;
        this.busy = busy;
        this.firePropertyChange(BUSY_PROPERTY_NAME, oldValue, busy);
    }

    public void setLocalServiceNeedSave(boolean localServiceNeedSave) {
        this.localServiceNeedSave = localServiceNeedSave;
        this.firePropertyChange(LOCAL_SERVICE_NEED_SAVE_PROPERTY_NAME, null, localServiceNeedSave);
        if (localServiceNeedSave) {
            this.setOperationState(SynchroStep.SAVE_LOCAL, WizardOperationState.PENDING);
        }
        this.validate();
    }

    public void setBackupFile(File backupFile) {
        boolean canSave = this.isCanSaveLocal();
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.firePropertyChange(CAN_SAVE_LOCAL_PROPERTY_NAME, canSave, this.isCanSaveLocal());
        this.validate();
    }

    public void setImportGPSSelectedIndex(int[] importGPSSelectedIndex) {
        this.importGPSSelectedIndex = importGPSSelectedIndex;
    }

    public void setExportDataSelectedIndex(int[] exportDataSelectedIndex) {
        this.exportDataSelectedIndex = exportDataSelectedIndex;
    }

    public void setPreviousService(StorageService<?> previousService) {
        this.previousService = previousService;
    }

    public void setLocalService(StorageService<?> localService) {
        this.localService = localService;
    }

    public void setReferentielService(StorageService<?> referentielService) {
        this.referentielService = referentielService;
    }

    public void setSynchroService(StorageService<?> synchroService) {
        this.synchroService = synchroService;
    }

    protected SynchroStep[] updateStepUniverse() {
        for (SynchroStep op : this.operations) {
            if (this.operationStates.containsKey((Object)op)) continue;
            this.operationStates.put(op, WizardOperationState.PENDING);
        }
        for (SynchroStep op : this.operationStates.keySet()) {
            if (this.operations.contains((Object)op)) continue;
            this.operationStates.remove((Object)op);
        }
        ArrayList<SynchroStep> universe = new ArrayList<SynchroStep>();
        universe.add(SynchroStep.CONFIG);
        if (!this.operations.isEmpty()) {
            if (this.operations.contains((Object)SynchroStep.EXPORT_DATA)) {
                universe.add(SynchroStep.SELECT_EXPORT_DATA);
            }
            if (this.operations.contains((Object)SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                universe.add(SynchroStep.SYNCHRONIZE_REFERENTIEL);
            }
            if (this.operations.contains((Object)SynchroStep.VALIDATE)) {
                universe.add(SynchroStep.SELECT);
                universe.add(SynchroStep.VALIDATE);
            }
            if (this.operations.contains((Object)SynchroStep.IMPORT_GPS)) {
                universe.add(SynchroStep.IMPORT_GPS);
            }
            this.updateSaveLocalOperation();
            if (this.operations.contains((Object)SynchroStep.SAVE_LOCAL)) {
                universe.add(SynchroStep.SAVE_LOCAL);
            }
            if (this.operations.contains((Object)SynchroStep.EXPORT_DATA)) {
                universe.add(SynchroStep.EXPORT_DATA);
            }
            if (this.showResume) {
                universe.add(SynchroStep.SHOW_RESUME);
            }
        }
        return universe.toArray(new SynchroStep[universe.size()]);
    }

    protected void updateSaveLocalOperation() {
        boolean shouldAdd = false;
        for (SynchroStep s : this.operations) {
            if (!s.isNeedSave()) continue;
            shouldAdd = true;
        }
        if (shouldAdd) {
            this.operations.add(SynchroStep.SAVE_LOCAL);
        } else {
            this.operations.remove((Object)SynchroStep.SAVE_LOCAL);
        }
    }

    public boolean validate(SynchroStep s) {
        boolean validate;
        boolean bl = validate = super.validate((WizardStep)s) && !this.getOperations().isEmpty();
        if (!validate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"not valid from generic states...");
            }
            return false;
        }
        switch (s) {
            case CONFIG: {
                if (!(validate &= this.localServiceModel.isValid()) && log.isDebugEnabled()) {
                    log.debug((Object)"local service is not valid");
                }
                if (this.operations.contains((Object)SynchroStep.VALIDATE)) {
                    ValidatorsMap validators;
                    if (StringUtils.isEmpty((String)this.validationModel.getContextName())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation context name");
                        }
                        return false;
                    }
                    if (this.validationModel.getScopes().isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation scopes");
                        }
                        return false;
                    }
                    if (this.validationModel.getModelMode() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation model mode");
                        }
                        return false;
                    }
                    if (this.validationModel.isGenerateReport()) {
                        File file = this.validationModel.getReportFile();
                        if (file.exists()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"report file already exists");
                            }
                            return false;
                        }
                        File parentFile = file.getParentFile();
                        if (parentFile == null || !parentFile.exists()) {
                            return false;
                        }
                    }
                    if ((validators = this.getValidationModel().getValidators()).isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validators detected");
                        }
                        return false;
                    }
                }
                if (this.operations.contains((Object)SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                    validate &= this.referentielServiceModel.isValid();
                }
                if (this.operations.contains((Object)SynchroStep.EXPORT_DATA)) {
                    validate &= this.referentielServiceModel.isValid() && this.referentielServiceModel.getPgConfig().isCanWriteData();
                }
                if (!this.operations.contains((Object)SynchroStep.IMPORT_GPS)) break;
                File importGPSFile = this.gpsImportModel.getImportGPSFile();
                validate &= importGPSFile != null && importGPSFile.exists();
                break;
            }
            case SELECT: {
                if (!(validate &= this.validate(SynchroStep.CONFIG))) break;
                boolean empty = this.getSelectDataModel().isEmpty();
                validate &= !empty;
                break;
            }
            case SELECT_EXPORT_DATA: {
                if (!(validate &= this.validate(SynchroStep.CONFIG))) break;
                boolean empty = this.getSelectExportDataModel().isDataEmpty();
                validate &= !empty;
                break;
            }
            case VALIDATE: {
                validate &= this.validate(SynchroStep.SELECT) && this.getOperationState(s) == WizardOperationState.SUCCESSED;
                break;
            }
            case EXPORT_DATA: {
                validate &= this.validate(SynchroStep.SELECT_EXPORT_DATA) && this.getOperationState(s) == WizardOperationState.SUCCESSED;
                break;
            }
            case SYNCHRONIZE_REFERENTIEL: 
            case IMPORT_GPS: {
                validate &= this.getOperationState(s) == WizardOperationState.SUCCESSED;
                break;
            }
            case SAVE_LOCAL: {
                validate &= this.getOperationState(s) == WizardOperationState.SUCCESSED;
                break;
            }
            case SHOW_RESUME: {
                validate = true;
            }
        }
        return validate;
    }

    public boolean isCanSaveLocal() {
        boolean validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz") && this.backupFile.getParentFile().exists();
        return validate;
    }

    public void updateUniverse() {
        super.updateUniverse();
    }
}

