/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import java.util.Date;
import jaxx.runtime.swing.AbstractActionThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveActionThread
extends AbstractActionThread {
    private static final Log log = LogFactory.getLog(ObserveActionThread.class);

    protected ObserveActionThread() {
        super("ObServeActionThread");
    }

    public void onActionStart(AbstractActionThread.ActionWorker source) {
        ObserveMainUI ui;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + "] was started at " + new Date(source.getStartTime())));
        }
        if ((ui = ObserveContext.getObserveMainUI()) != null) {
            ui.setBusy(true);
        }
    }

    public void onActionFail(AbstractActionThread.ActionWorker source) {
        if (log.isInfoEnabled()) {
            Exception error = source.getError();
            if (log.isErrorEnabled()) {
                log.error((Object)("Action [" + source.getActionLabel() + "] failed with error " + error.getCause()), (Throwable)error);
            }
        }
        this.onActionEnd(source);
    }

    public void onActionCancel(AbstractActionThread.ActionWorker source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + "] was canceled"));
        }
        this.onActionEnd(source);
    }

    public void onActionEnd(AbstractActionThread.ActionWorker source) {
        ObserveMainUI ui;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + " ] was done in " + source.getTime()));
        }
        if ((ui = ObserveContext.getObserveMainUI()) != null) {
            ui.setBusy(false);
        }
    }
}

