/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;


public  class AgentDTO implements Agent {


@WikittyField(fqn="Agent.refNumber")    protected String refNumber;

@WikittyField(fqn="Agent.state")    protected String state;

@WikittyField(fqn="Agent.stateDate")    protected Date stateDate;

@WikittyField(fqn="Agent.agent")    protected Boolean agent;

@WikittyField(fqn="Agent.jobType")    protected String jobType;

@WikittyField(fqn="Agent.address")    protected String address;

@WikittyField(fqn="Agent.cati")    protected String cati;

@WikittyField(fqn="Agent.department")    protected String department;

@WikittyField(fqn="Agent.unit")    protected Set<String> unit = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyUser.login")    protected String login;

@WikittyField(fqn="WikittyUser.password")    protected String password;

@WikittyField(fqn="User.lastName")    protected String lastName;

@WikittyField(fqn="User.firstName")    protected String firstName;

@WikittyField(fqn="User.email")    protected String email;

@WikittyField(fqn="User.comment")    protected String comment;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getRefNumber :
     * @return String 
     */

    @Override
    public String getRefNumber() {
        return refNumber;
}

    /**
     * setRefNumber :
     * @param refNumber 
     */

    @Override
    public void setRefNumber(String refNumber) {
        this.refNumber=refNumber;
        modificationCount++;
}

    /**
     * getState :
     * @return String 
     */

    @Override
    public String getState() {
        return state;
}

    /**
     * setState :
     * @param state 
     */

    @Override
    public void setState(String state) {
        this.state=state;
        modificationCount++;
}

    /**
     * getStateDate :
     * @return Date 
     */

    @Override
    public Date getStateDate() {
        return stateDate;
}

    /**
     * setStateDate :
     * @param stateDate 
     */

    @Override
    public void setStateDate(Date stateDate) {
        this.stateDate=stateDate;
        modificationCount++;
}

    /**
     * getAgent :
     * @return Boolean 
     */

    @Override
    public Boolean getAgent() {
        return agent;
}

    /**
     * setAgent :
     * @param agent 
     */

    @Override
    public void setAgent(Boolean agent) {
        this.agent=agent;
        modificationCount++;
}

    /**
     * getJobType :
     * @return String 
     */

    @Override
    public String getJobType() {
        return jobType;
}

    /**
     * setJobType :
     * @param jobType 
     */

    @Override
    public void setJobType(String jobType) {
        this.jobType=jobType;
        modificationCount++;
}

    /**
     * getAddress :
     * @return String 
     */

    @Override
    public String getAddress() {
        return address;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(String address) {
        this.address=address;
        modificationCount++;
}

    /**
     * getCati :
     * @return String 
     */

    @Override
    public String getCati() {
        return cati;
}

    /**
     * setCati :
     * @param cati 
     */

    @Override
    public void setCati(String cati) {
        this.cati=cati;
        modificationCount++;
}

    /**
     * getDepartment :
     * @return String 
     */

    @Override
    public String getDepartment() {
        return department;
}

    /**
     * setDepartment :
     * @param department 
     */

    @Override
    public void setDepartment(String department) {
        this.department=department;
        modificationCount++;
}

    /**
     * getUnit :
     * @return Set<String> 
     */

    @Override
    public Set<String> getUnit() {
        return unit;
}

    /**
     * setUnit :
     * @param unit 
     */

    @Override
    public void setUnit(Set<String> unit) {
        if (unit == null){
            this.unit = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.unit=new LinkedHashSet<String>(unit);
        }
        modificationCount++;
}

    /**
     * addAllUnit :
     * @param unit 
     */

    @Override
    public void addAllUnit(Set<String> unit) {
        if (this.unit == null){
            this.unit = new LinkedHashSet<String>();
        }
        this.unit.addAll(unit);
        modificationCount++;
}

    /**
     * addUnit :
     * @param element 
     */

    @Override
    public void addUnit(String element) {
        if (this.unit == null){
            this.unit = new LinkedHashSet<String>();
        }
        this.unit.add(element);
        modificationCount++;
}

    /**
     * removeUnit :
     * @param element 
     */

    @Override
    public void removeUnit(String element) {
        unit.remove(element);
        modificationCount++;
}

    /**
     * clearUnit :
     */

    @Override
    public void clearUnit() {
        unit.clear();
        modificationCount++;
}

    /**
     * getLogin :
     * @return String 
     */

    @Override
    public String getLogin() {
        return login;
}

    /**
     * setLogin :
     * @param login 
     */

    @Override
    public void setLogin(String login) {
        this.login=login;
        modificationCount++;
}

    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        return password;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        this.password=password;
        modificationCount++;
}

    /**
     * getLastName :
     * @return String 
     */

    @Override
    public String getLastName() {
        return lastName;
}

    /**
     * setLastName :
     * @param lastName 
     */

    @Override
    public void setLastName(String lastName) {
        this.lastName=lastName;
        modificationCount++;
}

    /**
     * getFirstName :
     * @return String 
     */

    @Override
    public String getFirstName() {
        return firstName;
}

    /**
     * setFirstName :
     * @param firstName 
     */

    @Override
    public void setFirstName(String firstName) {
        this.firstName=firstName;
        modificationCount++;
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        return email;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        this.email=email;
        modificationCount++;
}

    /**
     * getComment :
     * @return String 
     */

    @Override
    public String getComment() {
        return comment;
}

    /**
     * setComment :
     * @param comment 
     */

    @Override
    public void setComment(String comment) {
        this.comment=comment;
        modificationCount++;
}

    /**
     * AgentDTO :
     */

    public AgentDTO() {
}

    /**
     * AgentDTO :
     * @param wikittyId 
     */

    public AgentDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof Agent)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        Agent sourceCopy = (Agent)source;

        setLogin(sourceCopy.getLogin());

        setPassword(sourceCopy.getPassword());

        setLastName(sourceCopy.getLastName());

        setFirstName(sourceCopy.getFirstName());

        setEmail(sourceCopy.getEmail());

        setComment(sourceCopy.getComment());

        setRefNumber(sourceCopy.getRefNumber());

        setState(sourceCopy.getState());

        setStateDate(sourceCopy.getStateDate());

        setAgent(sourceCopy.getAgent());

        setJobType(sourceCopy.getJobType());

        setAddress(sourceCopy.getAddress());

        setCati(sourceCopy.getCati());

        setDepartment(sourceCopy.getDepartment());

        Set<String> unit = sourceCopy.getUnit();
        if (unit != null){
            setUnit(new LinkedHashSet<String>(unit));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //AgentDTO
