/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Login.java 134 2011-03-22 14:24:29Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-client/src/main/java/fr/inra/refcomp/client/Login.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.Hello;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class Login extends Composite {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("Login.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Login> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    public Login() {
        initWidget(binder.createAndBindUi(this));
    }

    @UiField
    TextBox loginBox;

    @UiField
    PasswordTextBox passwordBox;

    @UiHandler("passwordBox")
    void pressKey(KeyPressEvent event) {
        if ((event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) ||
                (event.getNativeEvent().getCharCode() == KeyCodes.KEY_ENTER)) {
            doClickSubmit(null);
        }
    }

    @UiHandler("buttonSubmit")
    void doClickSubmit(ClickEvent event) {
        service.login(loginBox.getValue(), passwordBox.getValue(),
                new RefcompCallBack<Boolean>() {

                    @Override
                    public void onSuccess(Boolean result) {
                        if (result){
                            RefComp.logIn();
                            Menu.logIn();

                            //Add hello message
                            RootPanel.get("hello").clear();
                            RootPanel.get("hello").add(new Hello());

                            //Display home page after login
                            History.newItem("home");
                        } else {
                            RefcompMessages messages = GWT.create(RefcompMessages.class);
                            Window.alert(messages.loginFailed());
                        }
                    }
                });
    }
}
