/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Login.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/Login.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class Login extends Composite {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("Login.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Login> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    public Login() {
        initWidget(binder.createAndBindUi(this));
    }

    @UiField
    TextBox loginBox;

    @UiField
    PasswordTextBox passwordBox;

    @UiHandler("passwordBox")
    void pressKey(KeyPressEvent event) {
        if ((event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) ||
                (event.getNativeEvent().getCharCode() == KeyCodes.KEY_ENTER)) {
            doClickSubmit(null);
        }
    }

    @UiHandler("buttonSubmit")
    void doClickSubmit(ClickEvent event) {
        service.login(loginBox.getValue(), passwordBox.getValue(),
                new AsyncCallback<Boolean>() {
                    @Override
                    public void onFailure(Throwable caught) {
                        Window.alert("Server communication error");
                    }

                    @Override
                    public void onSuccess(Boolean result) {
                        if (result){
                            RefComp.logIn();
                            Menu.logIn();

                            RootPanel content = RootPanel.get("content");
                            content.clear();
                            content.add(new Home());
                        } else {
                            Window.alert("Login failed, try with admin/admin");
                        }
                    }
                });
    }
}
