/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import winstone.Launcher;
import winstone.Listener;
import winstone.Logger;
import winstone.RequestHandlerThread;
import winstone.WebAppConfiguration;
import winstone.WinstoneRequest;
import winstone.WinstoneResponse;

public class ObjectPool
implements Runnable {
    private static final long FLUSH_PERIOD = 60000L;
    private int STARTUP_REQUEST_HANDLERS_IN_POOL = 5;
    private int MAX_IDLE_REQUEST_HANDLERS_IN_POOL = 50;
    private int MAX_REQUEST_HANDLERS_IN_POOL = 1000;
    private long RETRY_PERIOD = 1000L;
    private int START_REQUESTS_IN_POOL = 10;
    private int MAX_REQUESTS_IN_POOL = 1000;
    private int START_RESPONSES_IN_POOL = 10;
    private int MAX_RESPONSES_IN_POOL = 1000;
    private List unusedRequestHandlerThreads;
    private List usedRequestHandlerThreads;
    private List unusedRequestPool;
    private List unusedResponsePool;
    private Object requestHandlerSemaphore = new Boolean(true);
    private Object requestPoolSemaphore = new Boolean(true);
    private Object responsePoolSemaphore = new Boolean(true);
    private int threadIndex = 0;
    private boolean simulateModUniqueId;
    private boolean saveSessions;
    private Thread thread;

    public ObjectPool(Map args) throws IOException {
        int n;
        this.simulateModUniqueId = WebAppConfiguration.booleanArg(args, "simulateModUniqueId", false);
        this.saveSessions = WebAppConfiguration.useSavedSessions(args);
        this.unusedRequestHandlerThreads = new ArrayList();
        this.usedRequestHandlerThreads = new ArrayList();
        this.unusedRequestPool = new ArrayList();
        this.unusedResponsePool = new ArrayList();
        if (args.get("handlerCountStartup") != null) {
            this.STARTUP_REQUEST_HANDLERS_IN_POOL = Integer.parseInt((String)args.get("handlerCountStartup"));
        }
        if (args.get("handlerCountMax") != null) {
            this.MAX_IDLE_REQUEST_HANDLERS_IN_POOL = Integer.parseInt((String)args.get("handlerCountMax"));
        }
        if (args.get("handlerCountMaxIdle") != null) {
            this.MAX_IDLE_REQUEST_HANDLERS_IN_POOL = Integer.parseInt((String)args.get("handlerCountMaxIdle"));
        }
        for (n = 0; n < this.STARTUP_REQUEST_HANDLERS_IN_POOL; ++n) {
            this.unusedRequestHandlerThreads.add(new RequestHandlerThread(this, this.threadIndex++, this.simulateModUniqueId, this.saveSessions));
        }
        for (n = 0; n < this.START_REQUESTS_IN_POOL; ++n) {
            this.unusedRequestPool.add(new WinstoneRequest());
        }
        for (n = 0; n < this.START_RESPONSES_IN_POOL; ++n) {
            this.unusedResponsePool.add(new WinstoneResponse());
        }
        this.thread = new Thread((Runnable)this, "WinstoneObjectPoolMgmt");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void run() {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                Thread.sleep(60000L);
                this.removeUnusedRequestHandlers();
            }
            catch (InterruptedException err) {
                interrupted = true;
            }
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnusedRequestHandlers() {
        Object object = this.requestHandlerSemaphore;
        synchronized (object) {
            while (this.unusedRequestHandlerThreads.size() > this.MAX_IDLE_REQUEST_HANDLERS_IN_POOL) {
                RequestHandlerThread rh = (RequestHandlerThread)this.unusedRequestHandlerThreads.get(0);
                rh.destroy();
                this.unusedRequestHandlerThreads.remove(rh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.requestHandlerSemaphore;
        synchronized (object) {
            ArrayList usedHandlers = new ArrayList(this.usedRequestHandlerThreads);
            Iterator i = usedHandlers.iterator();
            while (i.hasNext()) {
                this.releaseRequestHandler((RequestHandlerThread)i.next());
            }
            ArrayList unusedHandlers = new ArrayList(this.unusedRequestHandlerThreads);
            Iterator i2 = unusedHandlers.iterator();
            while (i2.hasNext()) {
                ((RequestHandlerThread)i2.next()).destroy();
            }
            this.unusedRequestHandlerThreads.clear();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Socket socket, Listener listener) throws IOException, InterruptedException {
        RequestHandlerThread rh = null;
        Object object = this.requestHandlerSemaphore;
        synchronized (object) {
            int unused = this.unusedRequestHandlerThreads.size();
            if (unused > 0) {
                rh = (RequestHandlerThread)this.unusedRequestHandlerThreads.remove(unused - 1);
                this.usedRequestHandlerThreads.add(rh);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.UsingRHPoolThread", new String[]{"" + this.usedRequestHandlerThreads.size(), "" + this.unusedRequestHandlerThreads.size()});
            } else if (this.usedRequestHandlerThreads.size() < this.MAX_REQUEST_HANDLERS_IN_POOL) {
                rh = new RequestHandlerThread(this, this.threadIndex++, this.simulateModUniqueId, this.saveSessions);
                this.usedRequestHandlerThreads.add(rh);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.NewRHPoolThread", new String[]{"" + this.usedRequestHandlerThreads.size(), "" + this.unusedRequestHandlerThreads.size()});
            } else {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ObjectPool.NoRHPoolThreadsRetry");
            }
        }
        if (rh != null) {
            rh.commenceRequestHandling(socket, listener);
        } else {
            Thread.sleep(this.RETRY_PERIOD);
            object = this.requestHandlerSemaphore;
            synchronized (object) {
                if (this.usedRequestHandlerThreads.size() < this.MAX_REQUEST_HANDLERS_IN_POOL) {
                    rh = new RequestHandlerThread(this, this.threadIndex++, this.simulateModUniqueId, this.saveSessions);
                    this.usedRequestHandlerThreads.add(rh);
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.NewRHPoolThread", new String[]{"" + this.usedRequestHandlerThreads.size(), "" + this.unusedRequestHandlerThreads.size()});
                }
            }
            if (rh != null) {
                rh.commenceRequestHandling(socket, listener);
            } else {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "ObjectPool.NoRHPoolThreads");
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRequestHandler(RequestHandlerThread rh) {
        Object object = this.requestHandlerSemaphore;
        synchronized (object) {
            this.usedRequestHandlerThreads.remove(rh);
            this.unusedRequestHandlerThreads.add(rh);
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.ReleasingRHPoolThread", new String[]{"" + this.usedRequestHandlerThreads.size(), "" + this.unusedRequestHandlerThreads.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinstoneRequest getRequestFromPool() throws IOException {
        WinstoneRequest req = null;
        Object object = this.requestPoolSemaphore;
        synchronized (object) {
            int unused = this.unusedRequestPool.size();
            if (unused > 0) {
                req = (WinstoneRequest)this.unusedRequestPool.remove(unused - 1);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.UsingRequestFromPool", "" + this.unusedRequestPool.size());
            }
            req = new WinstoneRequest();
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.NewRequestForPool");
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRequestToPool(WinstoneRequest req) {
        req.cleanUp();
        Object object = this.requestPoolSemaphore;
        synchronized (object) {
            if (this.unusedRequestPool.size() < this.MAX_REQUESTS_IN_POOL) {
                this.unusedRequestPool.add(req);
            }
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.RequestReleased", "" + this.unusedRequestPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinstoneResponse getResponseFromPool() throws IOException {
        WinstoneResponse rsp = null;
        Object object = this.responsePoolSemaphore;
        synchronized (object) {
            int unused = this.unusedResponsePool.size();
            if (unused > 0) {
                rsp = (WinstoneResponse)this.unusedResponsePool.remove(unused - 1);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.UsingResponseFromPool", "" + this.unusedResponsePool.size());
            }
            rsp = new WinstoneResponse();
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.NewResponseForPool");
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResponseToPool(WinstoneResponse rsp) {
        rsp.cleanUp();
        Object object = this.responsePoolSemaphore;
        synchronized (object) {
            if (this.unusedResponsePool.size() < this.MAX_RESPONSES_IN_POOL) {
                this.unusedResponsePool.add(rsp);
            }
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "ObjectPool.ResponseReleased", "" + this.unusedResponsePool.size());
        }
    }
}

