/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.BoatFilterImpl;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceSynthesis;
import fr.ifremer.suiviobsmer.ui.base.AbstractFilteredPage;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.data.ChartUtils;
import fr.ifremer.suiviobsmer.ui.data.ChartUtils.ChartType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.jfree.chart.JFreeChart;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

/**
 * Synthesis
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 262 $
 *
 * Mise a jour: $Date: 2010-01-23 18:59:23 +0100 (sam., 23 janv. 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/synthesis.css")
public class Synthesis extends AbstractFilteredPage implements SuiviObsmerPage {

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    @Inject
    private ServiceSynthesis serviceSynthesis;

    @Inject
    private Logger log;

    @SessionState
    @Property
    private User user;

    void setupRender() throws SuiviObsmerException {
        initSelectFilters(true, false);
        //getFilter().setUnfinishedRowsOnly(false);
    }

    /********************* DYNAMICAL GRAPH : DATASAMPLING *********************/

    @Persist
    private BoatFilter dataSamplingFilter;
    
    @InjectComponent
    private Zone filtersZone;

    @Persist
    private ChartType dataSamplingChartType;

    private boolean reset;

    @Override
    public BoatFilter getFilter() throws SuiviObsmerException {
        if (dataSamplingFilter == null) {
            dataSamplingFilter = new BoatFilterImpl();
            if (!user.getAdmin()) {
                dataSamplingFilter.setCompany(user.getCompany());
            }
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday(-12);
            if (log.isDebugEnabled()) {
                log.debug("Period : " + period);
            }
            dataSamplingFilter.setPeriod(period);
        }
        return dataSamplingFilter;
    }

    @Override
    protected boolean getAvailableDataForFiltersOnly() {
        return false;
    }

    public JFreeChart getDataSamplingChart() throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getDataSampling]");
        }        
        List<SortedMap<Date, Integer>> res = serviceSynthesis.getDataSampling(getFilter());
        Map<String, SortedMap<Date, Integer>> data = new HashMap<String, SortedMap<Date, Integer>>();
        data.put("Planifié", res.get(0));
        data.put("Réalisé", res.get(1));
        String title = BusinessUtils.getDataSamplingTitle(getFilter());
        return ChartUtils.createCategoryChart(title, "Nb marées", getDataSamplingChartType(), data);
    }

    public ChartType getDataSamplingChartType() {
        // Default type is BAR
        if (dataSamplingChartType == null) {
            dataSamplingChartType = ChartType.BAR;
        }
        if (log.isDebugEnabled()) {
            log.debug("ChartType : " + dataSamplingChartType);
        }
        return dataSamplingChartType;
    }
    
    void onActionFromSetDataSamplingChartBarType() {
        this.dataSamplingChartType = ChartType.BAR;
    }

    void onActionFromSetDataSamplingChartAreaType() {
        this.dataSamplingChartType = ChartType.AREA;
    }

    void onActionFromSetDataSamplingChartLineType() {
        this.dataSamplingChartType = ChartType.LINE;
    }

    void onSelectedFromReset() {
        reset = true;
    }

    Object onSuccessFromFiltersForm() {
        if (isEdited()) {
            return filtersZone.getBody();
        }
        if (reset) {
            dataSamplingFilter = null;
        }
        return this;
    }
        
}
