<#--
 #%L
 IsisFish
 
 $Id$
 $HeadURL$
 %%
 Copyright (C) 1999 - 2011 CodeLutin
 %%
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as
 published by the Free Software Foundation, either version 2 of the 
 License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public 
 License along with this program.  If not, see
 <http://www.gnu.org/licenses/gpl-2.0.html>.
 #L%
-->
#!/bin/csh

cd "${isishome}"

#source /usr/share/modules/init/csh
#module load java/1.6.0

<#assign commonCommand="${javapath} -Xmx2000M -jar isis-fish*.jar --option launch.ui false --option perform.vcsupdate false --option perform.migration false --option perform.cron false" />
<#if qsubmutiplejob>
	<#-- localsimulationid is short simulation id version -->
	<#assign localsimulationid='${simulationid}_$PBS_ARRAY_INDEX' />
	<#if simulationstandalonezip>
		<#assign localsimulationzip='${simulationzip?replace("\\\\Q${simulationid}\\\\E_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#else>
		<#assign localsimulationzip='${simulationzip}' />
	</#if>
	<#assign localsimulationresultzip='${simulationresultzip?replace("\\\\Q${simulationid}\\\\E_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#assign localsimulationprescript='${simulationprescript?replace("\\\\Q${simulationid}\\\\E_[0-9]+", "${simulationid}_\\\\$PBS_ARRAY_INDEX","ri")}' />
	<#assign localsimulationoutput='${isistemp}simulation-${simulationid}_$PBS_ARRAY_INDEX-output.txt' />
<#else>
	<#assign localsimulationid='${simulationid}' />
	<#assign localsimulationzip='${simulationzip}' />
	<#assign localsimulationresultzip='${simulationresultzip}' />
	<#assign localsimulationprescript='${simulationprescript}' />
	<#assign localsimulationoutput='${isistemp}simulation-${simulationid}-output.txt' />
</#if>
<#if simulationprescript?length &gt; 0>
${commonCommand} --simulateRemotellyWithPreScript "${localsimulationid}" "${localsimulationzip}" "${localsimulationresultzip}" "${localsimulationprescript}" >& "${localsimulationoutput}"
<#else>
${commonCommand} --simulateRemotelly "${localsimulationid}" "${localsimulationzip}" "${localsimulationresultzip}" >& "${localsimulationoutput}"
</#if>

rm -rf "$HOME/isis-database-3/simulations/${localsimulationid}"
