/*
 * #%L
 * IsisFish
 * 
 * $Id: Docable.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

/**
 * This is the contract to be realize by any class which wanted to have a @Doc support.
 *
 * @author chemit
 * @see Doc
 * @see DocHelper
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public interface Docable {

    /**
     * Class documentation (if any).
     * 
     * @return the @Doc of the class, or null if none
     */
    Doc getClassDoc();

    /**
     * Field documentation (if any).
     * 
     * @param fieldName name of the field to use
     * @return the @Doc of the field, or null if none
     */
    Doc getFieldDoc(String fieldName);

    /**
     * Class documentation (if any).
     * 
     * @return the description of the class, or null if none
     */
    String getDescription();
}
