/*
 * #%L
 * IsisFish
 * 
 * $Id: DocHelper.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import static org.nuiton.i18n.I18n._;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.lang.reflect.Field;

/**
 * Class containing usefull methods to obtain @Doc informations
 * for a class,field,method...
 *
 * @author chemit
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class DocHelper {

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(DocHelper.class);

    /**
     * @param klazz class to use
     * @return the @Doc associated with the class of null if klazz is null or
     *         there is no Doc for this klazz
     */
    public static Doc getClassDoc(Class<?> klazz) {
        return klazz == null ? null : klazz.getAnnotation(Doc.class);
    }

    /**
     * @param value object given
     * @return the @Doc associated to the class of the given object, or null if value is
     *         null or no doc found for his class
     *         
     * @deprecated as of 20090408 never used
     */
    public static Doc getClassDoc(Object value) {
        return value == null ? null : getClassDoc(value.getClass());
    }

    /**
     * @param f file to use
     * @return the @Doc associated to the field, or null
     *         if field is null of no @doc found
     * 
     * @deprecated as of 20090408 never used
     */
    public static Doc getFieldDoc(Field f) {
        return f == null ? null : f.getAnnotation(Doc.class);
    }

    /**
     * @param klazz     class to use
     * @param fieldName field name to use
     * @return the @Doc associated with e filed of the given class,
     *         or null if class is null, field does not exist, or no
     *         Doc for the field
     */
    public static Doc getFieldDoc(Class<?> klazz, String fieldName) {
        Field f = null;
        try {
            f = klazz == null ? null : klazz.getField(fieldName);
        } catch (NoSuchFieldException e) {
            // should never appear
            log.warn(_("isisfish.error.not.found.field.class", fieldName,
                            klazz));
            //throw new IsisFishRuntimeException(e);
        }
        return f == null ? null : f.getAnnotation(Doc.class);
    }

    /**
     * @param doc doc to use
     * @return the {@link Doc#value()} of the given @Doc
     * 
     * @deprecated as of 20090408 never used
     */
    public static String getValue(Doc doc) {
        return doc == null ? "" : doc.value();
    }

    /**
     * @param doc doc to use
     * @return the {@link Doc#author()}} of the given @Doc
     * 
     * @deprecated as of 20090408 never used
     */
    public static String getAuthor(Doc doc) {
        return doc == null ? "" : doc.author();
    }

    /**
     * @param doc doc to use
     * @return the {@link Doc#date()} of the given @Doc
     * 
     * @deprecated as of 20090408 never used
     */
    public static String getDate(Doc doc) {
        return doc == null ? "" : doc.date();
    }

    /**
     * @param doc doc to use
     * @return the {@link Doc#version()} of the given @Doc
     * 
     * @deprecated as of 20090408 never used
     */
    public static String getVersion(Doc doc) {
        return doc == null ? "" : doc.version();
    }
}
