/*
 * #%L
 * IsisFish
 * 
 * $Id: ConverterUtil.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;

/**
 * ConverterUtil.
 * 
 * Created: 25 sept. 06 19:37:16
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public class ConverterUtil {

    public static ConvertUtilsBean getConverter(TopiaContext context) {
        BeanUtilsBean result = BeanUtilsBean.getInstance();
        ConvertUtilsBean cub = result.getConvertUtils();

        // mise en place de converter de string vers des objet ...
        cub.register(new TopiaEntityConverter(context), TopiaEntity.class);
        cub.register(new DateConverter(), Date.class);
        cub.register(new MonthConverter(), Month.class);
        cub.register(new TimeUnitConverter(), TimeUnit.class);
        cub.register(new RangeOfValuesConverter(), RangeOfValues.class);
        
        // Not used since mexico file format use
        // Still used in sensivity analysis prescript
        cub.register(new MatrixConverter(), MatrixND.class);
        // dans les prescripts generé on a MatrixNDImpl.class
        // c'est tres étrange, mais ca ne fonctionne pas par MatrixND.class
        cub.register(new MatrixConverter(), MatrixNDImpl.class);

        // ... et inversement
        cub.register(new StringConverter(), String.class);

        return cub;
    }

}
