/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.util;

import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;
import org.nuiton.util.ResourceNotFoundException;

import freemarker.cache.URLTemplateLoader;

/**
 * Freemarker custom template loader.
 * Load template from classpath jars.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 1 déc. 2008 $
 * By : $Author: chatellier $
 */
public class ClasspathTemplateLoader extends URLTemplateLoader {

    /** log */
    private static Log log = LogFactory.getLog(ClasspathTemplateLoader.class);

    /*
     * @see freemarker.cache.URLTemplateLoader#getURL(java.lang.String)
     */
    @Override
    protected URL getURL(String name) {

        if (log.isDebugEnabled()) {
            log.debug("Loading url template " + name);
        }

        URL url = null;

        try {
            url = Resource.getURL(name);
        } catch (ResourceNotFoundException e) {
            // not big deal
            // freemarker ask for name_fr_FR, name_fr, name
            url = null;
        }

        return url;
    }

}
