/*
 * #%L
 * IsisFish
 * 
 * $Id: DateInterval.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.filter;

/** class that represent a date interval stored in long object */
public class DateInterval implements java.io.Serializable {
    long d0, d1;
    private static final long serialVersionUID = 219393521548480987L;

    public DateInterval(long d0, long d1) {
        this.d0 = d0;
        this.d1 = d1;
    }

    public long getD0() {
        return d0;
    }

    public long getD1() {
        return d1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DateInterval that = (DateInterval) o;

        return d0 == that.d0 && d1 == that.d1;
    }

    public int hashCode() {
        int result;
        result = (int) (d0 ^ (d0 >>> 32));
        result = 31 * result + (int) (d1 ^ (d1 >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " <" + d0 + " - " + d1 + ">";
    }
}
