/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.vcs;

import fr.ifremer.isisfish.ui.vcs.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.event.HyperlinkEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCSConfigUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.vcs.VCSConfigUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSemMb5nYY0pKVKRSCmCATrUooqmhLqOLhtcEpoWgj4wnh37J12PLPszLobkBASHBHqBQ5cgHuP3BHiyIkr/wNC/Ae82bXXXmu9Xmlz8Dpv3vfN972Zfc9P/kHT0kXPP8C+b7geV7RDjP3K8fH7zQfEVHtEmi51lHBR+DdVQIUGWrCiuFRoq1HX8HIPXq6KjiM44UPo7Tqal+qEEWkTohR6JkSYUpaPovC273huny0Sk8T283//Fh5bX/1SQMh3QNUGWNichBo4OFVHBWoptAo7dXGZYd4GGS7lbdC5pGNVhqW8gzvkM/QlmqmjooNdIFPohexWA44A7zsKzZX29yhmon1JoYst16Atl3QIPCWVLSptw6NG15TGh9WjquAt2r5/23ECeFGhmdI93GTkdYXOxVzKR6DZCNZ05lwEWCrtH5muYOwQc3JZobPalN/LH1rS6YsRat4mzHnXouBiFBJG+5DTEWS5ReEKcKhUHTcJg5rGYEEwvslchFBoPZZ8j/iqRgmz4oBlXcfBFjp6doQyytCB8yOmSAdTNg46HawmwJ6TxO0St+IpG46XmlhRwQ+IsoU1jmu2tK8LxN4YrUIQjedujaevcMFPOsKTwWkP0dzFFhW7nlKCa5YXI7IL48mOpK2TXokDVkJAXbQpH+dmYSgnoT4bQ8t3xCEcwKHtYjn2jFbD/OFUaAMxf1WbmA93hR8HPhsCD13axYq8R05qlI3dZS0pOUF9/6iu6P9fiq+dH+Wo2tAgiGZS6ExM8eAwrkXwc6Pwm4QTF77q9Z14bl/GmwkyCuJhhKgM7qtLoHAJC4sm5iZhFVOffdJ6KCu8FdDHEvqIbvuho5uu8BxoP672C3nQp41Bnx400qkGCPIgDFeqMWjpdyEUNvNeNCAIoj99/WP3h19/u9bv3Fuwx1IsZWjQQCd1XOEQV1G9xemwXXuKsvIBdrYbaE4SBlMqmEJrQwKOemEQAfxPa5ihYcYtLG2ATs/8/fsf65/+9RQq1NA8E9iqYZ1/G80pGypsC2b5zjs3AiWLj2bhc0VrUqhoE9q2YRCsXqecUU42sYLJ0fQU2fHB8NqQ4UjFn4+/Pdj47sLVvumpUNRI2sD49CeoGLIHg6o3gxIH04IjiWeJwaxJmj5T+rni9ObJB8Hn/SR3swTafH+aHPuefnwcCNbfGgHPmQw8pxS08hSO9YkcOmylMGzkZtjMzVDKUIkiwycC3im0fN3CCm82KbfgXdtJZryYgXGhOXhFU8S9nNveZAZoR13MvLTbkk3GFykMr+Y2ko3hm1wM8BuNcP3mBEK6yTRGbivZGL5P0XApN8Pl3C6yMaRpuJKlmYXDgaQpmcwzScnV3NWYzACXyxTM63CZQvNWbiuTGfSvd8HVa5J+nvbSZ5PyUW4GL8XMdu5yvJ37ZPMz3Mhdh93sdRijYS+3i/wMtdwMt4Dhf3hLWyTtEAAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton cancelAction;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JTextField email;
    protected javax.swing.JLabel emailLabel;
    protected javax.swing.JTextField firstname;
    protected javax.swing.JLabel firstnameLabel;
    protected javax.swing.JEditorPane helpEditor;
    protected javax.swing.JTextField lasstname;
    protected javax.swing.JLabel lasstnameLabel;
    protected javax.swing.JButton ok;
    protected javax.swing.JButton reset;
    protected javax.swing.JRadioButton serverAuthenticationMethodAnonymous;
    protected javax.swing.JLabel serverAuthenticationMethodLabel;
    protected javax.swing.JRadioButton serverAuthenticationMethodSsh;
    protected javax.swing.JTextField serverLogin;
    protected javax.swing.JLabel serverLoginLabel;
    protected javax.swing.JLabel serverLoginNoPassPhraseLabel;
    protected jaxx.runtime.swing.JAXXButtonGroup serverMethod;
    protected javax.swing.JCheckBox serverNoPassPhrase;
    protected javax.swing.JButton serverPrivateKeyChangeFile;
    protected javax.swing.JTextField serverPrivateKeyFile;
    protected javax.swing.JLabel serverPrivateKeyFileLabel;
    protected javax.swing.JButton serverPrivateKeyGenerate;
    private fr.ifremer.isisfish.ui.vcs.VCSConfigUI $JDialog0 = this;
    private javax.swing.JPanel $JPanel3;
    private javax.swing.JPanel $JPanel4;
    private javax.swing.JPanel $JPanel5;
    private javax.swing.JScrollPane $JScrollPane2;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($JDialog0, "serverNoPassPhrase.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($JDialog0, "serverPrivateKeyFileLabel.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($JDialog0, "serverPrivateKeyFile.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($JDialog0, "serverPrivateKeyChangeFile.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($JDialog0, "serverLoginLabel.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($JDialog0, "serverLogin.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($JDialog0, "serverLoginNoPassPhraseLabel.enabled");

    /* begin raw body code */
    public boolean cancel;
    protected boolean invalidFirstName;
    protected boolean invalidLastName;
    protected boolean invalidKey;
    protected boolean invalidEmail;
    protected boolean invalidLogin;
    private String oldEmail;
    private String oldServerLogin;
    private boolean oldUseSsh;
    private boolean oldNoPassPhrase;
    private String oldLastname;
    private String oldFirstname;
    private String oldServerPrivateKeyFile;
    
            
        protected void init() {
            String REGISTER_KEY_URL = "https://labs.libre-entreprise.org/account/editsshkeys.php";
            String DOC_URL = "http://isis-fish.labs.libre-entreprise.org/isis-fish/v3/user/addSshKey.html";
    
            StringBuilder builder = new StringBuilder();
            builder.append("<a href='").append(DOC_URL).append("'>");
            builder.append(_("isisfish.vcs.howto.save.key")).append("</a><br/>");
            builder.append("<a href='").append(REGISTER_KEY_URL).append("'>");
            builder.append(_("isisfish.vcs.save.key")).append("</a>");
    
            helpEditor.setEditorKit(new HTMLEditorKit());
            helpEditor.setText(builder.toString());
        }
    
        protected void saveOld() {
            this.oldFirstname=firstname.getText();
            this.oldLastname=lasstname.getText();
            this.oldEmail =email.getText();
            this.oldServerLogin=serverLogin.getText();
            this.oldServerPrivateKeyFile=serverPrivateKeyFile.getText();
            this.oldUseSsh=serverAuthenticationMethodSsh.isSelected();
            this.oldNoPassPhrase =serverNoPassPhrase.isSelected();
            doCheck();
        }
    
        protected void restoreOld() {
            firstname.setText(oldFirstname);
            lasstname.setText(oldLastname);
            email.setText(oldEmail);
            serverLogin.setText(oldServerLogin);
            serverPrivateKeyFile.setText(oldServerPrivateKeyFile);
            serverAuthenticationMethodSsh.setSelected(oldUseSsh);
            serverNoPassPhrase.setSelected(oldNoPassPhrase);
            doCheck();
        }
        public boolean isConfigValid() {
            return check(serverAuthenticationMethodSsh.isSelected());
        }
    
        protected boolean check(boolean ssh) {
            jaxx.runtime.Util.assignment(invalidFirstName=firstname.isVisible() && firstname.getText().isEmpty(), "invalidFirstName", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
            jaxx.runtime.Util.assignment(invalidLastName=lasstname.isVisible() && lasstname.getText().isEmpty(), "invalidLastName", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
            jaxx.runtime.Util.assignment(invalidEmail=email.isVisible() && email.getText().isEmpty(), "invalidEmail", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
            if (ssh) {
                String file = serverPrivateKeyFile.getText();
                jaxx.runtime.Util.assignment(invalidKey=file.isEmpty() || !new java.io.File(file).exists(), "invalidKey", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
                jaxx.runtime.Util.assignment(invalidLogin=serverLogin.getText().isEmpty(), "invalidLogin", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
            } else {
                jaxx.runtime.Util.assignment(invalidLogin=false, "invalidLogin", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
                jaxx.runtime.Util.assignment(invalidKey=false, "invalidKey", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);
            }
            return !(invalidEmail||invalidFirstName||invalidLastName||invalidLogin||invalidKey);
        }
    
        protected void doCheck() {
            boolean ssh = serverAuthenticationMethodSsh.isSelected();
            ok.setEnabled(check(ssh));
            if (ssh) {
                serverPrivateKeyGenerate.setEnabled(!invalidLogin);
            } else {
                serverPrivateKeyGenerate.setEnabled(false);
            }        
            setColor(invalidFirstName, firstnameLabel);
            setColor(invalidLastName, lasstnameLabel);
            setColor(invalidEmail, emailLabel);
            setColor(invalidLogin, serverLoginLabel);
            setColor(invalidKey, serverPrivateKeyFileLabel);
        }
    
        protected void setColor(boolean invalid, JComponent component) {
            component.setForeground(invalid ? Color.red: Color.black);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public VCSConfigUI() {
        $initialize();
    }

    public VCSConfigUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("serverLoginLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u0"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverLoginLabel.enabled"));
            }
        } else if ("serverLogin.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u1"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverLogin.enabled"));
            }
        } else if ("serverLoginNoPassPhraseLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u2"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverLoginNoPassPhraseLabel.enabled"));
            }
        } else if ("serverNoPassPhrase.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u3"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverNoPassPhrase.enabled"));
            }
        } else if ("serverPrivateKeyFileLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u4"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverPrivateKeyFileLabel.enabled"));
            }
        } else if ("serverPrivateKeyFile.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u5"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverPrivateKeyFile.enabled"));
            }
        } else if ("serverPrivateKeyChangeFile.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                $bindingSources.put("serverAuthenticationMethodSsh.getModel()", serverAuthenticationMethodSsh.getModel());
        serverAuthenticationMethodSsh.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u6"));
        serverAuthenticationMethodSsh.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "serverPrivateKeyChangeFile.enabled"));
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("serverLoginLabel.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverLoginLabel.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverLogin.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverLogin.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverLoginNoPassPhraseLabel.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverLoginNoPassPhraseLabel.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverNoPassPhrase.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverNoPassPhrase.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverPrivateKeyFileLabel.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverPrivateKeyFileLabel.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverPrivateKeyFile.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverPrivateKeyFile.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            } else if ("serverPrivateKeyChangeFile.enabled".equals($dest)) {
            if (serverAuthenticationMethodSsh != null) {
                serverPrivateKeyChangeFile.setEnabled((serverAuthenticationMethodSsh.isSelected()));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("serverLoginLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u0"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverLoginLabel.enabled"));
            }
        } else if ("serverLogin.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u1"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverLogin.enabled"));
            }
        } else if ("serverLoginNoPassPhraseLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u2"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverLoginNoPassPhraseLabel.enabled"));
            }
        } else if ("serverNoPassPhrase.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u3"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverNoPassPhrase.enabled"));
            }
        } else if ("serverPrivateKeyFileLabel.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u4"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverPrivateKeyFileLabel.enabled"));
            }
        } else if ("serverPrivateKeyFile.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u5"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverPrivateKeyFile.enabled"));
            }
        } else if ("serverPrivateKeyChangeFile.enabled".equals($binding)) {
            if (serverAuthenticationMethodSsh != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("serverAuthenticationMethodSsh.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $JDialog0, "$pr$u6"));
        serverAuthenticationMethodSsh.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "serverPrivateKeyChangeFile.enabled"));
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelAction(java.awt.event.ActionEvent event) {
        jaxx.runtime.Util.assignment(cancel = true, "cancel", fr.ifremer.isisfish.ui.vcs.VCSConfigUI.this);dispose();
    }

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        restoreOld();
    }

    public void doActionPerformed__on__serverAuthenticationMethodAnonymous(java.awt.event.ActionEvent event) {
        doCheck();
    }

    public void doActionPerformed__on__serverAuthenticationMethodSsh(java.awt.event.ActionEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__email(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__firstname(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__lasstname(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__serverLogin(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__serverNoPassPhrase(java.awt.event.KeyEvent event) {
        doCheck();
    }

    public void doKeyReleased__on__serverPrivateKeyFile(java.awt.event.KeyEvent event) {
        doCheck();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getCancelAction() {
        return cancelAction;
    }

    public javax.swing.JTextField getEmail() {
        return email;
    }

    public javax.swing.JLabel getEmailLabel() {
        return emailLabel;
    }

    public javax.swing.JTextField getFirstname() {
        return firstname;
    }

    public javax.swing.JLabel getFirstnameLabel() {
        return firstnameLabel;
    }

    public javax.swing.JEditorPane getHelpEditor() {
        return helpEditor;
    }

    public javax.swing.JTextField getLasstname() {
        return lasstname;
    }

    public javax.swing.JLabel getLasstnameLabel() {
        return lasstnameLabel;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    public javax.swing.JRadioButton getServerAuthenticationMethodAnonymous() {
        return serverAuthenticationMethodAnonymous;
    }

    public javax.swing.JLabel getServerAuthenticationMethodLabel() {
        return serverAuthenticationMethodLabel;
    }

    public javax.swing.JRadioButton getServerAuthenticationMethodSsh() {
        return serverAuthenticationMethodSsh;
    }

    public javax.swing.JTextField getServerLogin() {
        return serverLogin;
    }

    public javax.swing.JLabel getServerLoginLabel() {
        return serverLoginLabel;
    }

    public javax.swing.JLabel getServerLoginNoPassPhraseLabel() {
        return serverLoginNoPassPhraseLabel;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getServerMethod() {
        return serverMethod;
    }

    public javax.swing.JCheckBox getServerNoPassPhrase() {
        return serverNoPassPhrase;
    }

    public javax.swing.JButton getServerPrivateKeyChangeFile() {
        return serverPrivateKeyChangeFile;
    }

    public javax.swing.JTextField getServerPrivateKeyFile() {
        return serverPrivateKeyFile;
    }

    public javax.swing.JLabel getServerPrivateKeyFileLabel() {
        return serverPrivateKeyFileLabel;
    }

    public javax.swing.JButton getServerPrivateKeyGenerate() {
        return serverPrivateKeyGenerate;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(javax.swing.event.ChangeEvent event) {
        $DataSource7.propertyChange(null);
    }

    public void $pr$u1(javax.swing.event.ChangeEvent event) {
        $DataSource8.propertyChange(null);
    }

    public void $pr$u2(javax.swing.event.ChangeEvent event) {
        $DataSource9.propertyChange(null);
    }

    public void $pr$u3(javax.swing.event.ChangeEvent event) {
        $DataSource10.propertyChange(null);
    }

    public void $pr$u4(javax.swing.event.ChangeEvent event) {
        $DataSource11.propertyChange(null);
    }

    public void $pr$u5(javax.swing.event.ChangeEvent event) {
        $DataSource12.propertyChange(null);
    }

    public void $pr$u6(javax.swing.event.ChangeEvent event) {
        $DataSource14.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.vcs.VCSConfigUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table1);
        
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(firstnameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(firstname, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(lasstnameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(lasstname, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(emailLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(email, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverAuthenticationMethodLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel3, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverLoginLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverLogin, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverLoginNoPassPhraseLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverNoPassPhrase, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPrivateKeyFileLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(serverPrivateKeyFile, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel4, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel5, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane2.getViewport().add(helpEditor);
        
        $JPanel3.add(serverAuthenticationMethodAnonymous);
        $JPanel3.add(serverAuthenticationMethodSsh);
        
        addChildrenToServerAuthenticationMethodAnonymous();
        addChildrenToServerAuthenticationMethodSsh();
        $JPanel4.add(serverPrivateKeyChangeFile);
        $JPanel4.add(serverPrivateKeyGenerate);
        
        $JPanel5.add(ok);
        $JPanel5.add(reset);
        $JPanel5.add(cancelAction);
        
        applyDataBinding("serverLoginLabel.enabled");
        applyDataBinding("serverLogin.enabled");
        applyDataBinding("serverLoginNoPassPhraseLabel.enabled");
        applyDataBinding("serverNoPassPhrase.enabled");
        applyDataBinding("serverPrivateKeyFileLabel.enabled");
        applyDataBinding("serverPrivateKeyFile.enabled");
        applyDataBinding("serverPrivateKeyChangeFile.enabled");
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JScrollPane2 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane2", $JScrollPane2);
        $JScrollPane2.setName("$JScrollPane2");
        jaxx.runtime.Util.setComponentHeight($JScrollPane2,60);
        
        
        createHelpEditor();
        createFirstnameLabel();
        createFirstname();
        createLasstnameLabel();
        createLasstname();
        createEmailLabel();
        createEmail();
        createServerAuthenticationMethodLabel();
        
        $JPanel3 = new javax.swing.JPanel();
        $objectMap.put("$JPanel3", $JPanel3);
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout((new GridLayout(0, 2, 2, 2)));
        
        createServerAuthenticationMethodAnonymous();
        createServerAuthenticationMethodSsh();
        createServerLoginLabel();
        createServerLogin();
        createServerLoginNoPassPhraseLabel();
        createServerNoPassPhrase();
        createServerPrivateKeyFileLabel();
        createServerPrivateKeyFile();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout((new GridLayout(0, 2, 2, 2)));
        
        createServerPrivateKeyChangeFile();
        createServerPrivateKeyGenerate();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout((new GridLayout(0, 3, 2, 2)));
        
        createOk();
        createReset();
        createCancelAction();
        createServerMethod();
        $JDialog0.setName("$JDialog0");
        
        
        init();helpEditor.addHyperlinkListener(new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent he) {
                    if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
        
                        try {
                            URL u = he.getURL();
                            Desktop.getDesktop().browse(u.toURI());
                        } catch (Exception e) {
                            if (log.isWarnEnabled()) {
                                log.warn("Cannot open link (maybe defaut browser in not configured ?)");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Error while opening link", e);
                            }
                        }
                    }
                }
            });
        $completeSetup();
    }

    protected void addChildrenToServerAuthenticationMethodAnonymous() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = serverMethod; serverAuthenticationMethodAnonymous.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(serverAuthenticationMethodAnonymous); }
    }

    protected void addChildrenToServerAuthenticationMethodSsh() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = serverMethod; serverAuthenticationMethodSsh.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(serverAuthenticationMethodSsh); }
    }

    protected void createCancelAction() {
        cancelAction = new javax.swing.JButton();
        $objectMap.put("cancelAction", cancelAction);
        cancelAction.setName("cancelAction");
        cancelAction.setText(_("isisfish.common.cancel"));
        cancelAction.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancelAction"));
    }

    protected void createEmail() {
        email = new javax.swing.JTextField();
        $objectMap.put("email", email);
        email.setName("email");
        email.setColumns(15);
        email.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__email"));
    }

    protected void createEmailLabel() {
        emailLabel = new javax.swing.JLabel();
        $objectMap.put("emailLabel", emailLabel);
        emailLabel.setName("emailLabel");
        emailLabel.setText(_("isisfish.launch.email"));
    }

    protected void createFirstname() {
        firstname = new javax.swing.JTextField();
        $objectMap.put("firstname", firstname);
        firstname.setName("firstname");
        firstname.setColumns(15);
        firstname.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__firstname"));
    }

    protected void createFirstnameLabel() {
        firstnameLabel = new javax.swing.JLabel();
        $objectMap.put("firstnameLabel", firstnameLabel);
        firstnameLabel.setName("firstnameLabel");
        firstnameLabel.setText(_("isisfish.launch.firstname"));
    }

    protected void createHelpEditor() {
        helpEditor = new javax.swing.JEditorPane();
        $objectMap.put("helpEditor", helpEditor);
        helpEditor.setName("helpEditor");
        helpEditor.setEditable(false);
    }

    protected void createLasstname() {
        lasstname = new javax.swing.JTextField();
        $objectMap.put("lasstname", lasstname);
        lasstname.setName("lasstname");
        lasstname.setColumns(15);
        lasstname.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__lasstname"));
    }

    protected void createLasstnameLabel() {
        lasstnameLabel = new javax.swing.JLabel();
        $objectMap.put("lasstnameLabel", lasstnameLabel);
        lasstnameLabel.setName("lasstnameLabel");
        lasstnameLabel.setText(_("isisfish.launch.lasstname"));
    }

    protected void createOk() {
        ok = new javax.swing.JButton();
        $objectMap.put("ok", ok);
        ok.setName("ok");
        ok.setEnabled(false);
        ok.setText(_("isisfish.common.apply"));
    }

    protected void createReset() {
        reset = new javax.swing.JButton();
        $objectMap.put("reset", reset);
        reset.setName("reset");
        reset.setText(_("isisfish.common.reset"));
        reset.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__reset"));
    }

    protected void createServerAuthenticationMethodAnonymous() {
        serverAuthenticationMethodAnonymous = new javax.swing.JRadioButton();
        $objectMap.put("serverAuthenticationMethodAnonymous", serverAuthenticationMethodAnonymous);
        serverAuthenticationMethodAnonymous.setName("serverAuthenticationMethodAnonymous");
        serverAuthenticationMethodAnonymous.setText(_("isisfish.launch.anonymous"));
        { serverAuthenticationMethodAnonymous.putClientProperty("$value", "anonymous");  Object $buttonGroup = serverAuthenticationMethodAnonymous.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        serverAuthenticationMethodAnonymous.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__serverAuthenticationMethodAnonymous"));
    }

    protected void createServerAuthenticationMethodLabel() {
        serverAuthenticationMethodLabel = new javax.swing.JLabel();
        $objectMap.put("serverAuthenticationMethodLabel", serverAuthenticationMethodLabel);
        serverAuthenticationMethodLabel.setName("serverAuthenticationMethodLabel");
        serverAuthenticationMethodLabel.setText(_("isisfish.launch.server.authenticationMethod"));
    }

    protected void createServerAuthenticationMethodSsh() {
        serverAuthenticationMethodSsh = new javax.swing.JRadioButton();
        $objectMap.put("serverAuthenticationMethodSsh", serverAuthenticationMethodSsh);
        serverAuthenticationMethodSsh.setName("serverAuthenticationMethodSsh");
        serverAuthenticationMethodSsh.setText(_("isisfish.launch.ssh"));
        { serverAuthenticationMethodSsh.putClientProperty("$value", "ssh");  Object $buttonGroup = serverAuthenticationMethodSsh.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        serverAuthenticationMethodSsh.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__serverAuthenticationMethodSsh"));
    }

    protected void createServerLogin() {
        serverLogin = new javax.swing.JTextField();
        $objectMap.put("serverLogin", serverLogin);
        serverLogin.setName("serverLogin");
        serverLogin.setColumns(15);
        serverLogin.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__serverLogin"));
    }

    protected void createServerLoginLabel() {
        serverLoginLabel = new javax.swing.JLabel();
        $objectMap.put("serverLoginLabel", serverLoginLabel);
        serverLoginLabel.setName("serverLoginLabel");
        serverLoginLabel.setText(_("isisfish.launch.server.login"));
    }

    protected void createServerLoginNoPassPhraseLabel() {
        serverLoginNoPassPhraseLabel = new javax.swing.JLabel();
        $objectMap.put("serverLoginNoPassPhraseLabel", serverLoginNoPassPhraseLabel);
        serverLoginNoPassPhraseLabel.setName("serverLoginNoPassPhraseLabel");
        serverLoginNoPassPhraseLabel.setText(_("isisfish.launch.server.ssh.no.passphrase"));
    }

    protected void createServerMethod() {
        serverMethod = new jaxx.runtime.swing.JAXXButtonGroup();
        $objectMap.put("serverMethod", serverMethod);
    }

    protected void createServerNoPassPhrase() {
        serverNoPassPhrase = new javax.swing.JCheckBox();
        $objectMap.put("serverNoPassPhrase", serverNoPassPhrase);
        serverNoPassPhrase.setName("serverNoPassPhrase");
        serverNoPassPhrase.setSelected(true);
        serverNoPassPhrase.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__serverNoPassPhrase"));
    }

    protected void createServerPrivateKeyChangeFile() {
        serverPrivateKeyChangeFile = new javax.swing.JButton();
        $objectMap.put("serverPrivateKeyChangeFile", serverPrivateKeyChangeFile);
        serverPrivateKeyChangeFile.setName("serverPrivateKeyChangeFile");
        serverPrivateKeyChangeFile.setText(_("isisfish.launch.server.ssh.key.change"));
    }

    protected void createServerPrivateKeyFile() {
        serverPrivateKeyFile = new javax.swing.JTextField();
        $objectMap.put("serverPrivateKeyFile", serverPrivateKeyFile);
        serverPrivateKeyFile.setName("serverPrivateKeyFile");
        serverPrivateKeyFile.setColumns(15);
        serverPrivateKeyFile.setColumns(28);
        if (serverPrivateKeyFile.getFont() != null) serverPrivateKeyFile.setFont(serverPrivateKeyFile.getFont().deriveFont((float) 12));
        jaxx.runtime.Util.setComponentHeight(serverPrivateKeyFile,25);
        
        serverPrivateKeyFile.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__serverPrivateKeyFile"));
    }

    protected void createServerPrivateKeyFileLabel() {
        serverPrivateKeyFileLabel = new javax.swing.JLabel();
        $objectMap.put("serverPrivateKeyFileLabel", serverPrivateKeyFileLabel);
        serverPrivateKeyFileLabel.setName("serverPrivateKeyFileLabel");
        serverPrivateKeyFileLabel.setText(_("isisfish.launch.server.ssh.privateKeyFile"));
    }

    protected void createServerPrivateKeyGenerate() {
        serverPrivateKeyGenerate = new javax.swing.JButton();
        $objectMap.put("serverPrivateKeyGenerate", serverPrivateKeyGenerate);
        serverPrivateKeyGenerate.setName("serverPrivateKeyGenerate");
        serverPrivateKeyGenerate.setText(_("isisfish.launch.server.ssh.key.generate"));
    }

}
