/*
 * #%L
 * IsisFish
 * 
 * $Id: ErrorHelper.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

/**
 * Error helper.
 * 
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author$
 */
public class ErrorHelper {

    /**
     * Display a user friendly error frame.
     * 
     * @param parent parent component
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(Component parent, String message,
            Throwable cause) {

        ErrorInfo info = new ErrorInfo(_("isisfish.error.errorpane.title"),
                _("isisfish.error.errorpane.htmlmessage", message), null, null,
                cause, null, null);
        JXErrorPane.showDialog(parent, info);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     */
    public static void showErrorDialog(String message) {
        showErrorDialog(message, null);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(String message, Throwable cause) {
        showErrorDialog(null, message, cause);
    }
}
