/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.simulator.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.JAXXInitialContext;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import javax.swing.ToolTipManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimulUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.simulator.SimulUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUv2/TQBi9hCZNm/5I29BKCKTyQwIGHJiQaFVoC1VTJVA1VKrIwiW+NFc59nF3Tt0FIbEi1ImBBdgZ2RFiZGLlf0CI/4Dvzo5jJ5FciQy289177973nf0+/0YZwdHlI+x5BndtSTvE2Fk/OHjSOCJN+ZCIJqdMOhz5v1Qapesob4Z1IdHVekXRSwG9tOl0mGMTO8JeqaBJIU8sItqESInO+4ymEKVaWF7xmMt7aqGZUWof//5Jn5qvPqUR8hi4mocWlpNY/Q7GKihNTYnmYacuLlnYPgQbnNqH4HNa1TYtLMRj3CEv0Es0XkFZhjmISXTl7K1qDc33mES5azu72CbWbYlutLhBW5x0CNwFFS0q2oZLDUE7roVBwqipp/0yY5qflWhKr1WJ7W5gLlFRefQMcQyWjZ2grKATIWMiZEg0NwRXoKkQmxW0hrsEjmUIWJako1CzITgnaBma5lL9L8bX/E2f4ga8FUsxLag1iKkmELeZg8HijtgvS3QzcSy7AVZxl0KJPOOkpoevVG4lq/TgQ0pZQWxt5XryCWlknJ4jnprL2Xp5FGDjEjOcCNeSm22HNokSKiUK7cUYcbkCNrvYbqrB96Z8J1FwfYAzOO2gDCcq0YXYR+efNSyU7ZbTf3lnIgcEi6pqsMg7o0c5vJDvjXN4aS4+pmHAwmDjEQhHC9o1hI/RD59+OqTqKMNdKMP86v2c2oOSn1BBVQvo6ofX77vvvny914ujMdhjOgaJpCfEA+MOI1xStcWsn0GupFapitlKXQ3EgujV0VqMGKgFZTAB+vqbNhTN2MaiDdTM+K9v3xef/zyH0lto0nKwuYUVvowmZBsG1nYs02P3H2gnU8c5uBaUJ3jvLXziuJBuM6smlni5QW0TTnLNg2aLkWZDBz9O31Qvvr10t9dwyjc0AOs3nXmGstS2qE108gahOjJp80wQ13T64TkqTlPqPsmC817T141RnY1J4kFf86v+7stYQsw3XEmgN0Xa0ubV07bWLCRqqnJFXaqjFRb+W2ERFP4BE1xv6ZcHAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI advancedParamsUI;
    protected jaxx.runtime.swing.TabInfo advancedParamsUITab;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected fr.ifremer.isisfish.ui.simulator.ExportUI exportUI;
    protected jaxx.runtime.swing.TabInfo exportUITab;
    protected fr.ifremer.isisfish.ui.simulator.ParamsUI paramsUI;
    protected jaxx.runtime.swing.TabInfo paramsUITab;
    protected fr.ifremer.isisfish.ui.simulator.PreScriptsUI preScriptUI;
    protected jaxx.runtime.swing.TabInfo preScriptUITab;
    protected fr.ifremer.isisfish.ui.simulator.ResultChoiceUI resultChoiceUI;
    protected jaxx.runtime.swing.TabInfo resultChoiceUITab;
    protected fr.ifremer.isisfish.ui.simulator.SensUI sensUI;
    protected jaxx.runtime.swing.TabInfo sensUITab;
    protected javax.swing.JMenuItem siImport;
    protected javax.swing.JMenuItem siSave;
    protected javax.swing.JMenu simulMenu;
    protected javax.swing.JMenuBar simulMenuBar;
    protected javax.swing.JTabbedPane simulTabs;
    private fr.ifremer.isisfish.ui.simulator.SimulUI $JPanel0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */    
    
            public  SimulUI(SimulAction action) {         
                setContextValue(action);
            $initialize();
    }
            protected void enablePreSimul(boolean selected) {
                simulTabs.setEnabledAt(1, selected);
            }
            protected void enableAnalysePlan(boolean selected) {
                simulTabs.setEnabledAt(2, selected);
            }
            protected void selTab(int i) {
                simulTabs.setSelectedIndex(i);
            }
            public void refresh() {
                paramsUI.refresh();
                preScriptUI.refresh();
                sensUI.refresh();
                exportUI.refresh();
                resultChoiceUI.refresh();
                advancedParamsUI.refresh();
            }
            // TODO duplicated code (simulUI, Params UI, SensitivityUI)
            protected void importSimulation() {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(null);
    
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    //This is where a real application would open the file.
                    getContextValue(SimulAction.class).importSimulation(file);
                    refresh();
                }
            }
            // TODO duplicated code (simulUI, Params UI, SensitivityUI)
            protected void saveSimulation() {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);
    
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    //This is where a real application would open the file.
                    getContextValue(SimulAction.class).saveSimulation(file);
                }
            }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SimulUI() {
        $initialize();
    }

    public SimulUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__siImport(java.awt.event.ActionEvent event) {
        importSimulation();
    }

    public void doActionPerformed__on__siSave(java.awt.event.ActionEvent event) {
        saveSimulation();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public jaxx.runtime.swing.TabInfo getAdvancedParamsUITab() {
        return advancedParamsUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.ExportUI getExportUI() {
        return exportUI;
    }

    public jaxx.runtime.swing.TabInfo getExportUITab() {
        return exportUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.ParamsUI getParamsUI() {
        return paramsUI;
    }

    public jaxx.runtime.swing.TabInfo getParamsUITab() {
        return paramsUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.PreScriptsUI getPreScriptUI() {
        return preScriptUI;
    }

    public jaxx.runtime.swing.TabInfo getPreScriptUITab() {
        return preScriptUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public jaxx.runtime.swing.TabInfo getResultChoiceUITab() {
        return resultChoiceUITab;
    }

    public fr.ifremer.isisfish.ui.simulator.SensUI getSensUI() {
        return sensUI;
    }

    public jaxx.runtime.swing.TabInfo getSensUITab() {
        return sensUITab;
    }

    public javax.swing.JMenuItem getSiImport() {
        return siImport;
    }

    public javax.swing.JMenuItem getSiSave() {
        return siSave;
    }

    public javax.swing.JMenu getSimulMenu() {
        return simulMenu;
    }

    public javax.swing.JMenuBar getSimulMenuBar() {
        return simulMenuBar;
    }

    public javax.swing.JTabbedPane getSimulTabs() {
        return simulTabs;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.simulator.SimulUI get$JPanel0() {
        return $JPanel0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(simulMenuBar, BorderLayout.NORTH);
        $JPanel0.add(simulTabs, BorderLayout.CENTER);
        
        addChildrenToSimulMenuBar();
        addChildrenToSimulMenu();
        addChildrenToSimulTabs();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createSimulMenuBar();
        createSimulMenu();
        createSiSave();
        createSiImport();
        createSimulTabs();
        createParamsUI();
        createPreScriptUI();
        createSensUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        createParamsUITab();
        createPreScriptUITab();
        createSensUITab();
        createExportUITab();
        createResultChoiceUITab();
        createAdvancedParamsUITab();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        $completeSetup();
    }

    protected void addChildrenToSimulMenu() {
        if (!allComponentsCreated) {
            return;
        }
        simulMenu.add(siSave);
        simulMenu.add(siImport);
    }

    protected void addChildrenToSimulMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        simulMenuBar.add(simulMenu);
    }

    protected void addChildrenToSimulTabs() {
        if (!allComponentsCreated) {
            return;
        }
        simulTabs.add(paramsUI);
        simulTabs.add(preScriptUI);
        simulTabs.add(sensUI);
        simulTabs.add(exportUI);
        simulTabs.add(resultChoiceUI);
        simulTabs.add(advancedParamsUI);
        paramsUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 0));
        simulTabs.setTitleAt(0, _("isisfish.params.title"));
        preScriptUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 1));
        simulTabs.setTitleAt(1, _("isisfish.preScript.title"));
        simulTabs.setEnabledAt(1, false);
        sensUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 2));
        simulTabs.setTitleAt(2, _("isisfish.sens.title"));
        simulTabs.setEnabledAt(2, false);
        exportUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 3));
        simulTabs.setTitleAt(3, _("isisfish.export.title"));
        resultChoiceUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 4));
        simulTabs.setTitleAt(4, _("isisfish.resultChoice.title"));
        advancedParamsUITab.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(simulTabs, 5));
        simulTabs.setTitleAt(5, _("isisfish.advancedParameters.title"));
    }

    protected void createAdvancedParamsUI() {
        advancedParamsUI =  new fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI(this);
        $objectMap.put("advancedParamsUI", advancedParamsUI);
        advancedParamsUI.removeDataBinding("$Table0.name");
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    protected void createAdvancedParamsUITab() {
        advancedParamsUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("advancedParamsUITab", advancedParamsUITab);
        advancedParamsUITab.setTitle(_("isisfish.advancedParameters.title"));
    }

    protected void createExportUI() {
        exportUI =  new fr.ifremer.isisfish.ui.simulator.ExportUI(this);
        $objectMap.put("exportUI", exportUI);
        exportUI.removeDataBinding("$Table0.name");
        
        exportUI.setName("exportUI");
    }

    protected void createExportUITab() {
        exportUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("exportUITab", exportUITab);
        exportUITab.setTitle(_("isisfish.export.title"));
    }

    protected void createParamsUI() {
        paramsUI =  new fr.ifremer.isisfish.ui.simulator.ParamsUI(this);
        $objectMap.put("paramsUI", paramsUI);
        paramsUI.removeDataBinding("$Table0.name");
        
        paramsUI.setName("paramsUI");
    }

    protected void createParamsUITab() {
        paramsUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("paramsUITab", paramsUITab);
        paramsUITab.setTitle(_("isisfish.params.title"));
    }

    protected void createPreScriptUI() {
        preScriptUI =  new fr.ifremer.isisfish.ui.simulator.PreScriptsUI(this);
        $objectMap.put("preScriptUI", preScriptUI);
        preScriptUI.removeDataBinding("$JPanel0.name");
        
        preScriptUI.setName("preScriptUI");
    }

    protected void createPreScriptUITab() {
        preScriptUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("preScriptUITab", preScriptUITab);
        preScriptUITab.setEnabled(false);
        preScriptUITab.setTitle(_("isisfish.preScript.title"));
    }

    protected void createResultChoiceUI() {
        resultChoiceUI =  new fr.ifremer.isisfish.ui.simulator.ResultChoiceUI(this);
        $objectMap.put("resultChoiceUI", resultChoiceUI);
        resultChoiceUI.removeDataBinding("$JPanel0.name");
        
        resultChoiceUI.setName("resultChoiceUI");
    }

    protected void createResultChoiceUITab() {
        resultChoiceUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("resultChoiceUITab", resultChoiceUITab);
        resultChoiceUITab.setTitle(_("isisfish.resultChoice.title"));
    }

    protected void createSensUI() {
        sensUI =  new fr.ifremer.isisfish.ui.simulator.SensUI(this);
        $objectMap.put("sensUI", sensUI);
        sensUI.removeDataBinding("$Table0.name");
        
        sensUI.setName("sensUI");
    }

    protected void createSensUITab() {
        sensUITab = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("sensUITab", sensUITab);
        sensUITab.setEnabled(false);
        sensUITab.setTitle(_("isisfish.sens.title"));
    }

    protected void createSiImport() {
        siImport = new javax.swing.JMenuItem();
        $objectMap.put("siImport", siImport);
        siImport.setName("siImport");
        siImport.setText(_("isisfish.simulation.menu.import"));
        siImport.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__siImport"));
    }

    protected void createSiSave() {
        siSave = new javax.swing.JMenuItem();
        $objectMap.put("siSave", siSave);
        siSave.setName("siSave");
        siSave.setText(_("isisfish.simulation.menu.save"));
        siSave.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__siSave"));
    }

    protected void createSimulMenu() {
        simulMenu = new javax.swing.JMenu();
        $objectMap.put("simulMenu", simulMenu);
        simulMenu.setName("simulMenu");
        simulMenu.setText(_("isisfish.simulation.menu.simulation"));
    }

    protected void createSimulMenuBar() {
        simulMenuBar = new javax.swing.JMenuBar();
        $objectMap.put("simulMenuBar", simulMenuBar);
        simulMenuBar.setName("simulMenuBar");
    }

    protected void createSimulTabs() {
        simulTabs = new javax.swing.JTabbedPane();
        $objectMap.put("simulTabs", simulTabs);
        simulTabs.setName("simulTabs");
    }

}
