/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.simulator.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaContext;
import java.text.ParseException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import fr.ifremer.isisfish.ui.Common;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.models.rule.RuleComboModel;
import fr.ifremer.isisfish.ui.models.rule.RuleComboRenderer;
import fr.ifremer.isisfish.ui.models.rule.RuleListModel;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersTableModel;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParamsUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.simulator.ParamsUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "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";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton buttonSimulParamsMesuresAdd;
    protected javax.swing.JButton buttonSimulParamsMesuresClear;
    protected javax.swing.JButton buttonSimulParamsMesuresRemove;
    protected javax.swing.JButton buttonSimulParamsSelectClearFilter;
    protected javax.swing.JButton buttonSimulParamsSelectFilter;
    protected javax.swing.JButton buttonSimulParamsSimulate;
    protected jaxx.runtime.swing.JAXXComboBox comboSelLauncher;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JTextArea fieldSimulParamsDesc;
    protected jaxx.runtime.swing.JAXXComboBox fieldSimulParamsMesuresSelect;
    protected javax.swing.JTextField fieldSimulParamsName;
    protected javax.swing.JTextField fieldSimulParamsNbAnnees;
    protected jaxx.runtime.swing.JAXXComboBox fieldSimulParamsRegion;
    protected jaxx.runtime.swing.JAXXComboBox fieldSimulParamsSelect;
    protected javax.swing.JCheckBox fieldSimulUseAnalysePlan;
    protected javax.swing.JCheckBox fieldUseSimulPreScripts;
    protected javax.swing.JLabel lblLauncher;
    protected javax.swing.JLabel lblName;
    protected jaxx.runtime.swing.JAXXList listSimulParamsMesuresList;
    protected jaxx.runtime.swing.JAXXList listSimulParamsPopulations;
    protected jaxx.runtime.swing.JAXXList listSimulParamsStrategies;
    protected javax.swing.JTabbedPane parametersTabbedPane;
    protected javax.swing.JButton saveSimul;
    protected java.lang.Boolean sensitivity;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor simulParamsNumbers;
    protected javax.swing.JTable simulParamsRules;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JLabel $JLabel17;
    private javax.swing.JLabel $JLabel20;
    private javax.swing.JLabel $JLabel23;
    private javax.swing.JLabel $JLabel26;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JPanel $JPanel11;
    private javax.swing.JPanel $JPanel15;
    private javax.swing.JPanel $JPanel27;
    private javax.swing.JScrollPane $JScrollPane12;
    private javax.swing.JScrollPane $JScrollPane18;
    private javax.swing.JScrollPane $JScrollPane21;
    private javax.swing.JScrollPane $JScrollPane24;
    private javax.swing.JScrollPane $JScrollPane28;
    private javax.swing.JSeparator $JSeparator4;
    private jaxx.runtime.swing.TabInfo $TabInfo31;
    private jaxx.runtime.swing.TabInfo $TabInfo32;
    private fr.ifremer.isisfish.ui.simulator.ParamsUI $Table0 = this;
    private jaxx.runtime.swing.Table $Table13;
    private jaxx.runtime.swing.Table $Table16;
    private jaxx.runtime.swing.Table $Table19;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table22;
    private jaxx.runtime.swing.Table $Table25;
    private jaxx.runtime.swing.Table $Table29;
    private jaxx.runtime.swing.Table $Table30;
    private jaxx.runtime.swing.Table $Table5;
    private jaxx.runtime.swing.Table $Table6;
    private jaxx.runtime.swing.Table $Table7;
    private jaxx.runtime.swing.Table $Table9;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource33 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulParamsSelect.model");
    private java.beans.PropertyChangeListener $DataSource36 = new jaxx.runtime.DataBindingListener($Table0, "lblName.text");
    private java.beans.PropertyChangeListener $DataSource41 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulParamsDesc.text");
    private java.beans.PropertyChangeListener $DataSource44 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulParamsNbAnnees.text");
    private java.beans.PropertyChangeListener $DataSource51 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulParamsMesuresSelect.model");
    private java.beans.PropertyChangeListener $DataSource64 = new jaxx.runtime.DataBindingListener($Table0, "fieldUseSimulPreScripts.selected");
    private java.beans.PropertyChangeListener $DataSource65 = new jaxx.runtime.DataBindingListener($Table0, "fieldUseSimulPreScripts.visible");
    private java.beans.PropertyChangeListener $DataSource66 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulUseAnalysePlan.selected");
    private java.beans.PropertyChangeListener $DataSource67 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulUseAnalysePlan.visible");
    private java.beans.PropertyChangeListener $DataSource68 = new jaxx.runtime.DataBindingListener($Table0, "comboSelLauncher.model");

    /* begin raw body code */
    // instances variables déclaration
    SimulationServiceListener simulationListener;
    StorageChangeListener regionStorageListener;
    SimulAction simulAction;
    
    
    public  ParamsUI(SimulAction action) {
        setContextValue(action);
    $initialize();
    }
    
    public void refresh() {
        // TODO add comment why remove/readd ?
        // Disabled , concurrent modification exception
        // refresh is called durring listener iteration
        //SimulationService.getService().removeSimulationServiceListener(simulationListener);
        //SimulationService.getService().addSimulationServiceListener(simulationListener);
        
        if (simulAction.getSimulationStorage() != null) {
            fieldSimulParamsName.setText(simulAction.getSimulationStorage().getName());
        }
        fieldSimulParamsDesc.setText(simulAction.getSimulationParameter().getDescription());
        setListSimulParamsStrategiesItems();
        setListSimulParamsPopulationsItems();
        setRulesListModel();
    }
    
    /**
     * Called on user region selection change.
     */
    protected void regionChange() {
        // le premier item est " " pour ne pas avoir de selection par defaut
        final String selected = fieldSimulParamsRegion.getSelectedItem().toString();
        if (log.isDebugEnabled()) {
            log.debug(" selected " + selected);
        }
        if(selected != null && !selected.trim().isEmpty()) {
            getParentContainer(WelcomePanelUI.class).setStatusMessage(_("isisfish.message.loading.region"));
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    simulAction.regionChange(selected);
                    refresh();
                    setSensitivityTabRegion();
                    getParentContainer(WelcomePanelUI.class).setStatusMessage(_("isisfish.message.region.loaded"));
                }
            });
        }
    }
    protected void setPreScript() {
        if (!isSensitivity()){
            String preScript = simulAction.getSimulationParameter().getPreScript();
            fieldUseSimulPreScripts.setSelected(preScript != null && !preScript.isEmpty());
            getParentContainer(SimulUI.class).getPreScriptUI().getFieldSimulPreScript().setText(preScript);
        }
    }
    protected void setAnalysePlan() {
        if (!isSensitivity()){
            fieldSimulUseAnalysePlan.setSelected(simulAction.getSimulationParameter().getUseAnalysePlan());
            getParentContainer(SimulUI.class).getSensUI().refresh();
        }
    }
    protected void setSensitivityTabRegion() {
        if (isSensitivity()) {
            try {
                // FIXME this transation in nerver closed
                TopiaContext tx = simulAction.getRegionStorage().getStorage().beginTransaction();
                FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                getParentContainer(SensitivityUI.class).getSensitivityTabUI().setRegion((FisheryRegionImpl) fisheryRegion);
                getParentContainer(SensitivityUI.class).getSensitivityTabUI().setTreeModel();
            } catch (StorageException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't reload factors", ex);
                }
            } catch (TopiaException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't reload factors", ex);
                }
            }
        }
    }
    protected void setFactor() {
        if (isSensitivity()) {
            getParentContainer(SensitivityUI.class).getSensitivityTabUI().setFactorModel();
        }
    }
    protected void setExportSens() {
        if (isSensitivity()) {
            getParentContainer(SensitivityUI.class).getSensitivityChooserUI().setSensitivityExportListModel();
        }
    }
    protected void setSensitivityCalculator() {
        if (isSensitivity()){
            getParentContainer(SensitivityUI.class).getSensitivityChooserUI().refreshSelectedSensitivityCalculator();
        }
    }
    public void setSimulationParameter(SimulAction simulAction){
       simulAction.setSimulationParameter(simulAction.getSimulationParameter());
    }
    protected void loadOldSimulation() {
        final String selected = fieldSimulParamsSelect.getSelectedItem().toString();
        // le premier item est " " pour ne pas avoir de selection par defaut
        if (selected != null && !selected.equals(" ")) {
            getParentContainer(WelcomePanelUI.class).setStatusMessage(_("isisfish.message.loading.old.simulation"));
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    simulAction.loadOldSimulation(selected);
                    //refresh();
                    fieldSimulParamsRegion.setSelectedItem(getContextValue(SimulAction.class).getSimulationParameter().getRegionName());
                    // mise a jour des années
                    fieldSimulParamsNbAnnees.setText(String.valueOf(simulAction.getNumberOfYear()));
                    setPreScript();
                    setAnalysePlan();
                    //setFactorRegion();
                    setExportSens();
                    setSensitivityCalculator();
                    setFactor();
                    getParentContainer(WelcomePanelUI.class).setStatusMessage(_("isisfish.message.old.simulation.loaded"));
                }
            });
        }
    }
    protected void launchSimulation() {
        if (!isSensitivity()) {
            simulAction.launchSimulation(fieldSimulParamsName.getText(), (SimulatorLauncher)comboSelLauncher.getSelectedItem());
        }
        else {
            simulAction.launchSimulationWithSensibility(fieldSimulParamsName.getText(), (SimulatorLauncher)comboSelLauncher.getSelectedItem());
        }
        
        // dans le cas d'une fenetre independante, il n'y a pas de ParentContainer
        WelcomeTabUI parent = getParentContainer(WelcomeTabUI.class);
        if (parent != null) {
            parent.setQueueTabSelection();
        }
    }
    protected void enablePreSimul() {
        simulAction.getSimulationParameter().setUsePreScript(fieldUseSimulPreScripts.isSelected());
        if (!isSensitivity()){
            SimulUI simul = getParentContainer(SimulUI.class);
            simul.enablePreSimul(fieldUseSimulPreScripts.isSelected());
        }
    }
    protected void enableAnalysePlan() {
        simulAction.getSimulationParameter().setUseAnalysePlan(fieldSimulUseAnalysePlan.isSelected());
        if (!isSensitivity()) {
            SimulUI simul = getParentContainer(SimulUI.class);
            simul.enableAnalysePlan(fieldSimulUseAnalysePlan.isSelected());
        }
    }
    protected void selTab(MouseEvent e, int i) {
        if (((JCheckBox)e.getSource()).isSelected()){
            SimulUI simul = getParentContainer(SimulUI.class);
            simul.selTab(i);
        }
    }
    protected void setNbAnnees() {
        simulAction.setNumberOfYear(fieldSimulParamsNbAnnees.getText());
    }
    protected void setListSimulParamsStrategiesItems() {
        DefaultListModel listSimulParamsStrategiesModel = new DefaultListModel();
        java.util.List<Strategy> strategies = simulAction.getStrategies();
        for (Strategy s : strategies){
            listSimulParamsStrategiesModel.addElement(s);
        }
        listSimulParamsStrategies.setModel(listSimulParamsStrategiesModel);
        java.util.List<Strategy> strategiesSelected = simulAction.getSimulationParameter().getStrategies();
        if (listSimulParamsStrategiesModel.size() != 0) {
            for (Strategy s : strategiesSelected){
                int index = listSimulParamsStrategiesModel.indexOf(s);
                listSimulParamsStrategies.addSelectionInterval(index, index);
            }
            
            strategySelected();
        }
    }
    protected void setListSimulParamsPopulationsItems(){
        DefaultListModel listSimulParamsPopulationsModel = new DefaultListModel();
        java.util.List<Population> populations = simulAction.getPopulations();
        for (Population p : populations){
            listSimulParamsPopulationsModel.addElement(p);
        }
        listSimulParamsPopulations.setModel(listSimulParamsPopulationsModel);
        java.util.List<Population> populationsSelected = simulAction.getSimulationParameter().getPopulations();
        if (listSimulParamsPopulationsModel.size() != 0) {
            for (Population p : populationsSelected) {
                int index = listSimulParamsPopulationsModel.indexOf(p);
                listSimulParamsPopulations.addSelectionInterval(index, index);
            }
            populationSelected();
        }
    }
    protected void populationSelected(){
        if (listSimulParamsPopulations.getSelectedIndex() != -1) {
            simulAction.setPopulations(listSimulParamsPopulations.getSelectedValues());
            simulParamsNumbers.setMatrix(simulAction.getSimulationParameter().getNumberOf((Population) listSimulParamsPopulations.getSelectedValue()));
        }
    }
    protected void strategySelected(){
        simulAction.setStrategies(listSimulParamsStrategies.getSelectedValues());
    }
    
    protected void saveDescription() {
        simulAction.getSimulationParameter().setDescription(fieldSimulParamsDesc.getText());
    }
    
    protected void setRulesListModel() {
        if (log.isDebugEnabled()) {
            log.debug("Set simulation rules model");
        }
        RuleListModel model = new RuleListModel(simulAction.getRules());
        listSimulParamsMesuresList.setModel(model);
        listSimulParamsMesuresList.setCellRenderer(model);
    
        onRuleSelectionChange();
    }
    /**
     * Called when selection change on rule list.
     */
    protected void onRuleSelectionChange() {
        if (simulAction.getRules().isEmpty()) {
            buttonSimulParamsMesuresClear.setEnabled(false);
            buttonSimulParamsMesuresRemove.setEnabled(false);
        }
        else {
            if (listSimulParamsMesuresList.getSelectedIndex() != -1) {
                buttonSimulParamsMesuresRemove.setEnabled(true);
                setSimulParamsRulesModel();
            }
            buttonSimulParamsMesuresClear.setEnabled(true);
        }
    }
    
    protected void setSimulParamsRulesModel() {
        int selectedRuleIndex = listSimulParamsMesuresList.getSelectedIndex();
        if (selectedRuleIndex != -1) {
            RuleListModel listModel = (RuleListModel)listSimulParamsMesuresList.getModel();
            Rule selectedRule = listModel.getRules().get(selectedRuleIndex);
            RuleParametersTableModel model = new RuleParametersTableModel(selectedRule);
            RuleParametersTableCellEditor cellEditor = new RuleParametersTableCellEditor(selectedRule);
            RuleParametersTableCellRenderer cellRenderer = new RuleParametersTableCellRenderer(selectedRule);
            cellEditor.setRegion(simulAction.getRegionStorage());
            simulParamsRules.setModel(model);
            simulParamsRules.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            simulParamsRules.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        }
    }
    protected void addRules() {
        String selectedRuleName = (String)fieldSimulParamsMesuresSelect.getSelectedItem();
        simulAction.addNewRule(selectedRuleName);
        setRulesListModel();
    }
    protected void removeRules() {
        RuleListModel listModel = (RuleListModel)listSimulParamsMesuresList.getModel();
        Rule selectedRule = listModel.getRules().get(listSimulParamsMesuresList.getSelectedIndex());
        simulAction.removeRule(selectedRule);
        setRulesListModel();
    }
    protected void clearRules() {
       simulAction.getSimulationParameter().clearRules();
       setRulesListModel();
    }
    
    protected void selectFilter() {
        try {
            java.util.List<String> simulationsNames = fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil.filterSimulation(simulAction.getOldSimulationItem());
            // TODO add " " to not triger event (need to be fixed)
            simulationsNames.add(0, " ");
            simulAction.setOldSimulatorNames(simulationsNames);
            fieldSimulParamsSelect.setModel(getSimulParamsSelectModel(false));
        } catch (ParseException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't select simulation filter", ex);
            }
        } catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't select simulation filter", ex);
            }
        }
    }
    
    protected ComboBoxModel getSimulParamsSelectModel() {
        return getSimulParamsSelectModel(false);
    }
    
    protected ComboBoxModel getSimulParamsSelectModel(boolean force) {
        java.util.List<String> items = simulAction.getFilteredOldSimulatorNames(force);
        DefaultComboBoxModel result = new DefaultComboBoxModel();
        if (items != null) {
            for (String s : items){
                result.addElement(s);
            }
        }
        return result;
    }
    
    protected void resetFilter(){
        simulAction.resetOldSimulatorNames();
        fieldSimulParamsSelect.setModel(getSimulParamsSelectModel(false));
    }
    protected void saveName(){
        simulAction.setName(fieldSimulParamsName.getText());
    }
    
    /**
     * TODO : Common code with {@link SimulUI#saveSimulation()}
     * TODO duplicated code (simulUI, Params UI, SensitivityUI)
     */
    protected void saveSimulation() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(null);
    
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            //This is where a real application would open the file.
            simulAction.saveSimulation(file);
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ParamsUI() {
        $initialize();
    }

    public ParamsUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldSimulParamsSelect.model".equals($binding)) {
                addPropertyChangeListener("simulParamsSelectModel", $DataSource33);
        
        } else if ("lblName.text".equals($binding)) {
                addPropertyChangeListener("sensitivity", $DataSource36);
        
        } else if ("fieldSimulParamsDesc.text".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource41);
        
        } else if ("fieldSimulParamsNbAnnees.text".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource44);
        
        } else if ("fieldSimulParamsMesuresSelect.model".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource51);
        
        } else if ("fieldUseSimulPreScripts.selected".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource64);
        
        } else if ("fieldUseSimulPreScripts.visible".equals($binding)) {
                addPropertyChangeListener("sensitivity", $DataSource65);
        
        } else if ("fieldSimulUseAnalysePlan.selected".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource66);
        
        } else if ("fieldSimulUseAnalysePlan.visible".equals($binding)) {
                addPropertyChangeListener("sensitivity", $DataSource67);
        
        } else if ("comboSelLauncher.model".equals($binding)) {
                addPropertyChangeListener("simulAction", $DataSource68);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldSimulParamsSelect.model".equals($dest)) {
            fieldSimulParamsSelect.setModel((getSimulParamsSelectModel()));
            } else if ("lblName.text".equals($dest)) {
            lblName.setText(String.valueOf((isSensitivity() ? _("isisfish.params.sensitivityName") : _("isisfish.params.simulationName"))));
            } else if ("fieldSimulParamsDesc.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText(fieldSimulParamsDesc, String.valueOf((simulAction.getSimulationParameter().getDescription())));
            } else if ("fieldSimulParamsNbAnnees.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText(fieldSimulParamsNbAnnees, String.valueOf((simulAction.getSimulationParameter().getNumberOfYear())));
            } else if ("fieldSimulParamsMesuresSelect.model".equals($dest)) {
            fieldSimulParamsMesuresSelect.setModel((new RuleComboModel(simulAction.getAvailableRuleNames())));
            } else if ("fieldUseSimulPreScripts.selected".equals($dest)) {
            fieldUseSimulPreScripts.setSelected((simulAction.getSimulationParameter().getUsePreScript()));
            } else if ("fieldUseSimulPreScripts.visible".equals($dest)) {
            fieldUseSimulPreScripts.setVisible((!isSensitivity()));
            } else if ("fieldSimulUseAnalysePlan.selected".equals($dest)) {
            fieldSimulUseAnalysePlan.setSelected((simulAction.getSimulationParameter().getUseAnalysePlan()));
            } else if ("fieldSimulUseAnalysePlan.visible".equals($dest)) {
            fieldSimulUseAnalysePlan.setVisible((!isSensitivity()));
            } else if ("comboSelLauncher.model".equals($dest)) {
            comboSelLauncher.setModel((new DefaultComboBoxModel(simulAction.getSimulationLauncher().toArray())));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldSimulParamsSelect.model".equals($binding)) {
                removePropertyChangeListener("simulParamsSelectModel", $DataSource33);
        
        } else if ("lblName.text".equals($binding)) {
                removePropertyChangeListener("sensitivity", $DataSource36);
        
        } else if ("fieldSimulParamsDesc.text".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource41);
        
        } else if ("fieldSimulParamsNbAnnees.text".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource44);
        
        } else if ("fieldSimulParamsMesuresSelect.model".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource51);
        
        } else if ("fieldUseSimulPreScripts.selected".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource64);
        
        } else if ("fieldUseSimulPreScripts.visible".equals($binding)) {
                removePropertyChangeListener("sensitivity", $DataSource65);
        
        } else if ("fieldSimulUseAnalysePlan.selected".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource66);
        
        } else if ("fieldSimulUseAnalysePlan.visible".equals($binding)) {
                removePropertyChangeListener("sensitivity", $DataSource67);
        
        } else if ("comboSelLauncher.model".equals($binding)) {
                removePropertyChangeListener("simulAction", $DataSource68);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonSimulParamsMesuresAdd(java.awt.event.ActionEvent event) {
        addRules();
    }

    public void doActionPerformed__on__buttonSimulParamsMesuresClear(java.awt.event.ActionEvent event) {
        clearRules();
    }

    public void doActionPerformed__on__buttonSimulParamsMesuresRemove(java.awt.event.ActionEvent event) {
        removeRules();
    }

    public void doActionPerformed__on__buttonSimulParamsSelectClearFilter(java.awt.event.ActionEvent event) {
        resetFilter();
    }

    public void doActionPerformed__on__buttonSimulParamsSelectFilter(java.awt.event.ActionEvent event) {
        selectFilter();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulate(java.awt.event.ActionEvent event) {
        launchSimulation();
    }

    public void doActionPerformed__on__fieldSimulParamsRegion(java.awt.event.ActionEvent event) {
        regionChange();
    }

    public void doActionPerformed__on__fieldSimulParamsSelect(java.awt.event.ActionEvent event) {
        loadOldSimulation();
    }

    public void doActionPerformed__on__saveSimul(java.awt.event.ActionEvent event) {
        saveSimulation();
    }

    public void doFocusGained__on__listSimulParamsMesuresList(java.awt.event.FocusEvent event) {
        parametersTabbedPane.setSelectedIndex(1);
    }

    public void doFocusGained__on__listSimulParamsPopulations(java.awt.event.FocusEvent event) {
        parametersTabbedPane.setSelectedIndex(0);
    }

    public void doFocusLost__on__fieldSimulParamsDesc(java.awt.event.FocusEvent event) {
        saveDescription();
    }

    public void doFocusLost__on__fieldSimulParamsName(java.awt.event.FocusEvent event) {
        saveName();
    }

    public void doFocusLost__on__fieldSimulParamsNbAnnees(java.awt.event.FocusEvent event) {
        setNbAnnees();
    }

    public void doItemStateChanged__on__fieldSimulUseAnalysePlan(java.awt.event.ItemEvent event) {
        enableAnalysePlan();
    }

    public void doItemStateChanged__on__fieldUseSimulPreScripts(java.awt.event.ItemEvent event) {
        enablePreSimul();
    }

    public void doMouseReleased__on__fieldSimulUseAnalysePlan(java.awt.event.MouseEvent event) {
        selTab(event, 2);
    }

    public void doMouseReleased__on__fieldUseSimulPreScripts(java.awt.event.MouseEvent event) {
        selTab(event, 1);
    }

    public void doValueChanged__on__listSimulParamsMesuresList(javax.swing.event.ListSelectionEvent event) {
        onRuleSelectionChange();
    }

    public void doValueChanged__on__listSimulParamsPopulations(javax.swing.event.ListSelectionEvent event) {
        populationSelected();
    }

    public void doValueChanged__on__listSimulParamsStrategies(javax.swing.event.ListSelectionEvent event) {
        strategySelected();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getButtonSimulParamsMesuresAdd() {
        return buttonSimulParamsMesuresAdd;
    }

    public javax.swing.JButton getButtonSimulParamsMesuresClear() {
        return buttonSimulParamsMesuresClear;
    }

    public javax.swing.JButton getButtonSimulParamsMesuresRemove() {
        return buttonSimulParamsMesuresRemove;
    }

    public javax.swing.JButton getButtonSimulParamsSelectClearFilter() {
        return buttonSimulParamsSelectClearFilter;
    }

    public javax.swing.JButton getButtonSimulParamsSelectFilter() {
        return buttonSimulParamsSelectFilter;
    }

    public javax.swing.JButton getButtonSimulParamsSimulate() {
        return buttonSimulParamsSimulate;
    }

    public jaxx.runtime.swing.JAXXComboBox getComboSelLauncher() {
        return comboSelLauncher;
    }

    public javax.swing.JTextArea getFieldSimulParamsDesc() {
        return fieldSimulParamsDesc;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSimulParamsMesuresSelect() {
        return fieldSimulParamsMesuresSelect;
    }

    public javax.swing.JTextField getFieldSimulParamsName() {
        return fieldSimulParamsName;
    }

    public javax.swing.JTextField getFieldSimulParamsNbAnnees() {
        return fieldSimulParamsNbAnnees;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSimulParamsRegion() {
        return fieldSimulParamsRegion;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSimulParamsSelect() {
        return fieldSimulParamsSelect;
    }

    public javax.swing.JCheckBox getFieldSimulUseAnalysePlan() {
        return fieldSimulUseAnalysePlan;
    }

    public javax.swing.JCheckBox getFieldUseSimulPreScripts() {
        return fieldUseSimulPreScripts;
    }

    public javax.swing.JLabel getLblLauncher() {
        return lblLauncher;
    }

    public javax.swing.JLabel getLblName() {
        return lblName;
    }

    public jaxx.runtime.swing.JAXXList getListSimulParamsMesuresList() {
        return listSimulParamsMesuresList;
    }

    public jaxx.runtime.swing.JAXXList getListSimulParamsPopulations() {
        return listSimulParamsPopulations;
    }

    public jaxx.runtime.swing.JAXXList getListSimulParamsStrategies() {
        return listSimulParamsStrategies;
    }

    public javax.swing.JTabbedPane getParametersTabbedPane() {
        return parametersTabbedPane;
    }

    public javax.swing.JButton getSaveSimul() {
        return saveSimul;
    }

    public java.lang.Boolean getSensitivity() {
        return sensitivity;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getSimulParamsNumbers() {
        return simulParamsNumbers;
    }

    public javax.swing.JTable getSimulParamsRules() {
        return simulParamsRules;
    }

    public java.lang.Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setSensitivity(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.sensitivity;
        this.sensitivity = newValue;
        firePropertyChange("sensitivity", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected javax.swing.JLabel get$JLabel20() {
        return $JLabel20;
    }

    protected javax.swing.JLabel get$JLabel23() {
        return $JLabel23;
    }

    protected javax.swing.JLabel get$JLabel26() {
        return $JLabel26;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JPanel get$JPanel11() {
        return $JPanel11;
    }

    protected javax.swing.JPanel get$JPanel15() {
        return $JPanel15;
    }

    protected javax.swing.JPanel get$JPanel27() {
        return $JPanel27;
    }

    protected javax.swing.JScrollPane get$JScrollPane12() {
        return $JScrollPane12;
    }

    protected javax.swing.JScrollPane get$JScrollPane18() {
        return $JScrollPane18;
    }

    protected javax.swing.JScrollPane get$JScrollPane21() {
        return $JScrollPane21;
    }

    protected javax.swing.JScrollPane get$JScrollPane24() {
        return $JScrollPane24;
    }

    protected javax.swing.JScrollPane get$JScrollPane28() {
        return $JScrollPane28;
    }

    protected javax.swing.JSeparator get$JSeparator4() {
        return $JSeparator4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo31() {
        return $TabInfo31;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo32() {
        return $TabInfo32;
    }

    protected fr.ifremer.isisfish.ui.simulator.ParamsUI get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table13() {
        return $Table13;
    }

    protected jaxx.runtime.swing.Table get$Table16() {
        return $Table16;
    }

    protected jaxx.runtime.swing.Table get$Table19() {
        return $Table19;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table22() {
        return $Table22;
    }

    protected jaxx.runtime.swing.Table get$Table25() {
        return $Table25;
    }

    protected jaxx.runtime.swing.Table get$Table29() {
        return $Table29;
    }

    protected jaxx.runtime.swing.Table get$Table30() {
        return $Table30;
    }

    protected jaxx.runtime.swing.Table get$Table5() {
        return $Table5;
    }

    protected jaxx.runtime.swing.Table get$Table6() {
        return $Table6;
    }

    protected jaxx.runtime.swing.Table get$Table7() {
        return $Table7;
    }

    protected jaxx.runtime.swing.Table get$Table9() {
        return $Table9;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add($Table2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator4, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        $Table0.add($Table5, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table29, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table30, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(fieldSimulParamsSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(buttonSimulParamsSelectFilter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(buttonSimulParamsSelectClearFilter, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $Table5.add($Table6, new GridBagConstraints(0, 0, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table7, new GridBagConstraints(2, 0, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table9, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JScrollPane12, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table13, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JPanel15, new GridBagConstraints(2, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table16, new GridBagConstraints(0, 4, 1, 1, 0.2, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table19, new GridBagConstraints(1, 4, 1, 1, 0.4, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table22, new GridBagConstraints(2, 4, 1, 1, 0.4, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table25, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(parametersTabbedPane, new GridBagConstraints(0, 5, 4, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table6.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(fieldSimulParamsName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table7.add($JLabel8, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(fieldSimulParamsRegion, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $Table9.add($JLabel10, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add($JPanel11, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $JScrollPane12.getViewport().add(fieldSimulParamsDesc);
        
        $Table13.add($JLabel14, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(fieldSimulParamsNbAnnees, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $Table16.add($JLabel17, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table16.add($JScrollPane18, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane18.getViewport().add(listSimulParamsStrategies);
        
        $Table19.add($JLabel20, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table19.add($JScrollPane21, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane21.getViewport().add(listSimulParamsPopulations);
        
        $Table22.add($JLabel23, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table22.add(fieldSimulParamsMesuresSelect, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table22.add($JScrollPane24, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane24.getViewport().add(listSimulParamsMesuresList);
        
        $Table25.add($JLabel26, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(buttonSimulParamsMesuresAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(buttonSimulParamsMesuresRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(buttonSimulParamsMesuresClear, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JPanel27, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        addChildrenToParametersTabbedPane();
        $JScrollPane28.getViewport().add(simulParamsRules);
        
        $Table29.add(fieldUseSimulPreScripts, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table29.add(fieldSimulUseAnalysePlan, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table30.add(lblLauncher, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table30.add(comboSelLauncher, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table30.add(buttonSimulParamsSimulate, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table30.add(saveSimul, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        applyDataBinding("fieldSimulParamsSelect.model");
        lblName.setMinimumSize((new Dimension(195,25)));
        lblName.setPreferredSize((new Dimension(195,25)));
        applyDataBinding("lblName.text");
        fieldSimulParamsRegion.setModel((new DefaultComboBoxModel(Common.getRegionItem())));
        fieldSimulParamsRegion.setSelectedItem((getContextValue(SimulAction.class).getSimulationParameter().getRegionName()));
        $JScrollPane12.setMinimumSize((new Dimension(0,0)));
        $JScrollPane12.setPreferredSize((new Dimension(0,0)));
        applyDataBinding("fieldSimulParamsDesc.text");
        $JLabel14.setMinimumSize((new Dimension(140,25)));
        $JLabel14.setPreferredSize((new Dimension(140,25)));
        applyDataBinding("fieldSimulParamsNbAnnees.text");
        $JScrollPane18.setMinimumSize((new Dimension(0,0)));
        $JScrollPane18.setPreferredSize((new Dimension(0,0)));
        listSimulParamsStrategies.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
        $JScrollPane21.setMinimumSize((new Dimension(0,0)));
        $JScrollPane21.setPreferredSize((new Dimension(0,0)));
        listSimulParamsPopulations.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
        applyDataBinding("fieldSimulParamsMesuresSelect.model");
        fieldSimulParamsMesuresSelect.setRenderer((new RuleComboRenderer()));
        $JScrollPane24.setMinimumSize((new Dimension(0,0)));
        $JScrollPane24.setPreferredSize((new Dimension(0,0)));
        listSimulParamsMesuresList.setSelectionMode((javax.swing.ListSelectionModel.SINGLE_SELECTION));
        $JLabel26.setMinimumSize((new Dimension(2,15)));
        $JLabel26.setPreferredSize((new Dimension(2,15)));
        parametersTabbedPane.setMinimumSize((new Dimension(0,0)));
        parametersTabbedPane.setPreferredSize((new Dimension(0,0)));
        $TabInfo31.setTitle((_("isisfish.params.populationNumbers")));
        $TabInfo32.setTitle((_("isisfish.params.ruleParameters")));
        $JScrollPane28.setMinimumSize((new Dimension(0,0)));
        $JScrollPane28.setPreferredSize((new Dimension(0,0)));
        applyDataBinding("fieldUseSimulPreScripts.selected");
        applyDataBinding("fieldUseSimulPreScripts.visible");
        applyDataBinding("fieldSimulUseAnalysePlan.selected");
        applyDataBinding("fieldSimulUseAnalysePlan.visible");
        applyDataBinding("comboSelLauncher.model");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createSensitivity();
        
        simulAction = getContextValue(SimulAction.class);
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.params.loadOldSimulation"));
        
        createFieldSimulParamsSelect();
        createButtonSimulParamsSelectFilter();
        createButtonSimulParamsSelectClearFilter();
        
        $JSeparator4 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator4", $JSeparator4);
        $JSeparator4.setName("$JSeparator4");
        
        $Table5 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table5", $Table5);
        $Table5.setName("$Table5");
        
        $Table6 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table6", $Table6);
        $Table6.setName("$Table6");
        
        createLblName();
        createFieldSimulParamsName();
        
        $Table7 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table7", $Table7);
        $Table7.setName("$Table7");
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.common.region"));
        
        createFieldSimulParamsRegion();
        
        $Table9 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table9", $Table9);
        $Table9.setName("$Table9");
        
        $JLabel10 = new javax.swing.JLabel();
        $objectMap.put("$JLabel10", $JLabel10);
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("isisfish.params.description"));
        
        $JPanel11 = new javax.swing.JPanel();
        $objectMap.put("$JPanel11", $JPanel11);
        $JPanel11.setName("$JPanel11");
        
        $JScrollPane12 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane12", $JScrollPane12);
        $JScrollPane12.setName("$JScrollPane12");
        
        createFieldSimulParamsDesc();
        
        $Table13 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table13", $Table13);
        $Table13.setName("$Table13");
        
        $JLabel14 = new javax.swing.JLabel();
        $objectMap.put("$JLabel14", $JLabel14);
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(_("isisfish.params.numberYear"));
        
        createFieldSimulParamsNbAnnees();
        
        $JPanel15 = new javax.swing.JPanel();
        $objectMap.put("$JPanel15", $JPanel15);
        $JPanel15.setName("$JPanel15");
        
        $Table16 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table16", $Table16);
        $Table16.setName("$Table16");
        
        $JLabel17 = new javax.swing.JLabel();
        $objectMap.put("$JLabel17", $JLabel17);
        $JLabel17.setName("$JLabel17");
        $JLabel17.setText(_("isisfish.common.strategies"));
        
        $JScrollPane18 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane18", $JScrollPane18);
        $JScrollPane18.setName("$JScrollPane18");
        
        createListSimulParamsStrategies();
        
        $Table19 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table19", $Table19);
        $Table19.setName("$Table19");
        
        $JLabel20 = new javax.swing.JLabel();
        $objectMap.put("$JLabel20", $JLabel20);
        $JLabel20.setName("$JLabel20");
        $JLabel20.setText(_("isisfish.common.populations"));
        
        $JScrollPane21 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane21", $JScrollPane21);
        $JScrollPane21.setName("$JScrollPane21");
        
        createListSimulParamsPopulations();
        
        $Table22 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table22", $Table22);
        $Table22.setName("$Table22");
        
        $JLabel23 = new javax.swing.JLabel();
        $objectMap.put("$JLabel23", $JLabel23);
        $JLabel23.setName("$JLabel23");
        $JLabel23.setText(_("isisfish.common.rules"));
        
        createFieldSimulParamsMesuresSelect();
        
        $JScrollPane24 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane24", $JScrollPane24);
        $JScrollPane24.setName("$JScrollPane24");
        
        createListSimulParamsMesuresList();
        
        $Table25 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table25", $Table25);
        $Table25.setName("$Table25");
        
        $JLabel26 = new javax.swing.JLabel();
        $objectMap.put("$JLabel26", $JLabel26);
        $JLabel26.setName("$JLabel26");
        $JLabel26.setText(_(""));
        
        createButtonSimulParamsMesuresAdd();
        createButtonSimulParamsMesuresRemove();
        createButtonSimulParamsMesuresClear();
        
        $JPanel27 = new javax.swing.JPanel();
        $objectMap.put("$JPanel27", $JPanel27);
        $JPanel27.setName("$JPanel27");
        
        createParametersTabbedPane();
        createSimulParamsNumbers();
        
        $JScrollPane28 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane28", $JScrollPane28);
        $JScrollPane28.setName("$JScrollPane28");
        
        createSimulParamsRules();
        
        $Table29 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table29", $Table29);
        $Table29.setName("$Table29");
        
        createFieldUseSimulPreScripts();
        createFieldSimulUseAnalysePlan();
        
        $Table30 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table30", $Table30);
        $Table30.setName("$Table30");
        
        createLblLauncher();
        createComboSelLauncher();
        createButtonSimulParamsSimulate();
        createSaveSimul();
        
        $TabInfo31 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo31", $TabInfo31);
        
        $TabInfo32 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo32", $TabInfo32);
        
        $Table0.setName("$Table0");
        
        
        jaxx.runtime.Util.assignment(regionStorageListener = new StorageChangeListener() {
            @Override
            public void versionDataChanged(StorageChangeEvent e) {
                fieldSimulParamsRegion.setModel(new DefaultComboBoxModel(Common.getRegionItem()));
            }
        }, "regionStorageListener", fr.ifremer.isisfish.ui.simulator.ParamsUI.this);RegionStorage.addStorageChangeListener(regionStorageListener);// end constructor code
        simulationListener = new SimulationServiceListener() {
            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }
        
            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                fieldSimulParamsSelect.setModel(getSimulParamsSelectModel(true));
            }
        
            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };
        $completeSetup();
    }

    protected void addChildrenToParametersTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        parametersTabbedPane.add(simulParamsNumbers);
        parametersTabbedPane.add($JScrollPane28);
        $TabInfo31.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(parametersTabbedPane, 0));
        $TabInfo32.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(parametersTabbedPane, 1));
    }

    protected void createButtonSimulParamsMesuresAdd() {
        buttonSimulParamsMesuresAdd = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsMesuresAdd", buttonSimulParamsMesuresAdd);
        buttonSimulParamsMesuresAdd.setName("buttonSimulParamsMesuresAdd");
        buttonSimulParamsMesuresAdd.setText(_("isisfish.common.add"));
        buttonSimulParamsMesuresAdd.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsMesuresAdd"));
    }

    protected void createButtonSimulParamsMesuresClear() {
        buttonSimulParamsMesuresClear = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsMesuresClear", buttonSimulParamsMesuresClear);
        buttonSimulParamsMesuresClear.setName("buttonSimulParamsMesuresClear");
        buttonSimulParamsMesuresClear.setEnabled(false);
        buttonSimulParamsMesuresClear.setText(_("isisfish.common.clear"));
        buttonSimulParamsMesuresClear.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsMesuresClear"));
    }

    protected void createButtonSimulParamsMesuresRemove() {
        buttonSimulParamsMesuresRemove = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsMesuresRemove", buttonSimulParamsMesuresRemove);
        buttonSimulParamsMesuresRemove.setName("buttonSimulParamsMesuresRemove");
        buttonSimulParamsMesuresRemove.setEnabled(false);
        buttonSimulParamsMesuresRemove.setText(_("isisfish.common.remove"));
        buttonSimulParamsMesuresRemove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsMesuresRemove"));
    }

    protected void createButtonSimulParamsSelectClearFilter() {
        buttonSimulParamsSelectClearFilter = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsSelectClearFilter", buttonSimulParamsSelectClearFilter);
        buttonSimulParamsSelectClearFilter.setName("buttonSimulParamsSelectClearFilter");
        buttonSimulParamsSelectClearFilter.setEnabled(false);
        buttonSimulParamsSelectClearFilter.setText(_("isisfish.params.clearFilter"));
        buttonSimulParamsSelectClearFilter.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsSelectClearFilter"));
    }

    protected void createButtonSimulParamsSelectFilter() {
        buttonSimulParamsSelectFilter = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsSelectFilter", buttonSimulParamsSelectFilter);
        buttonSimulParamsSelectFilter.setName("buttonSimulParamsSelectFilter");
        buttonSimulParamsSelectFilter.setEnabled(false);
        buttonSimulParamsSelectFilter.setText(_("isisfish.params.filter"));
        buttonSimulParamsSelectFilter.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsSelectFilter"));
    }

    protected void createButtonSimulParamsSimulate() {
        buttonSimulParamsSimulate = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsSimulate", buttonSimulParamsSimulate);
        buttonSimulParamsSimulate.setName("buttonSimulParamsSimulate");
        buttonSimulParamsSimulate.setText(_("isisfish.common.simulate"));
        buttonSimulParamsSimulate.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsSimulate"));
    }

    protected void createComboSelLauncher() {
        comboSelLauncher = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("comboSelLauncher", comboSelLauncher);
        comboSelLauncher.setName("comboSelLauncher");
    }

    protected void createFieldSimulParamsDesc() {
        fieldSimulParamsDesc = new javax.swing.JTextArea();
        $objectMap.put("fieldSimulParamsDesc", fieldSimulParamsDesc);
        fieldSimulParamsDesc.setName("fieldSimulParamsDesc");
        fieldSimulParamsDesc.setColumns(15);
        fieldSimulParamsDesc.setLineWrap(true);
        fieldSimulParamsDesc.setWrapStyleWord(true);
        fieldSimulParamsDesc.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", $Table0, "doFocusLost__on__fieldSimulParamsDesc"));
    }

    protected void createFieldSimulParamsMesuresSelect() {
        fieldSimulParamsMesuresSelect = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSimulParamsMesuresSelect", fieldSimulParamsMesuresSelect);
        fieldSimulParamsMesuresSelect.setName("fieldSimulParamsMesuresSelect");
    }

    protected void createFieldSimulParamsName() {
        fieldSimulParamsName = new javax.swing.JTextField();
        $objectMap.put("fieldSimulParamsName", fieldSimulParamsName);
        fieldSimulParamsName.setName("fieldSimulParamsName");
        fieldSimulParamsName.setColumns(15);
        fieldSimulParamsName.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", $Table0, "doFocusLost__on__fieldSimulParamsName"));
    }

    protected void createFieldSimulParamsNbAnnees() {
        fieldSimulParamsNbAnnees = new javax.swing.JTextField();
        $objectMap.put("fieldSimulParamsNbAnnees", fieldSimulParamsNbAnnees);
        fieldSimulParamsNbAnnees.setName("fieldSimulParamsNbAnnees");
        fieldSimulParamsNbAnnees.setColumns(15);
        fieldSimulParamsNbAnnees.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", $Table0, "doFocusLost__on__fieldSimulParamsNbAnnees"));
    }

    protected void createFieldSimulParamsRegion() {
        fieldSimulParamsRegion = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSimulParamsRegion", fieldSimulParamsRegion);
        fieldSimulParamsRegion.setName("fieldSimulParamsRegion");
        fieldSimulParamsRegion.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__fieldSimulParamsRegion"));
    }

    protected void createFieldSimulParamsSelect() {
        fieldSimulParamsSelect = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSimulParamsSelect", fieldSimulParamsSelect);
        fieldSimulParamsSelect.setName("fieldSimulParamsSelect");
        fieldSimulParamsSelect.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__fieldSimulParamsSelect"));
    }

    protected void createFieldSimulUseAnalysePlan() {
        fieldSimulUseAnalysePlan = new javax.swing.JCheckBox();
        $objectMap.put("fieldSimulUseAnalysePlan", fieldSimulUseAnalysePlan);
        fieldSimulUseAnalysePlan.setName("fieldSimulUseAnalysePlan");
        fieldSimulUseAnalysePlan.setText(_("isisfish.params.useAnalysePlan"));
        fieldSimulUseAnalysePlan.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, "itemStateChanged", $Table0, "doItemStateChanged__on__fieldSimulUseAnalysePlan"));
        fieldSimulUseAnalysePlan.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseReleased", $Table0, "doMouseReleased__on__fieldSimulUseAnalysePlan"));
    }

    protected void createFieldUseSimulPreScripts() {
        fieldUseSimulPreScripts = new javax.swing.JCheckBox();
        $objectMap.put("fieldUseSimulPreScripts", fieldUseSimulPreScripts);
        fieldUseSimulPreScripts.setName("fieldUseSimulPreScripts");
        fieldUseSimulPreScripts.setText(_("isisfish.params.usePreSimulationScript"));
        fieldUseSimulPreScripts.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, "itemStateChanged", $Table0, "doItemStateChanged__on__fieldUseSimulPreScripts"));
        fieldUseSimulPreScripts.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseReleased", $Table0, "doMouseReleased__on__fieldUseSimulPreScripts"));
    }

    protected void createLblLauncher() {
        lblLauncher = new javax.swing.JLabel();
        $objectMap.put("lblLauncher", lblLauncher);
        lblLauncher.setName("lblLauncher");
        lblLauncher.setText(_("isisfish.params.lblLauncher"));
    }

    protected void createLblName() {
        lblName = new javax.swing.JLabel();
        $objectMap.put("lblName", lblName);
        lblName.setName("lblName");
    }

    protected void createListSimulParamsMesuresList() {
        listSimulParamsMesuresList = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("listSimulParamsMesuresList", listSimulParamsMesuresList);
        listSimulParamsMesuresList.setName("listSimulParamsMesuresList");
        listSimulParamsMesuresList.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusGained", $Table0, "doFocusGained__on__listSimulParamsMesuresList"));
        listSimulParamsMesuresList.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__listSimulParamsMesuresList"));
    }

    protected void createListSimulParamsPopulations() {
        listSimulParamsPopulations = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("listSimulParamsPopulations", listSimulParamsPopulations);
        listSimulParamsPopulations.setName("listSimulParamsPopulations");
        listSimulParamsPopulations.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusGained", $Table0, "doFocusGained__on__listSimulParamsPopulations"));
        listSimulParamsPopulations.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__listSimulParamsPopulations"));
    }

    protected void createListSimulParamsStrategies() {
        listSimulParamsStrategies = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("listSimulParamsStrategies", listSimulParamsStrategies);
        listSimulParamsStrategies.setName("listSimulParamsStrategies");
        listSimulParamsStrategies.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__listSimulParamsStrategies"));
    }

    protected void createParametersTabbedPane() {
        parametersTabbedPane = new javax.swing.JTabbedPane();
        $objectMap.put("parametersTabbedPane", parametersTabbedPane);
        parametersTabbedPane.setName("parametersTabbedPane");
    }

    protected void createSaveSimul() {
        saveSimul = new javax.swing.JButton();
        $objectMap.put("saveSimul", saveSimul);
        saveSimul.setName("saveSimul");
        saveSimul.setText(_("isisfish.simulation.menu.save"));
        saveSimul.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__saveSimul"));
    }

    protected void createSensitivity() {
        sensitivity = false;
        $objectMap.put("sensitivity", sensitivity);
    }

    protected void createSimulParamsNumbers() {
        simulParamsNumbers = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("simulParamsNumbers", simulParamsNumbers);
        simulParamsNumbers.removeDataBinding("$MatrixEditor0.name");
        
        simulParamsNumbers.setName("simulParamsNumbers");
        simulParamsNumbers.removeDataBinding("$MatrixEditor0.name");
        
        simulParamsNumbers.setName("isisfish.params.populationNumbers");
    }

    protected void createSimulParamsRules() {
        simulParamsRules = new javax.swing.JTable();
        $objectMap.put("simulParamsRules", simulParamsRules);
        simulParamsRules.setName("simulParamsRules");
        simulParamsRules.setName("isisfish.params.ruleParameters");
        simulParamsRules.setRowHeight(24);
    }

}
