/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityTabUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8bRRiemNpp4rgfbgmoX6RthKqWrtsEaNVE4SNpVEdO2toprTAHJrvjeKrx7nRm1tkICSEhbgj1xIELcOfIvao49sSV/4AQ/4B3xvbuutpsVqwPs+t33veZ5/2YZ3/7GxWlQBef4iCwhO8q2iPWxidPntzfeUpstUakLShXnkCD30QBFdqo7IR2qdDldkOH14bhtVWvxz2XuLHopQaalmqfEdklRCn05iDClrLWCs1LAffFCC0kk4T2y7//FJ473/xaQCjgwKoKKcwdFhVlcKSBCtRRqAon9XGNYXcXaAjq7gLPiratMizlFu6RZ+hrNNlAJY4FgCl0KXuqBsPEB1yho/MbD7BL2A2FFjvCoh1BegSeksoOlV3Lp5YkrqSK9qnat1rR+zbeeVTn3ECVFHrbxX26ixX13BZh0CN42fQcwhS6qqkHltyDTCwlCLHWSAf7TG3D+7hzhHcmwtNuq4SxJnEdIohQaPkAqtTlvrLqet06MDw6Y9rGwmF43/OhhBfGGjUguwr7DbO/EEWdiqIeQHNsyjEkeUonaeE9FQuKYkqC7AIVhawk5tAoKCqR1jr8I2K/aZzrPR6rx8z8RoszqnS3bio0G69ptKOdp8KYUXMXYKbG/I1VO51NxF/UtvN6uRDuT85Dwxl5HzqdUCizpz0vhgEVALSFx5hG/ECht8YZh1va/XLUkqjtCp1NOEmLgO6o9n83DCt3sA1DHuY1l8LlQ228opf3Xo+XI+RrerHC7aoZLB0cdjw8JSphyYU796gOypM6nlvGS8cshKFT4QEhLmwKPVVQAdAjK9KjSDAm2qgofDArdKIdSVcTTAPRGloNgLH+/O1P/R9/f3FnpFCzcEZlzCUmqKAYXHgcLhzVRxwfyJKvKKttYr7URlPSXF6jtqdjBFpDM5AA/JPmZugw6x6WXQgtTv718o/ZL/98AxXW0TTzsLNuyl9HU6orIEuPOQH/6GPDZGbvKKwnNCco8ei2Hlt2sMJzO9R1YCpWAkj2dCzZkMGr599vnvvh/K1RwhMDQq+5RUkXP0cl6jLqEiPGQ51NFN8yl8R3vEhPkxR2Qj+n+fAer5j106TMKjIuhNrtbuDrx7phrd/uGbBKBrDjDkg0iF3Ds4dXqbo8yGoOK/ii7PiKrCTDn8sAX4UJ3vZ8u3s34Nh1Rne/+f8Ry56goIKGbC4obV5Lqd47mRAepnC4lAnhcW6EL3IhgKDbsW9eSkWuZsAq9vTHOSdIWXie+gz0MH1cskAdG7sseYnNhGhNby8Xs8Om73oGNkfcocQcwOJwDG1+lsLiZiaEfm6Er1KyyIbwXW6EtG4s5ka4DQj/AWy4LwOrDAAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected jaxx.runtime.swing.CardLayout2 cardlayout;
    protected java.awt.CardLayout cardlayoutPrincipal;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JPanel factorPanel;
    protected jaxx.runtime.swing.JAXXTree factorsTree;
    protected javax.swing.JPanel inputPane;
    protected javax.swing.JPanel inputPanePrincipal;
    protected jaxx.runtime.swing.JAXXTree navigation;
    protected javax.swing.tree.DefaultTreeSelectionModel navigationSelectionModel;
    protected fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer navigationTreeCellRenderer;
    protected fr.ifremer.isisfish.ui.input.NoneUI noneUI;
    protected fr.ifremer.isisfish.entities.FisheryRegionImpl region;
    private fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel2;
    private javax.swing.JScrollPane $JScrollPane5;
    private javax.swing.JScrollPane $JScrollPane6;
    private javax.swing.JSplitPane $JSplitPane1;
    private javax.swing.JSplitPane $JSplitPane3;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */    
    
    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    protected SimulAction getSimulAction() {
        return getContextValue(SimulAction.class);
    }
    
    protected InputSaveVerifier getVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    
    protected RegionStorage getRegionStorage() {
        return getContextValue(RegionStorage.class);
    }
    
    protected void factorSelected() {
        Object selectedObject = factorsTree.getSelectionValue();
        if (selectedObject != null) {
            if (selectedObject instanceof Factor) {
                Factor<?, ?> selectedFactor = (Factor<?, ?>)selectedObject;
                FactorWizardUI wizard = new FactorWizardUI(this);
                JComponent component = getSimulAction().getFactorComponent(selectedFactor);
                if (component != null) {
                    wizard.initExisting(component, selectedFactor);
                    wizard.pack();
                    wizard.setVisible(true);
                }
                else {
                    
                    // method 2
                    JComponent component2 = EditorHelper.getEditorForFactor(selectedFactor, getRegion().getTopiaContext());
                    if (component2 != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Component found is " + component2);
                        }
                        wizard.initExisting(component2, selectedFactor);
                        wizard.pack();
                        wizard.setVisible(true);
                    }
                    else {
                        if (log.isDebugEnabled()) {
                            log.debug("No component found, skip edition of factor " + selectedFactor.getName());
                        }
                    }
                }
            }
        }
    }
    public void setTreeModel() {
        if (getRegion() != null) {
            getCardlayoutPrincipal().show(inputPanePrincipal,"normale");
            String regionName = getRegion().getName();
            setContextValue(getRegion());
            NavigationTreeModel model = SensitivityNavigationTreeSelectionAdapter.getTreeModel(regionName, getRegion());
    
            setContextValue(model);
            navigation.setModel(model);
            setTreeSelection("$root");
            
            /*TC-20090702 Fix bug #1772
            EC-20090706 no working solution found
            model.nodeChanged(model.getRoot());
            java.util.Enumeration<?> e = model.getRoot().children();
            while (e.hasMoreElements()) {
                NavigationTreeNode n = (NavigationTreeNode) e.nextElement();
                String contextPath = n.getContextPath();
                if (contextPath.equals("$root/$cells")) {
                    //TC-20090702 : ce noeud est trop long a recharger
                    continue;
                }
                log.debug("reload node " + contextPath);
                model.nodeChanged(n);
                java.util.Enumeration<?> e2 = n.children();
                while (e2.hasMoreElements()) {
                    NavigationTreeNode n2 = (NavigationTreeNode) e2.nextElement();
                    n2.getJAXXContextValue(SensitivityTabUI.this);
                }
            }*/
        }
    }
    public void repaintNode(String path) {
        NavigationTreeModel model = getContextValue(NavigationTreeModel.class);
        NavigationTreeNode currentNode = model.findNode(path);
        model.nodeChanged(currentNode);
    }
    public void setTreeSelection(String path) {
        NavigationTreeNode node = NavigationUtil.findNode(this, null, path);
        TreePath pathToRoot = new TreePath(getContextValue(NavigationTreeModel.class).getPathToRoot(node));
        navigation.setSelectionPath(pathToRoot);
        navigation.scrollPathToVisible(pathToRoot);
    }
    protected void setInfoText(String s) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s);
    }
    protected void regionNull() {
        getCardlayoutPrincipal().show(inputPanePrincipal,"none");
        DefaultTreeModel model = new DefaultTreeModel(null);
        navigation.setModel(model);
    }
    public void setFactorModel() {
        java.util.List<Factor<?, ?>> factors = getSimulAction().getFactors();
        FactorTreeModel model = new FactorTreeModel(factors);
        factorsTree.setModel(model);
        factorsTree.setRootVisible(true);
        getParentContainer(SensitivityUI.class).getSensitivityChooserUI().setFactorCardinalityTableModel();
    }
    
    protected void deleteSelectedFactors() {
        Object selectedObject = factorsTree.getSelectionValue();
        
        if (selectedObject != null) {
            if (selectedObject instanceof Factor) {
                Factor<?, ?> selectedFactor = (Factor<?, ?>)selectedObject;
                if (log.isDebugEnabled()) {
                    log.debug("Deleting factor " + selectedFactor.getName());
                }
                getSimulAction().removeFactor(selectedFactor);
                setFactorModel();
            }
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SensitivityTabUI() {
        $initialize();
    }

    public SensitivityTabUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public jaxx.runtime.swing.CardLayout2 getCardlayout() {
        return cardlayout;
    }

    public java.awt.CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public javax.swing.JPanel getFactorPanel() {
        return factorPanel;
    }

    public jaxx.runtime.swing.JAXXTree getFactorsTree() {
        return factorsTree;
    }

    public javax.swing.JPanel getInputPane() {
        return inputPane;
    }

    public javax.swing.JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public jaxx.runtime.swing.JAXXTree getNavigation() {
        return navigation;
    }

    public javax.swing.tree.DefaultTreeSelectionModel getNavigationSelectionModel() {
        return navigationSelectionModel;
    }

    public fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer getNavigationTreeCellRenderer() {
        return navigationTreeCellRenderer;
    }

    public fr.ifremer.isisfish.ui.input.NoneUI getNoneUI() {
        return noneUI;
    }

    public fr.ifremer.isisfish.entities.FisheryRegionImpl getRegion() {
        return region;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setRegion(fr.ifremer.isisfish.entities.FisheryRegionImpl newValue) {
        fr.ifremer.isisfish.entities.FisheryRegionImpl oldValue = this.region;
        this.region = newValue;
        firePropertyChange("region", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected javax.swing.JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected javax.swing.JSplitPane get$JSplitPane3() {
        return $JSplitPane3;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add($JSplitPane1, BorderLayout.CENTER);
        
        $JSplitPane1.add($JPanel2, JSplitPane.LEFT);
        $JSplitPane1.add(inputPanePrincipal, JSplitPane.RIGHT);
        
        $JPanel2.add($JSplitPane3, BorderLayout.CENTER);
        
        $JSplitPane3.add($Table4, JSplitPane.LEFT);
        $JSplitPane3.add(factorPanel, JSplitPane.RIGHT);
        
        $Table4.add($JScrollPane5, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane5.getViewport().add(navigation);
        
        addChildrenToFactorPanel();
        $JScrollPane6.getViewport().add(factorsTree);
        
        addChildrenToInputPanePrincipal();
        navigationSelectionModel.setSelectionMode((javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION));
        navigation.setCellRenderer((getNavigationTreeCellRenderer()));
        navigation.setModel((new DefaultTreeModel(null)));
        navigation.setSelectionModel((getNavigationSelectionModel()));
        factorsTree.setCellRenderer((new FactorTreeCellRenderer()));
        factorsTree.setModel((new DefaultTreeModel(null)));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createNavigationSelectionModel();
        createNavigationTreeCellRenderer();
        createCardlayout();
        createCardlayoutPrincipal();
        createRegion();
        
        $JSplitPane1 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane1", $JSplitPane1);
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setDividerLocation(200);
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setOrientation(1);
        
        $JPanel2 = new javax.swing.JPanel();
        $objectMap.put("$JPanel2", $JPanel2);
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout((new BorderLayout()));
        
        $JSplitPane3 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane3", $JSplitPane3);
        $JSplitPane3.setName("$JSplitPane3");
        $JSplitPane3.setDividerLocation(400);
        $JSplitPane3.setOneTouchExpandable(true);
        $JSplitPane3.setOrientation(0);
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        $JScrollPane5 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane5", $JScrollPane5);
        $JScrollPane5.setName("$JScrollPane5");
        
        createNavigation();
        createFactorPanel();
        
        $JScrollPane6 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane6", $JScrollPane6);
        $JScrollPane6.setName("$JScrollPane6");
        
        createFactorsTree();
        createInputPanePrincipal();
        createNoneUI();
        createInputPane();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        // end code constructor
        getVerifier().setSensPanel(this);new fr.ifremer.isisfish.ui.sensitivity.SensitivityNavigationTreeSelectionAdapter(this);factorsTree.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                // clic droit
                if (e.getButton() == MouseEvent.BUTTON3) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem menuItemDelete = new JMenuItem(_("isisfish.common.delete"));
                    menuItemDelete.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            deleteSelectedFactors();
                        }
                    });
                    menu.add(menuItemDelete);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                else {
                    // autre clic
                    factorSelected();
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToFactorPanel() {
        if (!allComponentsCreated) {
            return;
        }
        factorPanel.add($JScrollPane6, BorderLayout.CENTER);
    }

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add(noneUI, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void createCardlayout() {
        cardlayout = new jaxx.runtime.swing.CardLayout2();
        $objectMap.put("cardlayout", cardlayout);
    }

    protected void createCardlayoutPrincipal() {
        cardlayoutPrincipal = new java.awt.CardLayout();
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal);
    }

    protected void createFactorPanel() {
        factorPanel = new javax.swing.JPanel();
        $objectMap.put("factorPanel", factorPanel);
        factorPanel.setName("factorPanel");
        factorPanel.setLayout((new BorderLayout()));
        factorPanel.setName("factorPanel");
    }

    protected void createFactorsTree() {
        factorsTree = new jaxx.runtime.swing.JAXXTree();
        $objectMap.put("factorsTree", factorsTree);
        factorsTree.setName("factorsTree");
        factorsTree.setRootVisible(true);
        factorsTree.setSelectionRow(0);
    }

    protected void createInputPane() {
        inputPane = new javax.swing.JPanel();
        $objectMap.put("inputPane", inputPane);
        inputPane.setName("inputPane");
        inputPane.setLayout((getCardlayout()));
    }

    protected void createInputPanePrincipal() {
        inputPanePrincipal = new javax.swing.JPanel();
        $objectMap.put("inputPanePrincipal", inputPanePrincipal);
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout((getCardlayoutPrincipal()));
    }

    protected void createNavigation() {
        navigation = new jaxx.runtime.swing.JAXXTree();
        $objectMap.put("navigation", navigation);
        navigation.setName("navigation");
        navigation.setRootVisible(true);
        navigation.setSelectionRow(0);
    }

    protected void createNavigationSelectionModel() {
        navigationSelectionModel = new javax.swing.tree.DefaultTreeSelectionModel();
        $objectMap.put("navigationSelectionModel", navigationSelectionModel);
    }

    protected void createNavigationTreeCellRenderer() {
        navigationTreeCellRenderer =  new fr.ifremer.isisfish.ui.input.InputNavigationTreeCellRenderer(this);
        $objectMap.put("navigationTreeCellRenderer", navigationTreeCellRenderer);
    }

    protected void createNoneUI() {
        noneUI = new fr.ifremer.isisfish.ui.input.NoneUI();
        $objectMap.put("noneUI", noneUI);
        noneUI.removeDataBinding("$JPanel0.name");
        
        noneUI.setName("noneUI");
    }

    protected void createRegion() {
        region = null;
        $objectMap.put("region", region);
    }

}
