/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import java.util.ArrayList;
import java.io.File;
import org.nuiton.util.FileUtil;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.models.simulation.SimulationNamesComboModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivitySecondPassUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUzU8TQRR/rbTlwyoIfhw0VCEaD279OJgAQQFDhBQlFBNiL067UzpkujvuvIXlYky8GsPJgxf17tG7MR49efV/MMb/wDfTj22hQYJ7mNm8nd/v/d6b39tPvyClA7i8xaLICUIPRZ07y3MbG4/LW7yCD7iuBEKhH0DjSSQhWYIhtx3XCBOlgoHnm/D8gl9Xvse9DvR0AQY17kqua5wjwtkGoqJ1vtgOT0cqDFpsbTG92D78+Z3cc19+TAJEilSlqYTcv1BxBX0FSAoX4Qxl2mZ5ybxNkhEIb5N0Zk1sQTKtH7E6fw4vIFOAtGIBkSFcOXqplsPiI4WQmVxnZclvIkxVA0dUA17ntGuhq0LXnFA4mntaoNgWuOsU4/cir/ieu0pcT5aUsoRphFxVcOl2HhP1UDIUvlfkkm4OYbyrIXqHyrM3S5rL/rwfGaaBNuEoHYxTzYeIvkdR04yoBW5Eu3HnXaGVZLv7sebzSPfR7ORysRL4Uq4yj98iaBd5/KkbNYE8wrmAswM9UZRsjetQGkN1ca03IYZiTJE5Rm0vyG5ObLfYD4kSpIKQwgjDpdiZaxRqeLIZtQQ2+v7Vu+23n79MtQyYoRzZriMd80KGUIGveIDCpDjdcF2IQuZXmJouwYC2V2aHaaxDQLEZJhHEP2JgjoE5D5muETSV+fn127lnP05AchEGpc/cRWbOL8EA1gKq0pdupO7dt0pO7vTTOmw0IaTqvsslwqkZlyHLlYXnUuNmI6p1rKPWtoDve69XLr65dLdVb6KhZ9+xuObUU0gLTwqP21FrTlHP0RpSmoeuH09Lr/lJmD2rmv4ft+tEr8Iy3DNjZjNejUKzXbN6zdt1SzN8BJo+Yzr6Qcw0isgxpN9DOUQ+e1xOE75xiKrRIzHcNsud4zIg9HNXoGnQITwX/luJYfgLrzLM2VkGAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JButton displaySecondPassButton;
    protected jaxx.runtime.swing.JAXXComboBox fieldSensitivitySimulationSelect;
    protected javax.swing.JButton runSecondPassButton;
    protected javax.swing.JTextArea textAreaSensitivitySecondpassResult;
    private javax.swing.JScrollPane $JScrollPane1;
    private fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource2 = new jaxx.runtime.DataBindingListener($Table0, "fieldSensitivitySimulationSelect.model");
    private java.beans.PropertyChangeListener $DataSource3 = new jaxx.runtime.DataBindingListener($Table0, "runSecondPassButton.enabled");
    private java.beans.PropertyChangeListener $DataSource4 = new jaxx.runtime.DataBindingListener($Table0, "displaySecondPassButton.enabled");

    /* begin raw body code */
    // declaration sépérée de la variable d'instance (jaxx)
        SimulationServiceListener simulationListener;
    
    
        /**
         * Model de contenu de la liste des nom de simulations
         */
        public ComboBoxModel getSensitivitySimulationModel() {
            java.util.List<String> asNames = new ArrayList<String>();
            for (String simulationName : SimulationStorage.getSimulationNames()) {
                if (simulationName.startsWith("as_")) {
                    String masterSensitivityName = simulationName.substring(0, simulationName.lastIndexOf("_"));
                    if (!asNames.contains(masterSensitivityName)) {
                        asNames.add(masterSensitivityName);
                    }
                }
            }
            
            SimulationNamesComboModel model = new SimulationNamesComboModel(asNames);
            return model;
        }
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
    
        protected void launchSecondPass(ActionEvent event) {
            if (fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
                getSimulAction().runSensitivitySecondPass((String)fieldSensitivitySimulationSelect.getSelectedItem());
                displaySensitivitySecondPass(event);
            }
        }
    
        protected void displaySensitivitySecondPass(ActionEvent event) {
            if (fieldSensitivitySimulationSelect.getSelectedIndex() != -1) {
            
                try {
                    String selectedSimulationName = (String)fieldSensitivitySimulationSelect.getSelectedItem();
                    java.util.List<File> files = getSimulAction().getSensitivitySecondPassResults(selectedSimulationName);
                    
                    String content = "";
                    for(File file : files) {
                        content += "Fichier " + file.getName() + "\n";
                        content += "------------------------------\n";
                        content += FileUtil.readAsString(file) + "\n";
                        content += "\n";
                    }
                    textAreaSensitivitySecondpassResult.setText(content);
                }
                catch(IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't run second pass", e);
                    }
                }
            }
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SensitivitySecondPassUI() {
        $initialize();
    }

    public SensitivitySecondPassUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldSensitivitySimulationSelect.model".equals($binding)) {
                addPropertyChangeListener("sensitivitySimulationModel", $DataSource2);
        
        } else if ("runSecondPassButton.enabled".equals($binding)) {
            if (fieldSensitivitySimulationSelect != null) {
                $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
        fieldSensitivitySimulationSelect.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, $Table0, "$pr$u0"));
            }
        } else if ("displaySecondPassButton.enabled".equals($binding)) {
            if (fieldSensitivitySimulationSelect != null) {
                $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
        fieldSensitivitySimulationSelect.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, $Table0, "$pr$u1"));
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldSensitivitySimulationSelect.model".equals($dest)) {
            fieldSensitivitySimulationSelect.setModel((getSensitivitySimulationModel()));
            } else if ("runSecondPassButton.enabled".equals($dest)) {
            if (fieldSensitivitySimulationSelect != null) {
                runSecondPassButton.setEnabled((fieldSensitivitySimulationSelect.getSelectedItem() != null));
            }
            } else if ("displaySecondPassButton.enabled".equals($dest)) {
            if (fieldSensitivitySimulationSelect != null) {
                displaySecondPassButton.setEnabled((fieldSensitivitySimulationSelect.getSelectedItem() != null));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldSensitivitySimulationSelect.model".equals($binding)) {
                removePropertyChangeListener("sensitivitySimulationModel", $DataSource2);
        
        } else if ("runSecondPassButton.enabled".equals($binding)) {
            if (fieldSensitivitySimulationSelect != null) {
                ((jaxx.runtime.swing.JAXXComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect")).removeItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, $Table0, "$pr$u0"));
            }
        } else if ("displaySecondPassButton.enabled".equals($binding)) {
            if (fieldSensitivitySimulationSelect != null) {
                ((jaxx.runtime.swing.JAXXComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect")).removeItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, $Table0, "$pr$u1"));
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__displaySecondPassButton(java.awt.event.ActionEvent event) {
        displaySensitivitySecondPass(event);
    }

    public void doActionPerformed__on__runSecondPassButton(java.awt.event.ActionEvent event) {
        launchSecondPass(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getDisplaySecondPassButton() {
        return displaySecondPassButton;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSensitivitySimulationSelect() {
        return fieldSensitivitySimulationSelect;
    }

    public javax.swing.JButton getRunSecondPassButton() {
        return runSecondPassButton;
    }

    public javax.swing.JTextArea getTextAreaSensitivitySecondpassResult() {
        return textAreaSensitivitySecondpassResult;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ItemEvent event) {
        $DataSource3.propertyChange(null);
    }

    public void $pr$u1(java.awt.event.ItemEvent event) {
        $DataSource4.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected fr.ifremer.isisfish.ui.sensitivity.SensitivitySecondPassUI get$Table0() {
        return $Table0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add(fieldSensitivitySimulationSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(runSecondPassButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(displaySecondPassButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane1.getViewport().add(textAreaSensitivitySecondpassResult);
        
        applyDataBinding("fieldSensitivitySimulationSelect.model");
        applyDataBinding("runSecondPassButton.enabled");
        applyDataBinding("displaySecondPassButton.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createFieldSensitivitySimulationSelect();
        createRunSecondPassButton();
        createDisplaySecondPassButton();
        
        $JScrollPane1 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane1", $JScrollPane1);
        $JScrollPane1.setName("$JScrollPane1");
        
        createTextAreaSensitivitySecondpassResult();
        $Table0.setName("$Table0");
        
        
        // permet de rafaichir la liste les simulations
            // des qu'une simulation se termine
            simulationListener = new SimulationServiceListener() {
                @Override
                public void simulationStart(SimulationService simService, SimulationJob job) {
                }
            
                @Override
                public void simulationStop(SimulationService simService, SimulationJob job) {
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh second pass UI simulations list");
                    }
                    fieldSensitivitySimulationSelect.setModel(getSensitivitySimulationModel());
                }
            
                @Override
                public void clearJobDone(SimulationService simService) {
                }
            };SimulationService.getService().addSimulationServiceListener(simulationListener);
        $completeSetup();
    }

    protected void createDisplaySecondPassButton() {
        displaySecondPassButton = new javax.swing.JButton();
        $objectMap.put("displaySecondPassButton", displaySecondPassButton);
        displaySecondPassButton.setName("displaySecondPassButton");
        displaySecondPassButton.setText(_("isisfish.sensitivity.displaysecondpass"));
        displaySecondPassButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__displaySecondPassButton"));
    }

    protected void createFieldSensitivitySimulationSelect() {
        fieldSensitivitySimulationSelect = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
        fieldSensitivitySimulationSelect.setName("fieldSensitivitySimulationSelect");
    }

    protected void createRunSecondPassButton() {
        runSecondPassButton = new javax.swing.JButton();
        $objectMap.put("runSecondPassButton", runSecondPassButton);
        runSecondPassButton.setName("runSecondPassButton");
        runSecondPassButton.setText(_("isisfish.sensitivity.secondpass"));
        runSecondPassButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__runSecondPassButton"));
    }

    protected void createTextAreaSensitivitySecondpassResult() {
        textAreaSensitivitySecondpassResult = new javax.swing.JTextArea();
        $objectMap.put("textAreaSensitivitySecondpassResult", textAreaSensitivitySecondpassResult);
        textAreaSensitivitySecondpassResult.setName("textAreaSensitivitySecondpassResult");
        textAreaSensitivitySecondpassResult.setColumns(15);
        textAreaSensitivitySecondpassResult.setLineWrap(true);
        textAreaSensitivitySecondpassResult.setWrapStyleWord(true);
        textAreaSensitivitySecondpassResult.setEditable(false);
        jaxx.runtime.SwingUtil.setText(textAreaSensitivitySecondpassResult, "");
    }

}
