/*
 * #%L
 * IsisFish
 * 
 * $Id: FactorTreeModel.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.sensitivity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;

/**
 * Cette classe gere l'affichage d'une liste de facteurs dans l'arbre.
 * 
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2008-06-13 11:05:57 +0200 (ven., 13 juin 2008)
 * $ By : $Author: chatellier $
 */
public class FactorTreeModel implements TreeModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 593284613450915826L;

    /** Tree model root. */
    protected List<Factor<?,?>> factorsList;
    
    /** Tree model listeners. */
    protected Collection<TreeModelListener> modelListeners;

    /**
     * Constructor.
     * 
     * @param factorsList factors list
     */
    public FactorTreeModel(List<Factor<?,?>> factorsList) {
        this.factorsList = factorsList;
        modelListeners = new ArrayList<TreeModelListener>();
    }

    /*
     * @see javax.swing.tree.TreeModel#getChild(java.lang.Object, int)
     */
    @Override
    public Object getChild(Object parent, int index) {

        Object value = null;

        if (parent instanceof List) {
            List<Factor<?,?>> factors = (List<Factor<?,?>>)parent;
            value = factors.get(index);
        }

        return value;
    }

    /*
     * @see javax.swing.tree.TreeModel#getChildCount(java.lang.Object)
     */
    @Override
    public int getChildCount(Object parent) {

        int childCount = 0;

        if (parent instanceof List) {
            List<Factor<?,?>> factors = (List<Factor<?,?>>)parent;
            childCount = factors.size();
        }

        return childCount;
    }

    /*
     * @see javax.swing.tree.TreeModel#getIndexOfChild(java.lang.Object, java.lang.Object)
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {

        int childIndex = -1;

        if (parent instanceof List) {
            List<Factor<?,?>> factors = (List<Factor<?,?>>)parent;
            childIndex = factors.indexOf(child);
        }

        return childIndex;
    }

    /*
     * @see javax.swing.tree.DefaultTreeModel#isLeaf(java.lang.Object)
     */
    @Override
    public boolean isLeaf(Object node) {
        return getChildCount(node) == 0;
    }

    /*
     * @see javax.swing.tree.TreeModel#addTreeModelListener(javax.swing.event.TreeModelListener)
     */
    @Override
    public void addTreeModelListener(TreeModelListener l) {
        modelListeners.add(l);
    }

    /*
     * @see javax.swing.tree.TreeModel#getRoot()
     */
    @Override
    public Object getRoot() {
        return factorsList;
    }

    /*
     * @see javax.swing.tree.TreeModel#removeTreeModelListener(javax.swing.event.TreeModelListener)
     */
    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        modelListeners.remove(l);
    }

    /*
     * @see javax.swing.tree.TreeModel#valueForPathChanged(javax.swing.tree.TreePath, java.lang.Object)
     */
    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new RuntimeException("Not implemented");
    }

}
