/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.sensitivity.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class EquationContinuousPanelUI extends fr.ifremer.isisfish.ui.sensitivity.ContinuousPanelContainerUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRR+ceuY/kgT0vDj0IoUglQJtIaWqhKJAm1IVFcurUiDKnxox95xMtV6Zjrz1t3kgJC4ItRTD720vffIHSGOnLjyPyDEf8Cb2bXXcYxtdX2Ytd9+73vvm/fmjV/9DWVr4MJDliSBiSWKDg9uXrt373bzIW/hV9y2jNCoDKSfmRKUGnAq7NstwgeNunOvZu7VDdXRSnI54L1ah5MW9yNu9zhHhLdSj5a11e2+eTXRsemx9ZMZxfbi339KT8IfXpYAEk1ZLZKE5UleuYLjdSiJEGGRInVZNWJyl9IwQu5SnnPOthExa79mHf4IvodKHWY1M0SG8P70Uj2H9080wrmVDUU+MlaxvcMkj9xPJiQ3O7VPENbaJhBtwzucnlbYtrB7QSwCy6UVKLoC94PNRzFDoeQQ0U5Nax9nFuE48oSyXHAaAqcrSHUNIJqcSYSLyuwGMhaoZIBKCxZobiguctniwV1n2aQouJ97nnaed4wiIO4725n8XbkVsYMDhPk8sJefI+bbynRi2hWGfFeZYYIFyyPqNx72RCJ8OGpLuEtKcNvfjJyikkVAWBnruZXCcsezK9u+djVJABaJA24+RXjP91OLCiwi4jkCGet/yb26MBZyeTLksyFIpUX74tvw3UPNbh9TiYO7rDmoam7lJhGqKHJNcgXhHVeaJMMOvHLwi30v1+isQ4d68RDcczvIR33kMRbSETp7CHY9RmqoIUaqg+p658tDb3hI/WcQqv/T/ELqGIOaW29L3qv4Ti2jMS66q5G1QT5F8mM+04CyoUqTmoVGPnC+IVM6ajKrJ/DW5z8+6z795dfPe3NliWLMHYIMjEE65zo9DcKFmE+HSYwiqt5ierUBJ9Ke9jNyaSCB7cxMSRD/m/7IOLfgBrN75Fqu/PXb728/+PMYlLbgZKRYuMUcvgYncM+QShWFif7iS5/J6cdv0LrgcqKaa8Pb3BgeblP/IJxZCxmy5aaQIdVnPSHNSwOa+4n88eSnW+d+Pn+1p3smzWsIlmsvfwezQkY0vfwkzYbkyMl5SlsehyofhqPG44x7fqyz5l336/VRAitcuk70ETeT2D22fL7u2w1PU52CptxRIY8KklS61KvZsXhtGmeuj2G4NEUi2dBfXEtLssyQZn4zRr7+upzO/G2hrCbpujIVw323PCjCME7FZAbqFDp5oj2G5Oo0BXI3Z0GOI7dvAa70ti5EMqm+06TRu7AL0oz6Z1GA7sg/kcL7dL8ww7gudgz/ATGT6JTGCwAA";
    protected javax.swing.JButton add;
    protected org.nuiton.topia.persistence.TopiaEntity bean;
    protected java.lang.String beanProperty;
    protected java.lang.Class clazz;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI editor;
    protected fr.ifremer.isisfish.entities.Formule formule;
    protected java.lang.String formuleCategory;
    protected javax.swing.JTable params;
    protected javax.swing.JButton remove;
    protected fr.ifremer.isisfish.entities.Equation selectedEquation;
    protected java.lang.String text;
    private fr.ifremer.isisfish.ui.sensitivity.EquationContinuousPanelUI $ContinuousPanelContainerUI0 = this;
    private javax.swing.JScrollPane $JScrollPane5;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "add.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "add.visible");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "remove.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "remove.visible");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.actif");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.bean");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.beanProperty");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.clazz");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.formule");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.formuleCategory");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.selectedEquation");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.text");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "editor.visible");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "params.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "params.model");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($ContinuousPanelContainerUI0, "params.visible");

    /* begin raw body code */
    protected String[] columnNames;
    protected java.util.List<EquationContinuousDomain> datas;
    protected java.util.List<JComboBox> operateurs;
    protected java.util.List<JButton> actions;
    
    
    public java.util.List<EquationContinuousDomain> getDomains(){
        return datas;
    }
    
    public void setDomains(java.util.List<EquationContinuousDomain> domains){
        datas.clear();
        for (EquationContinuousDomain d : domains){
            addDomain(d);
        }
    }
    
    public void addDomain(EquationContinuousDomain domain){
        newButton();
        datas.add(domain);
    }
    
    protected AbstractTableModel getTableModel() {
        AbstractTableModel model = new AbstractTableModel() {
            @Override
            public int getRowCount() {
                return datas.size();
            }
    
            @Override
            public int getColumnCount() {
                return columnNames.length;
            }
    
            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
            
            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return datas.get(rowIndex).getVariableName();
                } else if (columnIndex == 1) {
                    return datas.get(rowIndex).getReferenceValue();
                } else if (columnIndex == 2) {
                    Double result = datas.get(rowIndex).getCoefficient() * 100;
                    return result;
                } else if (columnIndex == 3) {
                    return datas.get(rowIndex).getOperator();
                } else if (columnIndex == 4) {
                    return _("isisfish.sensitivity.validDiscretNumber");
                }
                return null;
            }
    
            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (String.class.isInstance(aValue)) {
                    if (!((String)aValue).equals("")) {
                        if (columnIndex == 0){
                            datas.get(rowIndex).setVariableName((String)aValue);
                        } else if (columnIndex == 1) {
                            datas.get(rowIndex).setReferenceValue(Double.parseDouble((String)aValue));
                        } else if (columnIndex == 2) {
                            datas.get(rowIndex).setCoefficient(Double.parseDouble((String)aValue) / 100);
                        } else if (columnIndex == 3) {
                            datas.get(rowIndex).setOperator((String)aValue);
                        }
                    }
                }
            }
    
            @Override
            public String getColumnName(int col) {
                return columnNames[col].toString();
            }
    
        };
        return model;
    }
    protected JComboBox getOperateur(){
        JComboBox result = new JComboBox();
        result.addItem("+");
        result.addItem("-");
        result.addItem("*");
        result.addItem("/");
        operateurs.add(result);
        result.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                int i = operateurs.indexOf(source);
                if (datas.size() <= i){
                    datas.get(i).setOperator((String)source.getSelectedItem());
                }
            }
        });
        return result;
    }
    protected void newButton(){
        JButton result = new JButton();
        result.setText(_("isisfish.sensitivity.validDiscretNumber"));
        actions.add(result);
        result.addActionListener(new ActionListener() {
    
            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                int i = actions.indexOf(source);
                valid(i);
            }
        });
    }
    protected JButton getActionButton(int i){
        return actions.get(i);
    }
    protected void valid(int i) {
        String variableName = datas.get(i).getVariableName();
        String[] lines = editor.getEditor().getText().split("\n");
        String result = "";
        for (String line : lines) {
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(line);
            if (matcher.find()) {
                String fullVariableName = bean.toString() + "." + StringUtils.uncapitalize(beanProperty) + "." + variableName;
                line = matcher.group(1) +  "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result += line + "\n";
        }
        editor.getEditor().setText(result);
    }
    protected void setTable(){
        params.setModel(getTableModel());
        // poussin 20090512, marche pas, impossible d'affiche la combo dans l'interface:
        // chatellier , si mais seulement en edition
        params.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(getOperateur()));
        params.getColumnModel().getColumn(4).setCellEditor(new TableCellEditor() {
    
            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return getActionButton(row);
            }
    
            @Override
            public Object getCellEditorValue() {
                return null;
            }
    
            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }
    
            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }
    
            @Override
            public boolean stopCellEditing() {
                return true;
            }
    
            @Override
            public void cancelCellEditing() {
            }
    
            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }
    
            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }
        });
    }
    protected void add() {
        EquationContinuousDomain domain = new EquationContinuousDomain();
        // fixe NPE in table model renderer
        domain.setCoefficient(1.0);
        datas.add(domain);
        newButton();
        setTable();
    }
    protected void remove() {
        int i = params.getSelectedRow();
        if (i != -1){
            datas.remove(i);
            operateurs.remove(i);
            actions.remove(i);
            setTable();
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public EquationContinuousPanelUI() {
        super();
        $initialize();
    }

    public EquationContinuousPanelUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("params.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continueSelected", $DataSource7);
            }
        } else if ("params.model".equals($binding)) {
                addPropertyChangeListener("tableModel", $DataSource8);
        
        } else if ("params.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continuePossible", $DataSource9);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continueSelected", $DataSource10);
            }
        } else if ("add.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continuePossible", $DataSource11);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continueSelected", $DataSource12);
            }
        } else if ("remove.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continuePossible", $DataSource13);
            }
        } else if ("editor.actif".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continueSelected", $DataSource14);
            }
        } else if ("editor.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource15);
        
        } else if ("editor.beanProperty".equals($binding)) {
                addPropertyChangeListener("beanProperty", $DataSource16);
        
        } else if ("editor.clazz".equals($binding)) {
                addPropertyChangeListener("clazz", $DataSource17);
        
        } else if ("editor.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continueSelected", $DataSource18);
            }
        } else if ("editor.formule".equals($binding)) {
                addPropertyChangeListener("formule", $DataSource19);
        
        } else if ("editor.formuleCategory".equals($binding)) {
                addPropertyChangeListener("formuleCategory", $DataSource20);
        
        } else if ("editor.selectedEquation".equals($binding)) {
                addPropertyChangeListener("selectedEquation", $DataSource21);
        
        } else if ("editor.text".equals($binding)) {
                addPropertyChangeListener("text", $DataSource22);
        
        } else if ("editor.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.addPropertyChangeListener("continuePossible", $DataSource23);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("params.enabled".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                params.setEnabled((isContinueSelected()));
            }
            } else if ("params.model".equals($dest)) {
            params.setModel((getTableModel()));
            } else if ("params.visible".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                params.setVisible((isContinuePossible()));
            }
            } else if ("add.enabled".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                add.setEnabled((isContinueSelected()));
            }
            } else if ("add.visible".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                add.setVisible((isContinuePossible()));
            }
            } else if ("remove.enabled".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                remove.setEnabled((isContinueSelected()));
            }
            } else if ("remove.visible".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                remove.setVisible((isContinuePossible()));
            }
            } else if ("editor.actif".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                editor.setActif((isContinueSelected()));
            }
            } else if ("editor.bean".equals($dest)) {
            editor.setBean((getBean()));
            } else if ("editor.beanProperty".equals($dest)) {
            editor.setBeanProperty(String.valueOf((getBeanProperty())));
            } else if ("editor.clazz".equals($dest)) {
            editor.setClazz((getClazz()));
            } else if ("editor.enabled".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                editor.setEnabled((isContinueSelected()));
            }
            } else if ("editor.formule".equals($dest)) {
            editor.setFormule((getFormule()));
            } else if ("editor.formuleCategory".equals($dest)) {
            editor.setFormuleCategory(String.valueOf((getFormuleCategory())));
            } else if ("editor.selectedEquation".equals($dest)) {
            editor.setSelectedEquation((getSelectedEquation()));
            } else if ("editor.text".equals($dest)) {
            editor.setText(_(String.valueOf((getText()))));
            } else if ("editor.visible".equals($dest)) {
            if ($ContinuousPanelContainerUI0 != null) {
                editor.setVisible((isContinuePossible()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("params.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continueSelected", $DataSource7);
            }
        } else if ("params.model".equals($binding)) {
                removePropertyChangeListener("tableModel", $DataSource8);
        
        } else if ("params.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continuePossible", $DataSource9);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continueSelected", $DataSource10);
            }
        } else if ("add.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continuePossible", $DataSource11);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continueSelected", $DataSource12);
            }
        } else if ("remove.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continuePossible", $DataSource13);
            }
        } else if ("editor.actif".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continueSelected", $DataSource14);
            }
        } else if ("editor.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource15);
        
        } else if ("editor.beanProperty".equals($binding)) {
                removePropertyChangeListener("beanProperty", $DataSource16);
        
        } else if ("editor.clazz".equals($binding)) {
                removePropertyChangeListener("clazz", $DataSource17);
        
        } else if ("editor.enabled".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continueSelected", $DataSource18);
            }
        } else if ("editor.formule".equals($binding)) {
                removePropertyChangeListener("formule", $DataSource19);
        
        } else if ("editor.formuleCategory".equals($binding)) {
                removePropertyChangeListener("formuleCategory", $DataSource20);
        
        } else if ("editor.selectedEquation".equals($binding)) {
                removePropertyChangeListener("selectedEquation", $DataSource21);
        
        } else if ("editor.text".equals($binding)) {
                removePropertyChangeListener("text", $DataSource22);
        
        } else if ("editor.visible".equals($binding)) {
            if ($ContinuousPanelContainerUI0 != null) {
                $ContinuousPanelContainerUI0.removePropertyChangeListener("continuePossible", $DataSource23);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAdd() {
        return add;
    }

    public org.nuiton.topia.persistence.TopiaEntity getBean() {
        return bean;
    }

    public java.lang.String getBeanProperty() {
        return beanProperty;
    }

    public java.lang.Class getClazz() {
        return clazz;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getEditor() {
        return editor;
    }

    public fr.ifremer.isisfish.entities.Formule getFormule() {
        return formule;
    }

    public java.lang.String getFormuleCategory() {
        return formuleCategory;
    }

    public javax.swing.JTable getParams() {
        return params;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public fr.ifremer.isisfish.entities.Equation getSelectedEquation() {
        return selectedEquation;
    }

    public java.lang.String getText() {
        return text;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(org.nuiton.topia.persistence.TopiaEntity newValue) {
        org.nuiton.topia.persistence.TopiaEntity oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setBeanProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.beanProperty;
        this.beanProperty = newValue;
        firePropertyChange("beanProperty", oldValue, newValue);
    }

    public void setClazz(java.lang.Class newValue) {
        java.lang.Class oldValue = this.clazz;
        this.clazz = newValue;
        firePropertyChange("clazz", oldValue, newValue);
    }

    public void setFormule(fr.ifremer.isisfish.entities.Formule newValue) {
        fr.ifremer.isisfish.entities.Formule oldValue = this.formule;
        this.formule = newValue;
        firePropertyChange("formule", oldValue, newValue);
    }

    public void setFormuleCategory(java.lang.String newValue) {
        java.lang.String oldValue = this.formuleCategory;
        this.formuleCategory = newValue;
        firePropertyChange("formuleCategory", oldValue, newValue);
    }

    public void setSelectedEquation(fr.ifremer.isisfish.entities.Equation newValue) {
        fr.ifremer.isisfish.entities.Equation oldValue = this.selectedEquation;
        this.selectedEquation = newValue;
        firePropertyChange("selectedEquation", oldValue, newValue);
    }

    public void setText(java.lang.String newValue) {
        java.lang.String oldValue = this.text;
        this.text = newValue;
        firePropertyChange("text", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.sensitivity.EquationContinuousPanelUI get$ContinuousPanelContainerUI0() {
        return $ContinuousPanelContainerUI0;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        
        
        
        addChildrenToContent();
        $JScrollPane5.getViewport().add(params);
        
        $JScrollPane5.setPreferredSize((new Dimension(200, 150)));
        applyDataBinding("params.enabled");
        applyDataBinding("params.model");
        applyDataBinding("params.visible");
        applyDataBinding("add.enabled");
        applyDataBinding("add.visible");
        applyDataBinding("remove.enabled");
        applyDataBinding("remove.visible");
        applyDataBinding("editor.actif");
        applyDataBinding("editor.bean");
        applyDataBinding("editor.beanProperty");
        applyDataBinding("editor.clazz");
        applyDataBinding("editor.enabled");
        applyDataBinding("editor.formule");
        applyDataBinding("editor.formuleCategory");
        applyDataBinding("editor.selectedEquation");
        applyDataBinding("editor.text");
        applyDataBinding("editor.visible");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$ContinuousPanelContainerUI0", this);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormuleCategory();
        createSelectedEquation();
        createFormule();
        create$ScriptInitializer1();
        
        datas = new ArrayList<EquationContinuousDomain>();
        
        operateurs = new ArrayList<JComboBox>();
        
        actions = new ArrayList<JButton>();
        
        $JScrollPane5 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane5", $JScrollPane5);
        $JScrollPane5.setName("$JScrollPane5");
        
        createParams();
        createAdd();
        createRemove();
        createEditor();
        $ContinuousPanelContainerUI0.removeDataBinding("continuousPanelContainer.name");
        
        $ContinuousPanelContainerUI0.setName("$ContinuousPanelContainerUI0");
        
        
        
        
        
        
        $completeSetup();
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($JScrollPane5, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        content.add(add, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        content.add(remove, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        content.add(editor, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$ScriptInitializer1() {
        columnNames = new java.lang.String[] {
            _("isisfish.sensitivity.equation.variable.name"),
            _("isisfish.sensitivity.equation.variable.value"),
            _("isisfish.sensitivity.equation.variable.coefficient"),
            _("isisfish.sensitivity.equation.variable.operator"),
            _("isisfish.sensitivity.equation.variable.action")};
    }

    protected void createAdd() {
        add = new javax.swing.JButton();
        $objectMap.put("add", add);
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $ContinuousPanelContainerUI0, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBeanProperty() {
        beanProperty = null;
        $objectMap.put("beanProperty", beanProperty);
    }

    protected void createClazz() {
        clazz = null;
        $objectMap.put("clazz", clazz);
    }

    protected void createContent() {
        content = new jaxx.runtime.swing.Table();
        $objectMap.put("content", content);
        content.setName("content");
    }

    protected void createEditor() {
        editor =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("editor", editor);
        editor.removeDataBinding("$InputContentUI0.name");
        
        editor.setName("editor");
        editor.removeDataBinding("$InputContentUI0.actif");
        
        editor.removeDataBinding("$InputContentUI0.bean");
        
        editor.removeDataBinding("$InputContentUI0.beanProperty");
        
        editor.removeDataBinding("$InputContentUI0.clazz");
        
        editor.removeDataBinding("$InputContentUI0.enabled");
        
        editor.removeDataBinding("$InputContentUI0.formule");
        
        editor.removeDataBinding("$InputContentUI0.formuleCategory");
        
        editor.removeDataBinding("$InputContentUI0.selectedEquation");
        
        editor.removeDataBinding("$InputContentUI0.text");
        
        editor.removeDataBinding("$InputContentUI0.visible");
    }

    protected void createFormule() {
        formule = null;
        $objectMap.put("formule", formule);
    }

    protected void createFormuleCategory() {
        formuleCategory = null;
        $objectMap.put("formuleCategory", formuleCategory);
    }

    protected void createParams() {
        params = new javax.swing.JTable();
        $objectMap.put("params", params);
        params.setName("params");
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $ContinuousPanelContainerUI0, "doActionPerformed__on__remove"));
    }

    protected void createSelectedEquation() {
        selectedEquation = null;
        $objectMap.put("selectedEquation", selectedEquation);
    }

    protected void createText() {
        text = null;
        $objectMap.put("text", text);
    }

}
